@echo off
setlocal
call "%~dp0setenv.bat"
ruby -x "%~f0" %*
goto :end

#!ruby
require 'service'
require 'win32/service'
require 'windows/authorization'
require 'highline/import'

PACKAGE_HOME = File.expand_path(ENV["PACKAGE_HOME"])

module Command
  def install
    Service.names.each {|name|
      if Service.exists?(name)
        warn "Error: service #{name} already exists"
        exit 1
      end
    }

    wrapper = File.join(PACKAGE_HOME, "script/service/wrapper.bat")

    Service.config.each {|key, conf|
      name = conf["service_name"]
      port = conf["port"]

      begin
        case key.to_sym
        when :apache
          httpd = File.join(PACKAGE_HOME, "apache/bin/httpd.exe")
          raise unless system(%Q["#{httpd}" -k install -n "#{name}"])
          raise unless system(%Q[sc config "#{name}" binpath= "\\"#{wrapper}\\" httpd -k runservice"])
          next
        when :redmine
          exe = File.join(PACKAGE_HOME, "script/service/redmine.exe")
          raise unless system(%Q[sc create "#{name}" binpath= "\\"#{wrapper}\\" \\"#{exe}\\"" start= auto])
        when :jenkins
          exe = File.join(PACKAGE_HOME, "script/service/jenkins.exe")
          raise unless system(%Q[sc create "#{name}" binpath= "\\"#{wrapper}\\" \\"#{exe}\\"" start= auto])
        when :opends
          opends = File.join(PACKAGE_HOME, "opends")
          exe = File.join(opends, "lib/opends_service.exe")
          raise unless system(%Q["#{exe}" create "#{opends}" "#{name}" "OpenDS"])
        else
          raise
        end

        #warn "service #{name} installed"
      rescue
        warn "Error: failed to install service #{name}"
        exit 1
      end
    }
    start
  end

  def uninstall
    stop(false)
    Service.names.each {|name|
      next unless status(name)

      begin
        Win32::Service.delete(name)
        warn "service #{name} uninstalled"
      rescue
        warn "Error: failed to uninstall service #{name}"
        exit 1
      end
    }
  end

  def start(verbose=true)
    Service.names.each {|name|
      s = Service.status(name)
      unless s
        warn "service #{name} is not installed" if verbose
        next
      end

      if s == "running"
        warn "service #{name} is already running" if verbose
        next
      end

      begin
        Win32::Service.start(name)
        sleep 0.1 while Service.status(name) == "start pending"
        raise if Service.status(name) != "running"
        warn "service #{name} started"
      rescue
        warn "Error: failed to start service #{name}"
        exit 1
      end
    }
  end

  def stop(verbose=true)
    Service.names.each {|name|
      s = Service.status(name)
      unless s
        warn "service #{name} is not installed" if verbose
        next
      end

      if s == "stopped"
        warn "service #{name} has already been stopped" if verbose
        next
      end

      begin
        Win32::Service.stop(name)
        sleep 0.1 while Service.status(name) != "stopped"
        warn "service #{name} stopped"
      rescue
        warn "Error: failed to stop service #{name}"
        exit 1
      end
    }
  end

  def restart
    stop
    start
  end

end

class Service
  extend Command

  class << self
    def usage
      warn <<EOT
Usage: service <command>

Commands:
  #{Command.instance_methods.push("status").sort.join("\n  ")}
EOT
      exit 1
    end

    def display_status
      names.each {|name|
        if s = status(name)
          warn "#{name}: #{s}"
        else
          warn "#{name}: not installed"
        end
      }
    end

    def method_missing(name, *args)
      warn "Unknown command #{name}"
      usage
    end
  end
end

(command, pause) = ARGV[0..1]
Service.usage unless command
if command == "status"
  Service.display_status
else
  Windows::Authorization.runas_admin
  Service.send(command)
end

ask("Press any key to exit ... ") {|q|
  q.character = true
  q.echo = false
} if pause

__END__
:end
