require 'win32ole'
require 'win32/shortcut'

module Windows
  module Shortcut
    MENU_DIR = File.join(WIN32OLE.new("WScript.Shell").SpecialFolders("AllUsersPrograms"), "RedmineLE")

    def self.install(options)
      service_dir = File.join(MENU_DIR, "service")
      Dir.mkdir(MENU_DIR) unless File.directory?(MENU_DIR)
      Dir.mkdir(service_dir) unless File.directory?(service_dir)

      Win32::Shortcut.new(File.join(MENU_DIR, "home.url")) {|s|
        port = options[:apache_port]
        port = port.to_s == "80" ? "" : ":#{port}"
        s.path = "http://localhost#{port}/"
      }
      Win32::Shortcut.new(File.join(MENU_DIR, "uninstall.lnk")) {|s|
        s.path = "javaw"
        s.arguments = %Q[-jar "#{File.join(options[:home], "Uninstaller/uninstaller.jar")}"]
      }

      %w[start stop restart status install uninstall].each {|command|
        Win32::Shortcut.new(File.join(service_dir, "#{command}.lnk")) {|s|
          s.path = File.join(options[:home], "script/service.bat")
          s.arguments = "#{command} pause"
        }
      }
    end

    def self.uninstall
      FileUtils.rm_rf(MENU_DIR)
    end
  end
end
