require 'yaml'
require 'win32/service'

class Service
  def self.config
    @config ||=
      YAML.load_file(File.join(ENV["PACKAGE_HOME"], "config/service.yml"))
  end

  def self.names
    @names ||= config.values.map {|h| h["service_name"]}
  end

  def self.exists?(name)
    !!(Win32::Service.status(name) rescue nil)
  end

  def self.status(name)
    s = Win32::Service.status(name) rescue nil
    s && s.current_state
  end
end

