require 'yaml'
require 'rexml/document'

module SubversionHook
  class Base
    HOME = File.expand_path(__FILE__ + "../../../../..")

    def initialize(repos)
      @repos = repos
    end

    def revision=(value)
      @type = :revision
      @number = value
    end

    def transaction=(value)
      @type = :transaction
      @number = value
    end

    def svnlook
      raise "must set revision or transaction" if @type.nil? || @number.nil?
      opt = (@type == :revision) ? "--revision" : "--transaction"
      "svnlook #{opt} #{@number}"
    end

    def binary?(path)
      s = cat(path)[0, 512]
      !!s.index("\x00") || s.count("\x00-\x07\x0b\x0e-\x1a\x1c-\x1f")*10 > s.size
    end

    def cat(path)
      @content ||= {}
      @content[path] ||= IO.popen(
        %Q[#{svnlook} cat "#{@repos}" "#{path}"], "rb") {|io| io.read}
    end

    def commit_message
      @commit_message ||= `#{svnlook} log "#{@repos}"`
    end

    def changed
      @changed ||= `#{svnlook} changed "#{@repos}"`
    end

    # :type => :binary or :text
    # :in => path
    # :extension => [".txt"]
    def changed_files(options = {})
      unless @changed_files
        @changed_files = {:all => [], :binary => [], :text => []}
        changed.each {|line|
          next unless m = line.match(/^[AU]\w*\s+(.+)$/)
          path = m[1]
          next if path[-1,1] == "/"
          
          @changed_files[:all].push(path)
          @changed_files[binary?(path) ? :binary : :text].push(path)
        }
      end
      
      list = @changed_files[options[:type]] || @changed_files[:all]
      list = list.select {|path| options[:in].to_a.any? {|inpath|
          path.index(inpath) == 0}} if options[:in]
      list = list.select {|path|
        options[:extension].include?(File.extname(path).downcase)
      } if options[:extension]
      list
    end

    def load_config
      file = File.join(@repos, "hooks/hook_config.yml")
      conf = File.file?(file) ? YAML.load_file(file) : {}
    end

    def service_config
      @service_config ||= YAML.load_file(HOME + "/config/service.yml")
    end

    def jenkins_token(job)
      file = HOME + "/jenkins/home/jobs/" + job + "/config.xml"
      return nil unless File.file?(file)
      doc = REXML::Document.new(File.new(file))
      elem = doc.elements["//authToken"]
      elem && elem.text
    end
  end
end
