/*
 * $Id: Librarian.java 2649 2009-03-11 13:16:44Z d.duponchel $
 * IzPack - Copyright 2001-2008 Julien Ponge, All Rights Reserved.
 *
 * http://izpack.org/
 * http://izpack.codehaus.org/
 *
 * Copyright 2002 Elmar Grom
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.co.ase.izpack.util;

import com.coi.tools.os.win.MSWinConstants;
import com.coi.tools.os.win.RegistryImpl;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.CleanupClient;
import com.izforge.izpack.util.Housekeeper;
import com.izforge.izpack.util.os.RegistryDefaultHandler;
import com.izforge.izpack.util.os.RegistryHandler;

/*---------------------------------------------------------------------------*/
/**
 * This class handles loading of native libraries. There must only be one
 * instance of <code>Librarian</code> per Java runtime, therefore this class is
 * implemented as a 'Singleton'. <br>
 * <br>
 * <code>Librarian</code> is capable of loading native libraries from a variety
 * of different source locations. However, you should place your library files
 * in the 'native' directory. The primary reason for supporting different source
 * locations is to facilitate testing in a development environment, without the
 * need to actually packing the application into a *.jar file.
 *
 * @author Elmar Grom
 * @version 1.0 / 1/30/02
 */
/*---------------------------------------------------------------------------*/
public class RegistryManager implements CleanupClient {

	// ------------------------------------------------------------------------
	// Variable Declarations
	// ------------------------------------------------------------------------

	/**
	 * The reference to the single instance of <code>Librarian</code>. Used in
	 * static methods in place of <code>this</code>.
	 */
	private static RegistryManager me = null;

	/*--------------------------------------------------------------------------*/
	/**
	 * This class is implemented as a 'Singleton'. Therefore the constructor is
	 * private to prevent instantiation of this class. Use
	 * <code>getInstance()</code> to obtain an instance for use. <br>
	 * <br>
	 * For more information about the 'Singleton' pattern I highly recommend the
	 * book Design Patterns by Gamma, Helm, Johnson and Vlissides ISBN
	 * 0-201-63361-2.
	 */
	/*--------------------------------------------------------------------------*/
	private RegistryManager() {
		Housekeeper.getInstance().registerForCleanup(this);
	}

	/*--------------------------------------------------------------------------*/
	/**
	 * Returns an instance of <code>Librarian</code> to use.
	 *
	 * @return an instance of <code>Librarian</code>.
	 */
	/*--------------------------------------------------------------------------*/
	public static RegistryManager getInstance() {
		if (me == null) {
			me = new RegistryManager();
		}

		return (me);
	}

	public void cleanUp() {
		try {
			AutomatedInstallData idata = AutomatedInstallData.getInstance();
			if (idata.installSuccess == false) {
				deleteRegistry();
			}
		} catch (Exception e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		}
	}

	public void deleteRegistry() throws Exception {
		// registry delete
		try {
			RegistryHandler rh = RegistryDefaultHandler.getInstance();
			String keyName = RegistryHandler.UNINSTALL_ROOT + rh.getUninstallName();
			RegistryImpl registry = new RegistryImpl();
			registry.setRoot(MSWinConstants.HKEY_LOCAL_MACHINE);
			if (registry.keyExist(keyName)) {
				registry.deleteKey(keyName);
			}
		} catch (Exception e) {
			throw e;
		}
	}
}
/*---------------------------------------------------------------------------*/
