package jp.co.ase.izpack.util;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;

import com.izforge.izpack.panels.ProcessingClient;
import com.izforge.izpack.panels.Validator;

/**
 * A validator to check whether the field content is a port .
 *
 */
public class PortRangeEmptyValidator implements Validator {

	/**
	 * ポート番号のチェックをする。
	 */
	public boolean validate(ProcessingClient client) {
		String portStr = client.getFieldContents(0);
		if (isCorrectRange(portStr) && isEmpty(portStr)) {
			return true;
		}
		return false;
	}

	/**
	 * ポート番号が正しい範囲内かチェックする。
	 * @param portStr
	 * @return
	 */
	public boolean isCorrectRange(String portStr) {
		int port = 0;

		if ("".equals(portStr)) {
			return false;
		}

		try {
			port = Integer.parseInt(portStr);
			if (port > 0 && port < 65535) {
				return true;
			}
		} catch (Exception ex) {
			return false;
		}

		return false;
	}

	/**
	 * ポート番号が使われていないかチェックする。
	 * @param portStr
	 * @return
	 */
	public boolean isEmpty(String portStr) {
		InetAddress inet = null;
		String host = "localhost";
		boolean retValue = false;
		if ((portStr == null) || (portStr.length() == 0)) {
			return false;
		}

		ServerSocket socket = null;
		try {
			inet = InetAddress.getByName(host);
			socket = new ServerSocket(Integer.parseInt(portStr), 0, inet);
			retValue = socket.getLocalPort() > 0;
			if (!retValue) {
				return false;
			}
			socket.close();
		} catch (Exception ex) {
			return false;
		} finally {
			try {
				if (socket != null) {
					socket.close();
				}
			} catch (IOException e) {
				return false;
			}
		}
		return retValue;
	}

}
