package jp.co.ase.izpack.panels;

import com.coi.tools.os.win.MSWinConstants;
import com.coi.tools.os.win.NativeLibException;
import com.coi.tools.os.win.RegDataContainer;
import com.coi.tools.os.win.RegistryImpl;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.panels.HelloPanel;
import com.izforge.izpack.util.os.RegistryDefaultHandler;
import com.izforge.izpack.util.os.RegistryHandler;

public class RedmineLEHelloPanel extends HelloPanel {

	/**
     *
     */
	private static final long serialVersionUID = 1377042770727953387L;

	/**
	 * @param parent
	 * @param idata
	 */
	public RedmineLEHelloPanel(InstallerFrame parent, InstallData idata) {
		super(parent, idata);
		if (isRegistered()) {
			setVariable(idata);
		}
	}

	protected boolean isRegistered() {
		boolean retval = false;
		try {
			// Get the default registry handler.
			RegistryHandler rh = RegistryDefaultHandler.getInstance();
			if (rh != null) {
				rh.verify(idata);
				retval = rh.isProductRegistered();
				// original add
				idata.setVariable("UNINSTALL_NAME", rh.getUninstallName());
			}
			// else we are on a os which has no registry or the
			// needed dll was not bound to this installation. In
			// both cases we forget the "already exist" check.

		} catch (Exception e) { // Will only be happen if registry handler is
			// good, but an
			// exception at performing was thrown. This is an error...
			e.printStackTrace();
		}
		return (retval);
	}

	private void setVariable(InstallData idata) {
		// original variable true when product is registered
		idata.setVariable("isProductRegistered", "true");
		//
		RegistryHandler rh = RegistryDefaultHandler.getInstance();
		String keyName = RegistryHandler.UNINSTALL_ROOT + rh.getUninstallName();
		RegistryImpl registry = new RegistryImpl();
		registry.setRoot(MSWinConstants.HKEY_LOCAL_MACHINE);
		try {
			RegDataContainer regDataContainer = registry.getValue(keyName, "InstallLocation");
			String installPath = regDataContainer.getStringData();
			idata.setVariable("INSTALL_PATH", installPath);
		} catch (NativeLibException e) {
		}
	}
}
