/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.snmp;

import com.sun.management.snmp.SnmpStatusException;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.Set;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.security.auth.Subject;
import org.opends.server.api.ClientConnection;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.internal.InternalClientConnection;
import org.opends.server.protocols.jmx.Credential;
import org.opends.server.protocols.jmx.OpendsJmxPrincipal;
import org.opends.server.types.DebugLogLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SNMPMonitor {
    private static final DebugTracer TRACER;
    private static SNMPMonitor monitor;
    private MBeanServer server;
    private Subject subject = null;
    public static ObjectName pattern;

    private SNMPMonitor(MBeanServer server) {
        this.server = server;
        this.subject = new Subject();
        this.subject.getPrincipals().add((Principal)new OpendsJmxPrincipal("cn=anonymous"));
        InternalClientConnection clientConnection = InternalClientConnection.getRootConnection();
        this.subject.getPrivateCredentials().add(new Credential((ClientConnection)clientConnection));
    }

    public static SNMPMonitor getMonitor(MBeanServer server) {
        if (monitor == null) {
            monitor = new SNMPMonitor(server);
        }
        return monitor;
    }

    public Set<ObjectName> getConnectionHandlersStatistics() {
        HashSet<ObjectName> results;
        block3: {
            results = new HashSet<ObjectName>();
            try {
                Set<ObjectName> monitorObjects = this.server.queryNames(pattern, null);
                for (ObjectName name : monitorObjects) {
                    if (!name.getCanonicalName().contains("Connection_Handler") || !name.getCanonicalName().endsWith("_Statistics")) continue;
                    results.add(name);
                }
            }
            catch (Exception ex) {
                if (!DebugLogger.debugEnabled()) break block3;
                TRACER.debugCaught(DebugLogLevel.ERROR, (Throwable)ex);
            }
        }
        return results;
    }

    public ObjectName getConnectionHandler(ObjectName statistics) {
        block5: {
            if (statistics == null) {
                return null;
            }
            try {
                String value = statistics.getCanonicalName();
                if (!value.endsWith("_Statistics")) {
                    return null;
                }
                int index = value.indexOf("_Statistics");
                String name = value.substring(0, index);
                ObjectName connectionHandlerName = new ObjectName(name);
                Set<ObjectName> query = this.server.queryNames(connectionHandlerName, null);
                if (query != null && !query.isEmpty()) {
                    return connectionHandlerName;
                }
            }
            catch (Exception ex) {
                if (!DebugLogger.debugEnabled()) break block5;
                TRACER.debugCaught(DebugLogLevel.ERROR, (Throwable)ex);
            }
        }
        return null;
    }

    public Set<ObjectName> getConnectionHandlers() {
        HashSet<ObjectName> results = new HashSet<ObjectName>();
        try {
            Set<ObjectName> monitorObjects = this.server.queryNames(pattern, null);
            for (ObjectName name : monitorObjects) {
                if (!name.getCanonicalName().contains("Connection_Handler") || name.getCanonicalName().endsWith("_Statistics")) continue;
                results.add(name);
            }
            return results;
        }
        catch (Exception ex) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, (Throwable)ex);
            }
            return results;
        }
    }

    public ObjectName getConnectionHandlerStatistics(ObjectName connectionHandlerName) {
        block4: {
            if (connectionHandlerName == null) {
                return null;
            }
            try {
                String value = connectionHandlerName.getCanonicalName().concat("_Statistics");
                ObjectName statistics = new ObjectName(value);
                Set<ObjectName> query = this.server.queryNames(statistics, null);
                if (query != null && !query.isEmpty()) {
                    return statistics;
                }
            }
            catch (Exception ex) {
                if (!DebugLogger.debugEnabled()) break block4;
                TRACER.debugCaught(DebugLogLevel.ERROR, (Throwable)ex);
            }
        }
        return null;
    }

    public Object getAttribute(String name, String attribute) {
        try {
            ObjectName objName = new ObjectName("org.opends.server:Name=" + name);
            return this.getAttribute(objName, attribute);
        }
        catch (Exception ex) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, (Throwable)ex);
            }
            return null;
        }
    }

    public Object getAttribute(final ObjectName name, final String attribute) {
        return Subject.doAs(this.subject, new PrivilegedAction(){

            public Object run() {
                block3: {
                    try {
                        Attribute attr = (Attribute)SNMPMonitor.this.server.getAttribute(name, attribute);
                        if (attr != null) {
                            return attr.getValue();
                        }
                    }
                    catch (Exception ex) {
                        if (!DebugLogger.debugEnabled()) break block3;
                        TRACER.debugCaught(DebugLogLevel.ERROR, (Throwable)ex);
                    }
                }
                return null;
            }
        });
    }

    public static Byte[] string2ByteArray(String s) {
        byte[] b = s.getBytes();
        Byte[] barray = new Byte[b.length];
        for (int index = 0; index < b.length; ++index) {
            barray[index] = new Byte(b[index]);
        }
        return barray;
    }

    public static long counter32Value(long v) {
        if (v > SNMPMonitor.pow(2L, 32L) - 1L) {
            return v % SNMPMonitor.pow(2L, 32L);
        }
        return v;
    }

    public static Long counter32Value(Long V) {
        long v = V;
        if (v > SNMPMonitor.pow(2L, 32L) - 1L) {
            return new Long(v % SNMPMonitor.pow(2L, 32L));
        }
        return V;
    }

    public static long gauge32Value(long v) {
        if (v > SNMPMonitor.pow(2L, 32L) - 1L) {
            return SNMPMonitor.pow(2L, 32L) - 1L;
        }
        return v;
    }

    public static Long gauge32Value(Long V) {
        long v = V;
        if (v > SNMPMonitor.pow(2L, 32L) - 1L) {
            return new Long(SNMPMonitor.pow(2L, 32L) - 1L);
        }
        return V;
    }

    public static Integer integerValue(Long V) throws SnmpStatusException {
        long v = V;
        if (v > SNMPMonitor.pow(2L, 31L) - 1L) {
            throw new SnmpStatusException("Returned intrumented value size too big");
        }
        Integer ret = new Integer(V.intValue());
        return ret;
    }

    private static long pow(long x, long y) {
        int j = 1;
        long k = x;
        if (y == 0L) {
            return 1L;
        }
        if (y == 1L) {
            return x;
        }
        while ((long)j < y) {
            k *= x;
            ++j;
        }
        return k;
    }

    static {
        block2: {
            TRACER = DebugLogger.getTracer();
            monitor = null;
            try {
                pattern = new ObjectName("org.opends.server:Name=rootDSE,Rdn1=cn-monitor,*");
            }
            catch (Exception ex) {
                if (!DebugLogger.debugEnabled()) break block2;
                TRACER.debugCaught(DebugLogLevel.ERROR, (Throwable)ex);
            }
        }
    }
}

