/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.snmp;

import com.sun.management.snmp.InetAddressAcl;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import org.opends.server.admin.std.server.SNMPConnectionHandlerCfg;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;

public class SNMPInetAddressAcl
implements InetAddressAcl {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private SNMPConnectionHandlerCfg currentConfig;
    private static final String ALL_MANAGERS_ALLOWED = "*";
    private TreeSet<InetAddress> hostsList;
    private boolean allManagers = false;
    private SortedSet<String> trapsDestinations;
    private String trapsCommunity;
    private String communities;

    public SNMPInetAddressAcl(SNMPConnectionHandlerCfg configuration) {
        this.currentConfig = configuration;
        SortedSet tmp = this.currentConfig.getAllowedManager();
        if (tmp.contains(ALL_MANAGERS_ALLOWED)) {
            this.allManagers = true;
        }
        this.hostsList = new TreeSet();
        Iterator iter = tmp.iterator();
        while (iter.hasNext()) {
            try {
                String dest = (String)iter.next();
                this.hostsList.add(InetAddress.getByName(dest));
            }
            catch (UnknownHostException ex) {}
        }
        this.trapsDestinations = this.currentConfig.getTrapsDestination();
        this.communities = this.currentConfig.getCommunity();
        this.trapsCommunity = this.currentConfig.getTrapsCommunity();
    }

    public String getName() {
        return "OpenDS";
    }

    public boolean checkReadPermission(InetAddress address) {
        if (this.allManagers) {
            return true;
        }
        if (this.hostsList == null || this.hostsList.isEmpty()) {
            return false;
        }
        boolean found = false;
        for (InetAddress host : this.hostsList) {
            if (!host.equals(address)) continue;
            found = true;
            break;
        }
        return found;
    }

    public boolean checkReadPermission(InetAddress address, String community) {
        return this.checkReadPermission(address) && this.checkCommunity(community);
    }

    public boolean checkCommunity(String community) {
        return this.communities.equals(community);
    }

    public boolean checkWritePermission(InetAddress address) {
        return false;
    }

    public boolean checkWritePermission(InetAddress address, String community) {
        return false;
    }

    public Enumeration getTrapDestinations() {
        Vector<InetAddress> tempDests = new Vector<InetAddress>();
        Iterator iter = this.trapsDestinations.iterator();
        while (iter.hasNext()) {
            try {
                String dest = (String)iter.next();
                InetAddress addr = InetAddress.getByName(dest);
                tempDests.add(addr);
            }
            catch (UnknownHostException unknownHostException) {}
        }
        return tempDests.elements();
    }

    public Enumeration getTrapCommunities(InetAddress address) {
        Vector<String> trapCommunities = new Vector<String>();
        trapCommunities.add(this.trapsCommunity);
        return trapCommunities.elements();
    }

    public Enumeration getInformDestinations() {
        Vector informDests = new Vector();
        return informDests.elements();
    }

    public Enumeration getInformCommunities(InetAddress address) {
        Vector informCommunities = new Vector();
        return informCommunities.elements();
    }
}

