/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup.util;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.opends.messages.Message;
import org.opends.quicksetup.util.Utils;
import org.opends.quicksetup.util.WebBrowserException;

public class WebBrowserLauncher {
    public static void openURL(String url) throws WebBrowserException {
        try {
            if (Utils.isMacOS()) {
                Class<?> fileMgr = Class.forName("com.apple.eio.FileManager");
                Method openURL = fileMgr.getDeclaredMethod("openURL", String.class);
                openURL.invoke(null, url);
            } else if (Utils.isWindows()) {
                String[] cmd = new String[]{"rundll32", "url.dll,FileProtocolHandler", url};
                Runtime.getRuntime().exec(cmd);
            } else {
                String[] browsers = new String[]{"firefox", "opera", "konqueror", "epiphany", "mozilla", "netscape"};
                String browser = null;
                for (int count = 0; count < browsers.length && browser == null; ++count) {
                    if (Runtime.getRuntime().exec(new String[]{"which", browsers[count]}).waitFor() != 0) continue;
                    browser = browsers[count];
                }
                if (browser == null) {
                    throw new WebBrowserException(url, Message.raw("Could not find web browser", new Object[0]), null);
                }
                Runtime.getRuntime().exec(new String[]{browser, url});
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new WebBrowserException(url, Message.raw("Class Not Found Exception", new Object[0]), cnfe);
        }
        catch (IOException ioe) {
            throw new WebBrowserException(url, Message.raw("IO Exception", new Object[0]), ioe);
        }
        catch (InterruptedException ie) {
            throw new WebBrowserException(url, Message.raw("Interrupted Exception", new Object[0]), ie);
        }
        catch (NoSuchMethodException nsme) {
            throw new WebBrowserException(url, Message.raw("No Such Method Exception", new Object[0]), nsme);
        }
        catch (InvocationTargetException ite) {
            throw new WebBrowserException(url, Message.raw("Invocation Target Exception", new Object[0]), ite);
        }
        catch (IllegalAccessException iae) {
            throw new WebBrowserException(url, Message.raw("Illegal Access Exception", new Object[0]), iae);
        }
    }
}

