/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.opends.messages.Message;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.event.MinimumSizeComponentListener;
import org.opends.quicksetup.ui.UIFactory;
import org.opends.quicksetup.util.HtmlProgressMessageFormatter;
import org.opends.quicksetup.util.ProgressMessageFormatter;

public class ProgressDialog
extends JDialog {
    private static final long serialVersionUID = 8635080171100378470L;
    private JEditorPane progressBarLabel;
    private JProgressBar progressBar;
    private JEditorPane detailsTextArea;
    private JScrollPane scroll;
    private Message lastText;
    private JFrame parent;
    private JButton closeButton;
    private Message panelTitle = QuickSetupMessages.INFO_PROGRESS_TITLE.get();
    private ProgressMessageFormatter formatter = new HtmlProgressMessageFormatter();

    public ProgressDialog(JFrame frame) {
        super(frame);
        this.parent = frame;
        this.setTitle(QuickSetupMessages.INFO_PROGRESS_DIALOG_TITLE.get().toString());
        this.createLayout();
    }

    public void pack() {
        this.setPreferredSize(new Dimension(500, 300));
        this.addComponentListener(new MinimumSizeComponentListener(this, 500, 300));
        super.pack();
        this.closeButton.requestFocusInWindow();
        this.getRootPane().setDefaultButton(this.closeButton);
    }

    public JFrame getFrame() {
        return this.parent;
    }

    public void setPanelTitle(Message title) {
        this.panelTitle = title;
    }

    public Message getPanelTitle() {
        return this.panelTitle;
    }

    public void setCloseButtonEnabled(boolean enable) {
        this.closeButton.setEnabled(enable);
    }

    public void setSummary(Message text) {
        if (text != null) {
            this.progressBarLabel.setText(text.toString());
        } else {
            this.progressBarLabel.setText(null);
        }
    }

    public void setDetails(Message text) {
        if (text != null) {
            this.detailsTextArea.setText(text.toString());
        } else {
            this.detailsTextArea.setText(null);
        }
    }

    private ProgressMessageFormatter getFormatter() {
        if (this.formatter == null) {
            this.formatter = new HtmlProgressMessageFormatter();
        }
        return this.formatter;
    }

    private void createLayout() {
        JPanel titlePanel = new JPanel(new GridBagLayout());
        titlePanel.setOpaque(false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 0.0;
        gbc.gridwidth = -1;
        Message title = this.getPanelTitle();
        JLabel l = UIFactory.makeJLabel(UIFactory.IconType.NO_ICON, title, UIFactory.TextStyle.TITLE);
        l.setOpaque(false);
        titlePanel.add((Component)l, gbc);
        gbc.weightx = 1.0;
        gbc.gridwidth = 0;
        titlePanel.add(Box.createHorizontalGlue(), gbc);
        JPanel mainPanel = new JPanel(new GridBagLayout());
        mainPanel.setOpaque(false);
        gbc.insets = UIFactory.getEmptyInsets();
        gbc.anchor = 18;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        mainPanel.add((Component)titlePanel, gbc);
        gbc.insets.top = 5;
        this.progressBarLabel = UIFactory.makeHtmlPane(QuickSetupMessages.INFO_PROGRESSBAR_INITIAL_LABEL.get(), UIFactory.PROGRESS_FONT);
        this.progressBarLabel.setOpaque(false);
        this.progressBarLabel.setEditable(false);
        mainPanel.add((Component)this.progressBarLabel, gbc);
        gbc.insets.top = 5;
        gbc.insets.bottom = 10;
        mainPanel.add((Component)this.createProgressBarPanel(), gbc);
        this.progressBar.setToolTipText(QuickSetupMessages.INFO_PROGRESSBAR_TOOLTIP.get().toString());
        l = UIFactory.makeJLabel(UIFactory.IconType.NO_ICON, QuickSetupMessages.INFO_PROGRESS_DETAILS_LABEL.get(), UIFactory.TextStyle.SECONDARY_FIELD_VALID);
        gbc.insets = UIFactory.getEmptyInsets();
        mainPanel.add((Component)l, gbc);
        this.scroll = new JScrollPane();
        this.detailsTextArea = UIFactory.makeProgressPane(this.scroll);
        this.detailsTextArea.setBackground(UIFactory.CURRENT_STEP_PANEL_BACKGROUND);
        this.detailsTextArea.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    String url = e.getURL().toString();
                    Message newText = ProgressDialog.this.getFormatter().getFormattedAfterUrlClick(url, ProgressDialog.this.lastText);
                    ProgressDialog.this.lastText = newText;
                    ProgressDialog.this.setDetails(ProgressDialog.this.lastText);
                }
            }
        });
        this.detailsTextArea.setAutoscrolls(true);
        this.scroll.setViewportView(this.detailsTextArea);
        this.scroll.setBorder(UIFactory.TEXT_AREA_BORDER);
        this.scroll.setWheelScrollingEnabled(true);
        l.setLabelFor(this.detailsTextArea);
        gbc.insets.top = 4;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        mainPanel.add((Component)this.scroll, gbc);
        JPanel buttonsPanel = new JPanel(new GridBagLayout());
        buttonsPanel.setBackground(UIFactory.DEFAULT_BACKGROUND);
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = UIFactory.getEmptyInsets();
        gbc.gridwidth = -1;
        buttonsPanel.add(Box.createHorizontalGlue(), gbc);
        this.closeButton = UIFactory.makeJButton(QuickSetupMessages.INFO_CLOSE_BUTTON_LABEL.get(), QuickSetupMessages.INFO_CLOSE_PROGRESS_BUTTON_TOOLTIP.get());
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.gridwidth = 0;
        buttonsPanel.add((Component)this.closeButton, gbc);
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                ProgressDialog.this.dispose();
            }
        });
        JPanel p = new JPanel(new GridBagLayout());
        p.setBackground(UIFactory.DEFAULT_BACKGROUND);
        gbc.insets = UIFactory.getEmptyInsets();
        gbc.fill = 1;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = UIFactory.getEmptyInsets();
        JPanel p1 = new JPanel(new GridBagLayout());
        p1.setBackground(UIFactory.CURRENT_STEP_PANEL_BACKGROUND);
        p1.setBorder(UIFactory.DIALOG_PANEL_BORDER);
        gbc.insets = UIFactory.getCurrentStepPanelInsets();
        p1.add((Component)mainPanel, gbc);
        gbc.insets = UIFactory.getEmptyInsets();
        p.add((Component)p1, gbc);
        gbc.weighty = 0.0;
        gbc.insets = UIFactory.getButtonsPanelInsets();
        p.add((Component)buttonsPanel, gbc);
        this.getContentPane().add(p);
    }

    private JPanel createProgressBarPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = UIFactory.getEmptyInsets();
        gbc.fill = 2;
        this.progressBar = new JProgressBar();
        this.progressBar.setIndeterminate(true);
        this.progressBar.setMaximum(100);
        gbc.gridwidth = -1;
        gbc.weightx = 0.0;
        panel.add(Box.createHorizontalStrut(220), gbc);
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        panel.add(Box.createHorizontalGlue(), gbc);
        gbc.gridwidth = -1;
        gbc.weightx = 0.0;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        panel.add(Box.createHorizontalGlue(), gbc);
        return panel;
    }

    public static void main(String[] args) {
        try {
            ProgressDialog dlg = new ProgressDialog(new JFrame());
            dlg.pack();
            dlg.setVisible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

