/*
 * Decompiled with CFR 0.152.
 */
package org.opends.admin.ads;

import org.opends.messages.Message;
import org.opends.server.types.OpenDsException;

public class ADSContextException
extends OpenDsException {
    private static final long serialVersionUID = 1984039711031042813L;
    private String toString;
    ErrorType error;
    Throwable embeddedException;

    public ADSContextException(ErrorType errorType) {
        this.error = errorType;
    }

    public ADSContextException(ErrorType errorType, Throwable throwable) {
        this.error = errorType;
        this.embeddedException = throwable;
    }

    public ErrorType getError() {
        return this.error;
    }

    public Throwable getCause() {
        return this.embeddedException;
    }

    public Message getReason() {
        if (this.toString == null) {
            this.toString = "ADSContextException: error type " + (Object)((Object)this.error) + ".";
            if (this.getCause() != null) {
                this.toString = this.toString + "  Root cause: " + this.getCause().toString();
            }
        }
        return Message.raw(this.toString, new Object[0]);
    }

    public void printStackTrace() {
        super.printStackTrace();
        if (this.embeddedException != null) {
            System.out.println("embeddedException = {");
            this.embeddedException.printStackTrace();
            System.out.println("}");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ErrorType {
        MISSING_HOSTNAME,
        NOVALID_HOSTNAME,
        MISSING_IPATH,
        NOVALID_IPATH,
        ACCESS_PERMISSION,
        ALREADY_REGISTERED,
        BROKEN_INSTALL,
        NOT_YET_REGISTERED,
        MISSING_PORT,
        NOVALID_PORT,
        MISSING_NAME,
        MISSING_ADMIN_UID,
        MISSING_ADMIN_PASSWORD,
        UNEXPECTED_ADS_BACKEND_TYPE,
        ERROR_UNEXPECTED;

    }
}

