/*
 * Decompiled with CFR 0.152.
 */
package com.birosoft.liquid;

import com.birosoft.liquid.LiquidLookAndFeel;
import com.birosoft.liquid.LiquidScrollButton;
import com.birosoft.liquid.skin.Skin;
import com.birosoft.liquid.skin.SkinSimpleButtonIndexModel;
import com.birosoft.liquid.util.Colors;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.text.View;

public class LiquidTabbedPaneUI
extends BasicTabbedPaneUI {
    static Skin skinTop;
    static Skin skinLeft;
    static Skin skinRight;
    static Skin skinBottom;
    static Skin skinBorder;
    static Skin skinBorderBottom;
    static Skin skinBorderVertical;
    SkinSimpleButtonIndexModel indexModel = new SkinSimpleButtonIndexModel();
    static BasicStroke focusStroke;
    int rollover = -1;
    MouseMotionListener mouseMotionHandler = null;

    public static ComponentUI createUI(JComponent c) {
        return new LiquidTabbedPaneUI();
    }

    protected void installListeners() {
        super.installListeners();
        this.mouseMotionHandler = new MyMouseHandler();
        this.tabPane.addMouseMotionListener(this.mouseMotionHandler);
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        this.tabPane.removeMouseMotionListener(this.mouseMotionHandler);
    }

    protected boolean scrollableTabLayoutEnabled() {
        return this.tabPane.getTabLayoutPolicy() == 1;
    }

    private void ensureCurrentLayout() {
        if (!this.tabPane.isValid()) {
            this.tabPane.validate();
        }
        if (!this.tabPane.isValid()) {
            BasicTabbedPaneUI.TabbedPaneLayout layout = (BasicTabbedPaneUI.TabbedPaneLayout)this.tabPane.getLayout();
            layout.calculateLayoutInfo();
        }
    }

    private int getTabAtLocation(int x, int y) {
        this.ensureCurrentLayout();
        if (LiquidLookAndFeel.isPreTiger()) {
            int tabCount = this.tabPane.getTabCount();
            for (int i = 0; i < tabCount; ++i) {
                if (!this.rects[i].contains(x, y)) continue;
                return i;
            }
            return -1;
        }
        return this.tabForCoordinate(this.tabPane, x, y);
    }

    protected JButton createScrollButton(int direction) {
        if (direction != 5 && direction != 1 && direction != 3 && direction != 7) {
            throw new IllegalArgumentException("Direction must be one of: SOUTH, NORTH, EAST or WEST");
        }
        return new LiquidScrollableTabButton(direction);
    }

    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
    }

    protected void paintContentBorder(Graphics g, int tabPlacement, int selectedIndex) {
        int width = this.tabPane.getWidth();
        int height = this.tabPane.getHeight();
        Insets insets = this.tabPane.getInsets();
        Insets contentInsets = this.getContentBorderInsets(tabPlacement);
        int x = insets.left;
        int y = insets.top;
        int w = width - insets.right - insets.left;
        int h = height - insets.top - insets.bottom;
        switch (tabPlacement) {
            case 2: {
                w -= (x += this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth)) - insets.left;
                break;
            }
            case 4: {
                w -= this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth);
                break;
            }
            case 3: {
                h -= y - insets.top + this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight);
                break;
            }
            default: {
                h -= (y += this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight)) - insets.top;
            }
        }
        Color oldColor = g.getColor();
        Color inBorderClr = new Color(198, 214, 252);
        Color grayBorderClr = new Color(145, 155, 156);
        Color darkShadowClr = new Color(208, 206, 191);
        Color lightShadowClr = new Color(227, 224, 208);
        if (tabPlacement == 3) {
            this.getSkinBorder().draw(g, 0, x, h - contentInsets.bottom, w, contentInsets.bottom);
            g.setColor(inBorderClr);
            g.drawLine(w - contentInsets.right, y + contentInsets.top - 2, w - contentInsets.right, y + h - contentInsets.bottom - 1);
            g.drawLine(w - contentInsets.right + 1, y + contentInsets.top - 2, w - contentInsets.right + 1, y + h - contentInsets.bottom - 1);
            g.setColor(grayBorderClr);
            g.drawLine(w - contentInsets.right + 2, y + contentInsets.top - 2, w - contentInsets.right + 2, y + h - contentInsets.bottom - 1);
            g.setColor(grayBorderClr);
            g.drawLine(x + 1, y + contentInsets.top - 2, x + 1, y + h - contentInsets.bottom - 1);
            g.setColor(inBorderClr);
            g.drawLine(x + 2, y + contentInsets.top - 2, x + 2, y + h - contentInsets.bottom - 1);
            g.drawLine(x + 3, y + contentInsets.top - 2, x + 3, y + h - contentInsets.bottom - 1);
            g.setColor(grayBorderClr);
            g.drawLine(x + 1, y + 1, w - contentInsets.right + 2, y + 1);
            g.setColor(inBorderClr);
            g.drawLine(x + 2, y + 2, w - contentInsets.right, y + 2);
            g.drawLine(x + 2, y + 3, w - contentInsets.right, y + 3);
        }
        if (tabPlacement == 1) {
            this.getSkinBorder().draw(g, 0, x, y, w, 5);
            g.setColor(inBorderClr);
            g.drawLine(w - contentInsets.right, y + contentInsets.top, w - contentInsets.right, y + h - contentInsets.bottom + 1);
            g.drawLine(w - contentInsets.right + 1, y + contentInsets.top, w - contentInsets.right + 1, y + h - contentInsets.bottom + 1);
            g.setColor(grayBorderClr);
            g.drawLine(w - contentInsets.right + 2, y + contentInsets.top, w - contentInsets.right + 2, y + h - contentInsets.bottom + 1);
            g.setColor(grayBorderClr);
            g.drawLine(x + 1, y + contentInsets.top, x + 1, y + h - contentInsets.bottom + 1);
            g.setColor(inBorderClr);
            g.drawLine(x + 2, y + contentInsets.top, x + 2, y + h - contentInsets.bottom + 1);
            g.drawLine(x + 3, y + contentInsets.top, x + 3, y + h - contentInsets.bottom + 1);
            g.setColor(inBorderClr);
            g.drawLine(x + contentInsets.left, height - contentInsets.bottom, w - contentInsets.right - 1, height - contentInsets.bottom);
            g.drawLine(x + contentInsets.left, height - contentInsets.bottom + 1, w - contentInsets.right - 1, height - contentInsets.bottom + 1);
            g.setColor(grayBorderClr);
            g.drawLine(x + 1, height - contentInsets.bottom + 2, w - contentInsets.right + 2, height - contentInsets.bottom + 2);
            g.setColor(darkShadowClr);
            g.drawLine(x + 1, height - contentInsets.bottom + 3, w - contentInsets.right + 2, height - contentInsets.bottom + 3);
            g.drawLine(x + 1, height - contentInsets.bottom + 4, w - contentInsets.right + 2, height - contentInsets.bottom + 4);
            g.setColor(lightShadowClr);
            g.drawLine(x + 1, height - contentInsets.bottom + 5, w - contentInsets.right + 2, height - contentInsets.bottom + 5);
        }
        if (tabPlacement == 4) {
            this.getSkinBorderVertical().draw(g, 0, w - 5, y, 5, h);
            g.setColor(grayBorderClr);
            g.drawLine(x + 1, y + contentInsets.top - 2, x + 1, y + h - contentInsets.bottom + 1);
            g.setColor(inBorderClr);
            g.drawLine(x + 2, y + contentInsets.top, x + 2, y + h - contentInsets.bottom);
            g.drawLine(x + 3, y + contentInsets.top, x + 3, y + h - contentInsets.bottom);
            g.setColor(grayBorderClr);
            g.drawLine(x + 1, y + 1, w - contentInsets.right - 1, y + 1);
            g.setColor(inBorderClr);
            g.drawLine(x + 2, y + 2, w - contentInsets.right - 1, y + 2);
            g.drawLine(x + 2, y + 3, w - contentInsets.right - 1, y + 3);
            g.setColor(inBorderClr);
            g.drawLine(x + 2, height - contentInsets.bottom, w - contentInsets.right - 1, height - contentInsets.bottom);
            g.drawLine(x + 2, height - contentInsets.bottom + 1, w - contentInsets.right - 1, height - contentInsets.bottom + 1);
            g.setColor(grayBorderClr);
            g.drawLine(x + 1, height - contentInsets.bottom + 2, w - contentInsets.right - 1, height - contentInsets.bottom + 2);
            g.setColor(darkShadowClr);
            g.drawLine(x + 1, height - contentInsets.bottom + 3, w - contentInsets.right - 1, height - contentInsets.bottom + 3);
            g.drawLine(x + 1, height - contentInsets.bottom + 4, w - contentInsets.right - 1, height - contentInsets.bottom + 4);
            g.setColor(lightShadowClr);
            g.drawLine(x + 1, height - contentInsets.bottom + 5, w - contentInsets.right - 1, height - contentInsets.bottom + 5);
        }
        if (tabPlacement == 2) {
            this.getSkinBorderVertical().draw(g, 0, x, y, 5, h);
            g.setColor(inBorderClr);
            g.drawLine(width - contentInsets.right, y + contentInsets.top - 1, width - contentInsets.right, y + h - contentInsets.bottom);
            g.drawLine(width - contentInsets.right + 1, y + contentInsets.top - 2, width - contentInsets.right + 1, y + h - contentInsets.bottom + 1);
            g.setColor(grayBorderClr);
            g.drawLine(width - contentInsets.right + 2, y + contentInsets.top - 3, width - contentInsets.right + 2, y + h - contentInsets.bottom + 2);
            g.setColor(grayBorderClr);
            g.drawLine(x + contentInsets.left, y + 1, width - contentInsets.right + 1, y + 1);
            g.setColor(inBorderClr);
            g.drawLine(x + contentInsets.left, y + 2, width - contentInsets.right, y + 2);
            g.drawLine(x + contentInsets.left, y + 3, width - contentInsets.right, y + 3);
            g.setColor(inBorderClr);
            g.drawLine(x + contentInsets.left, height - contentInsets.bottom, width - contentInsets.right, height - contentInsets.bottom);
            g.drawLine(x + contentInsets.left, height - contentInsets.bottom + 1, width - contentInsets.right, height - contentInsets.bottom + 1);
            g.setColor(grayBorderClr);
            g.drawLine(x + contentInsets.left, height - contentInsets.bottom + 2, width - contentInsets.right + 2, height - contentInsets.bottom + 2);
            g.setColor(darkShadowClr);
            g.drawLine(x + contentInsets.left, height - contentInsets.bottom + 3, width - contentInsets.right + 1, height - contentInsets.bottom + 3);
            g.drawLine(x + contentInsets.left, height - contentInsets.bottom + 4, width - contentInsets.right + 1, height - contentInsets.bottom + 4);
            g.setColor(lightShadowClr);
            g.drawLine(x + contentInsets.left, height - contentInsets.bottom + 5, width - contentInsets.right + 1, height - contentInsets.bottom + 5);
        }
        g.setColor(oldColor);
    }

    protected void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        int index = this.indexModel.getIndexForState(this.tabPane.isEnabledAt(tabIndex), this.rollover == tabIndex, isSelected);
        switch (tabPlacement) {
            case 2: {
                this.getSkinLeft().draw(g, index, x, y, w, h - 1);
                break;
            }
            case 4: {
                this.getSkinRight().draw(g, index, x, y, w, h - 1);
                break;
            }
            case 3: {
                this.getSkinBottom().draw(g, index, x, y, w, h);
                break;
            }
            default: {
                this.getSkinTop().draw(g, index, x, y, w, h);
            }
        }
    }

    protected void paintText(Graphics g, int tabPlacement, Font font, FontMetrics metrics, int tabIndex, String title, Rectangle textRect, boolean isSelected) {
        int yOffset = 0;
        if (tabPlacement == 1 && isSelected) {
            yOffset = 1;
        }
        if (tabPlacement == 3) {
            yOffset = isSelected ? -2 : -1;
        }
        g.setFont(font);
        View v = this.getTextViewForTab(tabIndex);
        if (v != null) {
            textRect.y += yOffset;
            v.paint(g, textRect);
        } else {
            int mnemIndex = this.tabPane.getDisplayedMnemonicIndexAt(tabIndex);
            if (this.tabPane.isEnabled() && this.tabPane.isEnabledAt(tabIndex)) {
                g.setColor(this.tabPane.getForegroundAt(tabIndex));
                BasicGraphicsUtils.drawStringUnderlineCharAt(g, title, mnemIndex, textRect.x, textRect.y + metrics.getAscent() + yOffset);
            } else {
                g.setColor(this.tabPane.getBackgroundAt(tabIndex).brighter());
                BasicGraphicsUtils.drawStringUnderlineCharAt(g, title, mnemIndex, textRect.x, textRect.y + metrics.getAscent());
                g.setColor(this.tabPane.getBackgroundAt(tabIndex).darker());
                BasicGraphicsUtils.drawStringUnderlineCharAt(g, title, mnemIndex, textRect.x - 1, textRect.y + metrics.getAscent() - 1);
            }
        }
    }

    public void paint(Graphics g, JComponent c) {
        int width = this.tabPane.getWidth();
        int height = this.tabPane.getHeight();
        Insets insets = this.tabPane.getInsets();
        int x = insets.left;
        int y = insets.top;
        int w = width - insets.right - insets.left;
        int h = height - insets.top - insets.bottom;
        int tabPlacement = this.tabPane.getTabPlacement();
        Insets contentInsets = this.getContentBorderInsets(tabPlacement);
        if (tabPlacement == 3) {
            Color oldColor = g.getColor();
            Color bg = LiquidLookAndFeel.getBackgroundColor();
            if (c.isOpaque()) {
                g.setColor(bg);
                g.fillRect(0, 0, c.getWidth(), c.getHeight());
            }
            if (LiquidLookAndFeel.areStipplesUsed()) {
                Colors.drawStipples(g, c, bg);
            }
            g.setColor(oldColor);
        }
        if (tabPlacement == 1 && LiquidLookAndFeel.areStipplesUsed()) {
            c.setOpaque(false);
        }
        super.paint(g, c);
    }

    public void update(Graphics g, JComponent c) {
        this.paint(g, c);
    }

    protected int getTabLabelShiftX(int tabPlacement, int tabIndex, boolean isSelected) {
        Rectangle tabRect = this.rects[tabIndex];
        int nudge = 0;
        switch (tabPlacement) {
            case 2: {
                nudge = isSelected ? -1 : 1;
                break;
            }
            case 4: {
                nudge = isSelected ? 1 : -1;
                break;
            }
            default: {
                nudge = 0;
            }
        }
        return nudge;
    }

    protected int getTabLabelShiftY(int tabPlacement, int tabIndex, boolean isSelected) {
        Rectangle tabRect = this.rects[tabIndex];
        int nudge = 0;
        switch (tabPlacement) {
            case 3: {
                nudge = isSelected ? 1 : -1;
                break;
            }
            case 2: 
            case 4: {
                nudge = tabRect.height % 2;
                break;
            }
            default: {
                nudge = isSelected ? -1 : 1;
            }
        }
        return nudge;
    }

    protected Insets getContentBorderInsets(int tabPlacement) {
        Insets contentBorderInsets = new Insets(4, 4, 4, 4);
        switch (tabPlacement) {
            case 1: {
                contentBorderInsets.top = 5;
                contentBorderInsets.bottom = 6;
                break;
            }
            case 3: {
                contentBorderInsets.bottom = 6;
                break;
            }
            case 2: {
                contentBorderInsets.left = 5;
                contentBorderInsets.bottom = 6;
                break;
            }
            case 4: {
                contentBorderInsets.right = 5;
                contentBorderInsets.bottom = 6;
            }
        }
        return contentBorderInsets;
    }

    public Skin getSkinTop() {
        if (skinTop == null) {
            skinTop = new Skin("tabtop.png", 4, 7, 6, 7, 2);
        }
        return skinTop;
    }

    public Skin getSkinLeft() {
        if (skinLeft == null) {
            skinLeft = new Skin("tableft.png", 4, 6, 7, 2, 7);
        }
        return skinLeft;
    }

    public Skin getSkinRight() {
        if (skinRight == null) {
            skinRight = new Skin("tabright.png", 4, 2, 7, 6, 7);
        }
        return skinRight;
    }

    public Skin getSkinBottom() {
        if (skinBottom == null) {
            skinBottom = new Skin("tabbottom.png", 4, 6, 7, 6, 2);
        }
        return skinBottom;
    }

    public Skin getSkinBorder() {
        if (skinBorder == null) {
            skinBorder = new Skin("tabborderh.png", 1, 5, 2, 5, 2);
        }
        return skinBorder;
    }

    public Skin getSkinBorderVertical() {
        if (skinBorderVertical == null) {
            skinBorderVertical = new Skin("tabborderv.png", 1, 2, 5, 2, 5);
        }
        return skinBorderVertical;
    }

    public Skin getSkinBorderBottom() {
        if (skinBorderBottom == null) {
            skinBorderBottom = new Skin("tabborderbottom.png", 1, 5, 0, 5, 0);
        }
        return skinBorderBottom;
    }

    static {
        focusStroke = new BasicStroke(1.0f, 0, 2, 1.0f, new float[]{1.0f}, 1.0f);
    }

    public class MyMouseHandler
    implements MouseListener,
    MouseMotionListener {
        public void mousePressed(MouseEvent e) {
            if (!LiquidTabbedPaneUI.this.tabPane.isEnabled()) {
                return;
            }
            int tabIndex = LiquidTabbedPaneUI.this.getTabAtLocation(e.getX(), e.getY());
            if (tabIndex >= 0 && LiquidTabbedPaneUI.this.tabPane.isEnabledAt(tabIndex)) {
                if (tabIndex == LiquidTabbedPaneUI.this.tabPane.getSelectedIndex()) {
                    if (LiquidTabbedPaneUI.this.tabPane.isRequestFocusEnabled()) {
                        LiquidTabbedPaneUI.this.tabPane.requestFocus();
                        LiquidTabbedPaneUI.this.tabPane.repaint(LiquidTabbedPaneUI.this.getTabBounds(LiquidTabbedPaneUI.this.tabPane, tabIndex));
                    }
                } else {
                    LiquidTabbedPaneUI.this.tabPane.setSelectedIndex(tabIndex);
                }
            }
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
            if (LiquidTabbedPaneUI.this.rollover != -1 && LiquidTabbedPaneUI.this.rollover < LiquidTabbedPaneUI.this.tabPane.getTabCount()) {
                int oldRollover = LiquidTabbedPaneUI.this.rollover;
                LiquidTabbedPaneUI.this.rollover = -1;
                LiquidTabbedPaneUI.this.tabPane.repaint(LiquidTabbedPaneUI.this.getTabBounds(LiquidTabbedPaneUI.this.tabPane, oldRollover));
            }
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseDragged(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
            if (LiquidTabbedPaneUI.this.tabPane == null) {
                return;
            }
            if (!LiquidTabbedPaneUI.this.tabPane.isEnabled()) {
                return;
            }
            int tabIndex = LiquidTabbedPaneUI.this.getTabAtLocation(e.getX(), e.getY());
            if (tabIndex >= 0 && tabIndex != LiquidTabbedPaneUI.this.rollover && LiquidTabbedPaneUI.this.rollover != -1 && LiquidTabbedPaneUI.this.rollover >= 0 && LiquidTabbedPaneUI.this.rollover < LiquidTabbedPaneUI.this.tabPane.getTabCount()) {
                LiquidTabbedPaneUI.this.tabPane.repaint(LiquidTabbedPaneUI.this.getTabBounds(LiquidTabbedPaneUI.this.tabPane, LiquidTabbedPaneUI.this.rollover));
            }
            if (tabIndex >= 0 && LiquidTabbedPaneUI.this.tabPane.isEnabledAt(tabIndex) && tabIndex < LiquidTabbedPaneUI.this.tabPane.getTabCount()) {
                if (tabIndex != LiquidTabbedPaneUI.this.rollover) {
                    LiquidTabbedPaneUI.this.rollover = tabIndex;
                    LiquidTabbedPaneUI.this.tabPane.repaint(LiquidTabbedPaneUI.this.getTabBounds(LiquidTabbedPaneUI.this.tabPane, tabIndex));
                }
            } else if (tabIndex == -1 && LiquidTabbedPaneUI.this.rollover != -1 && LiquidTabbedPaneUI.this.rollover < LiquidTabbedPaneUI.this.tabPane.getTabCount()) {
                int oldRollover = LiquidTabbedPaneUI.this.rollover;
                LiquidTabbedPaneUI.this.rollover = -1;
                LiquidTabbedPaneUI.this.tabPane.repaint(LiquidTabbedPaneUI.this.getTabBounds(LiquidTabbedPaneUI.this.tabPane, oldRollover));
            }
        }
    }

    private class LiquidScrollableTabButton
    extends LiquidScrollButton
    implements UIResource {
        public LiquidScrollableTabButton(int direction) {
            super(direction, 10, true);
            this.setEnabled(false);
        }
    }
}

