/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.util.args;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.LinkedHashMap;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.UtilityMessages;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.Argument;
import org.opends.server.util.args.ArgumentException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileBasedArgument
extends Argument {
    private LinkedHashMap<String, String> namesToValues = new LinkedHashMap();

    public FileBasedArgument(String name, Character shortIdentifier, String longIdentifier, boolean isRequired, Message valuePlaceholder, Message description) throws ArgumentException {
        super(name, shortIdentifier, longIdentifier, isRequired, false, true, valuePlaceholder, null, null, description);
    }

    public FileBasedArgument(String name, Character shortIdentifier, String longIdentifier, boolean isRequired, boolean isMultiValued, Message valuePlaceholder, String defaultValue, String propertyName, Message description) throws ArgumentException {
        super(name, shortIdentifier, longIdentifier, isRequired, isMultiValued, true, valuePlaceholder, defaultValue, propertyName, description);
    }

    public LinkedHashMap<String, String> getNameToValueMap() {
        return this.namesToValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean valueIsAcceptable(String valueString, MessageBuilder invalidReason) {
        String line;
        BufferedReader reader;
        File valueFile;
        try {
            valueFile = new File(valueString);
            if (!valueFile.exists()) {
                invalidReason.append(UtilityMessages.ERR_FILEARG_NO_SUCH_FILE.get(valueString, this.getName()));
                return false;
            }
        }
        catch (Exception e) {
            invalidReason.append(UtilityMessages.ERR_FILEARG_CANNOT_VERIFY_FILE_EXISTENCE.get(valueString, this.getName(), StaticUtils.getExceptionMessage(e)));
            return false;
        }
        try {
            reader = new BufferedReader(new FileReader(valueFile));
        }
        catch (Exception e) {
            invalidReason.append(UtilityMessages.ERR_FILEARG_CANNOT_OPEN_FILE.get(valueString, this.getName(), StaticUtils.getExceptionMessage(e)));
            return false;
        }
        try {
            line = reader.readLine();
        }
        catch (Exception e) {
            invalidReason.append(UtilityMessages.ERR_FILEARG_CANNOT_READ_FILE.get(valueString, this.getName(), StaticUtils.getExceptionMessage(e)));
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception e) {}
        }
        if (line == null) {
            invalidReason.append(UtilityMessages.ERR_FILEARG_EMPTY_FILE.get(valueString, this.getName()));
            return false;
        }
        this.namesToValues.put(valueString, line);
        return true;
    }

    @Override
    public void addValue(String valueString) {
        String actualValue = this.namesToValues.get(valueString);
        if (actualValue != null) {
            super.addValue(actualValue);
        }
    }
}

