/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import org.opends.server.types.PublicAPI;
import org.opends.server.types.SortKey;
import org.opends.server.types.StabilityLevel;

@PublicAPI(stability=StabilityLevel.VOLATILE, mayInstantiate=true, mayExtend=false, mayInvoke=true)
public final class SortOrder {
    private SortKey[] sortKeys;

    public SortOrder(SortKey sortKey) {
        this.sortKeys = new SortKey[]{sortKey};
    }

    public SortOrder(SortKey[] sortKeys) {
        this.sortKeys = new SortKey[sortKeys.length];
        System.arraycopy(sortKeys, 0, this.sortKeys, 0, sortKeys.length);
    }

    public SortKey[] getSortKeys() {
        return this.sortKeys;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("SortOrder(");
        if (this.sortKeys.length > 0) {
            this.sortKeys[0].toString(buffer);
            for (int i = 1; i < this.sortKeys.length; ++i) {
                buffer.append(",");
                this.sortKeys[i].toString(buffer);
            }
        }
        buffer.append(")");
    }

    public int hashCode() {
        int hashCode = 0;
        for (SortKey sortKey : this.sortKeys) {
            hashCode += sortKey.hashCode();
        }
        return hashCode;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof SortOrder)) {
            return false;
        }
        SortOrder s = (SortOrder)o;
        if (this.sortKeys.length != s.sortKeys.length) {
            return false;
        }
        for (int i = 0; i < this.sortKeys.length; ++i) {
            if (this.sortKeys[i].equals(s.sortKeys[i])) continue;
            return false;
        }
        return true;
    }
}

