/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import org.opends.messages.CoreMessages;
import org.opends.messages.Message;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ResultCode;

public final class AttributeValues {
    private AttributeValues() {
    }

    public static AttributeValue create(AttributeType attributeType, ByteString value) {
        return new DelayedNormalizationValue(attributeType, value);
    }

    public static AttributeValue create(AttributeType attributeType, String value) {
        return new DelayedNormalizationValue(attributeType, ByteString.valueOf(value));
    }

    public static AttributeValue create(ByteString value, ByteString normalizedValue) {
        return new PreNormalizedValue(value, normalizedValue);
    }

    private static final class PreNormalizedValue
    implements AttributeValue {
        private static final DebugTracer TRACER = DebugLogger.getTracer();
        private final ByteString value;
        private final ByteString normalizedValue;

        private PreNormalizedValue(ByteString value, ByteString normalizedValue) {
            this.value = value;
            this.normalizedValue = normalizedValue;
        }

        public ByteString getNormalizedValue() {
            return this.normalizedValue;
        }

        public ByteString getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof AttributeValue) {
                AttributeValue attrValue = (AttributeValue)o;
                try {
                    return this.normalizedValue.equals(attrValue.getNormalizedValue());
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    return this.value.equals(attrValue.getValue());
                }
            }
            return false;
        }

        public int hashCode() {
            return this.normalizedValue.hashCode();
        }

        public String toString() {
            if (this.value == null) {
                return "null";
            }
            return this.value.toString();
        }

        public void toString(StringBuilder buffer) {
            buffer.append(this.value.toString());
        }
    }

    private static final class DelayedNormalizationValue
    implements AttributeValue {
        private static final DebugTracer TRACER = DebugLogger.getTracer();
        private final AttributeType attributeType;
        private final ByteString value;
        private ByteString normalizedValue;

        private DelayedNormalizationValue(AttributeType attributeType, ByteString value) {
            this.attributeType = attributeType;
            this.value = value;
            this.normalizedValue = null;
        }

        public ByteString getNormalizedValue() throws DirectoryException {
            if (this.normalizedValue == null) {
                EqualityMatchingRule equalityMatchingRule = this.attributeType.getEqualityMatchingRule();
                if (equalityMatchingRule == null) {
                    Message message = CoreMessages.ERR_ATTR_TYPE_NORMALIZE_NO_MR.get(String.valueOf(this.value), this.attributeType.getNameOrOID());
                    throw new DirectoryException(ResultCode.INAPPROPRIATE_MATCHING, message);
                }
                this.normalizedValue = equalityMatchingRule.normalizeValue(this.value);
            }
            return this.normalizedValue;
        }

        public ByteString getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof AttributeValue) {
                AttributeValue attrValue = (AttributeValue)o;
                try {
                    return this.getNormalizedValue().equals(attrValue.getNormalizedValue());
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    return this.value.equals(attrValue.getValue());
                }
            }
            return false;
        }

        public int hashCode() {
            ByteString valueToHash;
            EqualityMatchingRule equalityMatchingRule = this.attributeType.getEqualityMatchingRule();
            try {
                valueToHash = this.getNormalizedValue();
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                valueToHash = this.value;
            }
            if (equalityMatchingRule != null) {
                return equalityMatchingRule.generateHashCode(valueToHash);
            }
            return valueToHash.hashCode();
        }

        public String toString() {
            if (this.value == null) {
                return "null";
            }
            return this.value.toString();
        }

        public void toString(StringBuilder buffer) {
            buffer.append(this.value.toString());
        }
    }
}

