/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.makeldif;

import java.text.DecimalFormat;
import java.util.List;
import java.util.Random;
import org.opends.messages.Message;
import org.opends.messages.ToolMessages;
import org.opends.server.tools.makeldif.Branch;
import org.opends.server.tools.makeldif.Tag;
import org.opends.server.tools.makeldif.TagResult;
import org.opends.server.tools.makeldif.Template;
import org.opends.server.tools.makeldif.TemplateEntry;
import org.opends.server.tools.makeldif.TemplateFile;
import org.opends.server.tools.makeldif.TemplateValue;
import org.opends.server.types.InitializationException;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RandomTag
extends Tag {
    public static final int RANDOM_TYPE_CHARS_FIXED = 1;
    public static final int RANDOM_TYPE_CHARS_VARIABLE = 2;
    public static final int RANDOM_TYPE_NUMERIC = 3;
    public static final int RANDOM_TYPE_MONTH = 4;
    public static final int RANDOM_TYPE_TELEPHONE = 5;
    public static final char[] ALPHA_CHARS = "abcdefghijklmnopqrstuvwxyz".toCharArray();
    public static final char[] NUMERIC_CHARS = "01234567890".toCharArray();
    public static final char[] ALPHANUMERIC_CHARS = "abcdefghijklmnopqrstuvwxyz0123456789".toCharArray();
    public static final char[] HEX_CHARS = "01234567890abcdef".toCharArray();
    public static final char[] BASE64_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz01234567890+/".toCharArray();
    public static final String[] MONTHS = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    private char[] characterSet = null;
    private DecimalFormat decimalFormat = null;
    private int lengthRange = 1;
    private int maxLength = 0;
    private int minLength = 0;
    private int randomType = 0;
    private long maxValue = 0L;
    private long minValue = 0L;
    private long valueRange = 1L;
    private Random random;

    @Override
    public String getName() {
        return "Random";
    }

    @Override
    public boolean allowedInBranch() {
        return true;
    }

    @Override
    public void initializeForBranch(TemplateFile templateFile, Branch branch, String[] arguments, int lineNumber, List<Message> warnings) throws InitializationException {
        this.initializeInternal(templateFile, arguments, lineNumber, warnings);
    }

    @Override
    public void initializeForTemplate(TemplateFile templateFile, Template template, String[] arguments, int lineNumber, List<Message> warnings) throws InitializationException {
        this.initializeInternal(templateFile, arguments, lineNumber, warnings);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initializeInternal(TemplateFile templateFile, String[] arguments, int lineNumber, List<Message> warnings) throws InitializationException {
        this.random = templateFile.getRandom();
        if (arguments == null || arguments.length == 0) {
            Message message = ToolMessages.ERR_MAKELDIF_TAG_NO_RANDOM_TYPE_ARGUMENT.get(lineNumber);
            throw new InitializationException(message);
        }
        int numArgs = arguments.length;
        String randomTypeString = StaticUtils.toLowerCase(arguments[0]);
        if (randomTypeString.equals("alpha")) {
            this.characterSet = ALPHA_CHARS;
            this.decodeLength(arguments, 1, lineNumber, warnings);
            return;
        }
        if (randomTypeString.equals("numeric")) {
            if (numArgs == 2) {
                this.randomType = 1;
                this.characterSet = NUMERIC_CHARS;
                try {
                    this.minLength = Integer.parseInt(arguments[1]);
                    if (this.minLength < 0) {
                        Message message = ToolMessages.ERR_MAKELDIF_TAG_INTEGER_BELOW_LOWER_BOUND.get(this.minLength, 0, this.getName(), lineNumber);
                        throw new InitializationException(message);
                    }
                    if (this.minLength != 0) return;
                    Message message = ToolMessages.WARN_MAKELDIF_TAG_WARNING_EMPTY_VALUE.get(lineNumber);
                    warnings.add(message);
                    return;
                }
                catch (NumberFormatException nfe) {
                    Message message = ToolMessages.ERR_MAKELDIF_TAG_CANNOT_PARSE_AS_INTEGER.get(arguments[1], this.getName(), lineNumber);
                    throw new InitializationException(message, (Throwable)nfe);
                }
            }
            if (numArgs != 3 && numArgs != 4) {
                Message message = ToolMessages.ERR_MAKELDIF_TAG_INVALID_ARGUMENT_RANGE_COUNT.get(this.getName(), lineNumber, 2, 4, numArgs);
                throw new InitializationException(message);
            }
            this.randomType = 3;
            if (numArgs == 4) {
                try {
                    this.decimalFormat = new DecimalFormat(arguments[3]);
                }
                catch (Exception e) {
                    Message message = ToolMessages.ERR_MAKELDIF_TAG_INVALID_FORMAT_STRING.get(arguments[3], this.getName(), lineNumber);
                    throw new InitializationException(message, (Throwable)e);
                }
            } else {
                this.decimalFormat = null;
            }
            try {
                this.minValue = Long.parseLong(arguments[1]);
            }
            catch (NumberFormatException nfe) {
                Message message = ToolMessages.ERR_MAKELDIF_TAG_CANNOT_PARSE_AS_INTEGER.get(arguments[1], this.getName(), lineNumber);
                throw new InitializationException(message, (Throwable)nfe);
            }
            try {
                this.maxValue = Long.parseLong(arguments[2]);
                if (this.maxValue < this.minValue) {
                    Message message = ToolMessages.ERR_MAKELDIF_TAG_INTEGER_BELOW_LOWER_BOUND.get(this.maxValue, this.minValue, this.getName(), lineNumber);
                    throw new InitializationException(message);
                }
                this.valueRange = this.maxValue - this.minValue + 1L;
                return;
            }
            catch (NumberFormatException nfe) {
                Message message = ToolMessages.ERR_MAKELDIF_TAG_CANNOT_PARSE_AS_INTEGER.get(arguments[2], this.getName(), lineNumber);
                throw new InitializationException(message, (Throwable)nfe);
            }
        }
        if (randomTypeString.equals("alphanumeric")) {
            this.characterSet = ALPHANUMERIC_CHARS;
            this.decodeLength(arguments, 1, lineNumber, warnings);
            return;
        }
        if (randomTypeString.equals("chars")) {
            if (numArgs >= 3 && numArgs <= 4) {
                this.characterSet = arguments[1].toCharArray();
                this.decodeLength(arguments, 2, lineNumber, warnings);
                return;
            }
            Message message = ToolMessages.ERR_MAKELDIF_TAG_INVALID_ARGUMENT_RANGE_COUNT.get(this.getName(), lineNumber, 3, 4, numArgs);
            throw new InitializationException(message);
        }
        if (randomTypeString.equals("hex")) {
            this.characterSet = HEX_CHARS;
            this.decodeLength(arguments, 1, lineNumber, warnings);
            return;
        }
        if (randomTypeString.equals("base64")) {
            this.characterSet = BASE64_CHARS;
            this.decodeLength(arguments, 1, lineNumber, warnings);
            return;
        }
        if (randomTypeString.equals("month")) {
            this.randomType = 4;
            if (numArgs == 1) {
                this.maxLength = 0;
                return;
            }
            if (numArgs != 2) {
                Message message = ToolMessages.ERR_MAKELDIF_TAG_INVALID_ARGUMENT_RANGE_COUNT.get(this.getName(), lineNumber, 1, 2, numArgs);
                throw new InitializationException(message);
            }
            try {
                this.maxLength = Integer.parseInt(arguments[1]);
                if (this.maxLength > 0) return;
                Message message = ToolMessages.ERR_MAKELDIF_TAG_INTEGER_BELOW_LOWER_BOUND.get(this.maxLength, 1, this.getName(), lineNumber);
                throw new InitializationException(message);
            }
            catch (NumberFormatException nfe) {
                Message message = ToolMessages.ERR_MAKELDIF_TAG_CANNOT_PARSE_AS_INTEGER.get(arguments[1], this.getName(), lineNumber);
                throw new InitializationException(message, (Throwable)nfe);
            }
        }
        if (randomTypeString.equals("telephone")) {
            this.randomType = 5;
            return;
        }
        Message message = ToolMessages.ERR_MAKELDIF_TAG_UNKNOWN_RANDOM_TYPE.get(lineNumber, randomTypeString);
        throw new InitializationException(message);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void decodeLength(String[] arguments, int startPos, int lineNumber, List<Message> warnings) throws InitializationException {
        int numArgs = arguments.length - startPos + 1;
        if (numArgs == 2) {
            this.randomType = 1;
            try {
                this.minLength = Integer.parseInt(arguments[startPos]);
                if (this.minLength < 0) {
                    Message message = ToolMessages.ERR_MAKELDIF_TAG_INTEGER_BELOW_LOWER_BOUND.get(this.minLength, 0, this.getName(), lineNumber);
                    throw new InitializationException(message);
                }
                if (this.minLength != 0) return;
                Message message = ToolMessages.WARN_MAKELDIF_TAG_WARNING_EMPTY_VALUE.get(lineNumber);
                warnings.add(message);
                return;
            }
            catch (NumberFormatException nfe) {
                Message message = ToolMessages.ERR_MAKELDIF_TAG_CANNOT_PARSE_AS_INTEGER.get(arguments[startPos], this.getName(), lineNumber);
                throw new InitializationException(message, (Throwable)nfe);
            }
        }
        if (numArgs == 3) {
            this.randomType = 2;
            try {
                this.minLength = Integer.parseInt(arguments[startPos]);
                if (this.minLength < 0) {
                    Message message = ToolMessages.ERR_MAKELDIF_TAG_INTEGER_BELOW_LOWER_BOUND.get(this.minLength, 0, this.getName(), lineNumber);
                    throw new InitializationException(message);
                }
            }
            catch (NumberFormatException nfe) {
                Message message = ToolMessages.ERR_MAKELDIF_TAG_CANNOT_PARSE_AS_INTEGER.get(arguments[startPos], this.getName(), lineNumber);
                throw new InitializationException(message, (Throwable)nfe);
            }
            try {
                this.maxLength = Integer.parseInt(arguments[startPos + 1]);
                this.lengthRange = this.maxLength - this.minLength + 1;
                if (this.maxLength < this.minLength) {
                    Message message = ToolMessages.ERR_MAKELDIF_TAG_INTEGER_BELOW_LOWER_BOUND.get(this.maxLength, this.minLength, this.getName(), lineNumber);
                    throw new InitializationException(message);
                }
                if (this.maxLength != 0) return;
                Message message = ToolMessages.WARN_MAKELDIF_TAG_WARNING_EMPTY_VALUE.get(lineNumber);
                warnings.add(message);
                return;
            }
            catch (NumberFormatException nfe) {
                Message message = ToolMessages.ERR_MAKELDIF_TAG_CANNOT_PARSE_AS_INTEGER.get(arguments[startPos + 1], this.getName(), lineNumber);
                throw new InitializationException(message, (Throwable)nfe);
            }
        }
        Message message = ToolMessages.ERR_MAKELDIF_TAG_INVALID_ARGUMENT_RANGE_COUNT.get(this.getName(), lineNumber, startPos + 1, startPos + 2, numArgs);
        throw new InitializationException(message);
    }

    @Override
    public TagResult generateValue(TemplateEntry templateEntry, TemplateValue templateValue) {
        StringBuilder buffer = templateValue.getValue();
        switch (this.randomType) {
            case 1: {
                for (int i = 0; i < this.minLength; ++i) {
                    buffer.append(this.characterSet[this.random.nextInt(this.characterSet.length)]);
                }
                break;
            }
            case 2: {
                int numChars = this.random.nextInt(this.lengthRange) + this.minLength;
                for (int i = 0; i < numChars; ++i) {
                    buffer.append(this.characterSet[this.random.nextInt(this.characterSet.length)]);
                }
                break;
            }
            case 3: {
                long randomValue = (this.random.nextLong() & Long.MAX_VALUE) % this.valueRange + this.minValue;
                if (this.decimalFormat == null) {
                    buffer.append(randomValue);
                    break;
                }
                buffer.append(this.decimalFormat.format(randomValue));
                break;
            }
            case 4: {
                String month = MONTHS[this.random.nextInt(MONTHS.length)];
                if (this.maxLength == 0 || month.length() <= this.maxLength) {
                    buffer.append(month);
                    break;
                }
                buffer.append(month.substring(0, this.maxLength));
                break;
            }
            case 5: {
                int i;
                buffer.append("+1 ");
                for (i = 0; i < 3; ++i) {
                    buffer.append(NUMERIC_CHARS[this.random.nextInt(NUMERIC_CHARS.length)]);
                }
                buffer.append(' ');
                for (i = 0; i < 3; ++i) {
                    buffer.append(NUMERIC_CHARS[this.random.nextInt(NUMERIC_CHARS.length)]);
                }
                buffer.append(' ');
                for (i = 0; i < 4; ++i) {
                    buffer.append(NUMERIC_CHARS[this.random.nextInt(NUMERIC_CHARS.length)]);
                }
                break;
            }
        }
        return TagResult.SUCCESS_RESULT;
    }
}

