/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.makeldif;

import java.util.List;
import java.util.Random;
import org.opends.messages.Message;
import org.opends.messages.ToolMessages;
import org.opends.server.tools.makeldif.Branch;
import org.opends.server.tools.makeldif.Tag;
import org.opends.server.tools.makeldif.TagResult;
import org.opends.server.tools.makeldif.Template;
import org.opends.server.tools.makeldif.TemplateEntry;
import org.opends.server.tools.makeldif.TemplateFile;
import org.opends.server.tools.makeldif.TemplateValue;
import org.opends.server.types.InitializationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListTag
extends Tag {
    private int cumulativeWeight;
    private int[] valueWeights;
    private String[] valueStrings;
    private Random random;

    @Override
    public String getName() {
        return "List";
    }

    @Override
    public boolean allowedInBranch() {
        return true;
    }

    @Override
    public void initializeForBranch(TemplateFile templateFile, Branch branch, String[] arguments, int lineNumber, List<Message> warnings) throws InitializationException {
        this.initializeInternal(templateFile, arguments, lineNumber, warnings);
    }

    @Override
    public void initializeForTemplate(TemplateFile templateFile, Template template, String[] arguments, int lineNumber, List<Message> warnings) throws InitializationException {
        this.initializeInternal(templateFile, arguments, lineNumber, warnings);
    }

    private void initializeInternal(TemplateFile templateFile, String[] arguments, int lineNumber, List<Message> warnings) throws InitializationException {
        if (arguments.length == 0) {
            throw new InitializationException(ToolMessages.ERR_MAKELDIF_TAG_LIST_NO_ARGUMENTS.get(lineNumber));
        }
        this.valueStrings = new String[arguments.length];
        this.valueWeights = new int[arguments.length];
        this.cumulativeWeight = 0;
        this.random = templateFile.getRandom();
        for (int i = 0; i < arguments.length; ++i) {
            String s = arguments[i];
            int weight = 1;
            int semicolonPos = s.lastIndexOf(59);
            if (semicolonPos >= 0) {
                try {
                    weight = Integer.parseInt(s.substring(semicolonPos + 1));
                    s = s.substring(0, semicolonPos);
                }
                catch (Exception e) {
                    warnings.add(ToolMessages.WARN_MAKELDIF_TAG_LIST_INVALID_WEIGHT.get(lineNumber, s));
                }
            }
            this.cumulativeWeight += weight;
            this.valueStrings[i] = s;
            this.valueWeights[i] = this.cumulativeWeight;
        }
    }

    @Override
    public TagResult generateValue(TemplateEntry templateEntry, TemplateValue templateValue) {
        int selectedWeight = this.random.nextInt(this.cumulativeWeight) + 1;
        for (int i = 0; i < this.valueWeights.length; ++i) {
            if (selectedWeight > this.valueWeights[i]) continue;
            templateValue.getValue().append(this.valueStrings[i]);
            break;
        }
        return TagResult.SUCCESS_RESULT;
    }
}

