/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.configurator;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opends.messages.Message;
import org.opends.messages.QuickSetupMessages;
import org.opends.messages.ToolMessages;
import org.opends.quicksetup.ApplicationException;
import org.opends.quicksetup.CliApplication;
import org.opends.quicksetup.Launcher;
import org.opends.quicksetup.QuickSetupLog;
import org.opends.quicksetup.ReturnCode;
import org.opends.quicksetup.util.Utils;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.ArgumentParser;
import org.opends.server.util.args.BooleanArgument;

public class Unconfigurator
extends Launcher {
    private static final Logger LOG = Logger.getLogger(Unconfigurator.class.getName());
    public static final String LOG_FILE_PREFIX = "opends-unconfigure-";
    private String installRootFromSystem;
    private ArgumentParser argParser;
    private BooleanArgument showUsage;
    private BooleanArgument checkOptions;

    public static void main(String[] args) {
        try {
            QuickSetupLog.initLogFileHandler(File.createTempFile(LOG_FILE_PREFIX, ".log"));
        }
        catch (Throwable t) {
            System.err.println(QuickSetupMessages.INFO_ERROR_INITIALIZING_LOG.get());
            t.printStackTrace();
        }
        try {
            Unconfigurator unconfigurator = new Unconfigurator(args);
            unconfigurator.parseArgs(args);
            unconfigurator.unconfigure();
        }
        catch (ApplicationException ae) {
            LOG.log(Level.SEVERE, "Error during unconfig: " + ae.getMessageObject());
            System.exit(ReturnCode.APPLICATION_ERROR.getReturnCode());
        }
    }

    private void parseArgs(String[] args) {
        try {
            this.argParser.parseArguments(args);
            if (this.argParser.usageOrVersionDisplayed()) {
                System.exit(ReturnCode.PRINT_USAGE.getReturnCode());
            }
            if (this.checkOptions.isPresent()) {
                System.exit(ReturnCode.SUCCESSFUL.getReturnCode());
            }
        }
        catch (ArgumentException ae) {
            System.err.println(ae.getMessageObject());
            this.printUsage(false);
            System.exit(ReturnCode.APPLICATION_ERROR.getReturnCode());
        }
    }

    private void unconfigure() throws ApplicationException {
        File instanceLoc = new File("/etc/opends/instance.loc");
        boolean res = instanceLoc.delete();
        if (!res) {
            System.err.println("Unable to delete: /etc/opends/instance.loc");
            System.exit(ReturnCode.APPLICATION_ERROR.getReturnCode());
        }
    }

    private Unconfigurator(String[] args) {
        super(args);
        String scriptName = "unconfigure";
        if (Utils.isWindows()) {
            System.err.println("Not supported platform: Windows");
            System.exit(ReturnCode.APPLICATION_ERROR.getReturnCode());
        } else {
            scriptName = "configure";
        }
        if (System.getProperty("org.opends.server.scriptName") == null) {
            System.setProperty("org.opends.server.scriptName", scriptName);
        }
        this.installRootFromSystem = System.getProperty("INSTALL_ROOT");
        if (this.installRootFromSystem == null) {
            System.exit(ReturnCode.APPLICATION_ERROR.getReturnCode());
        }
        this.argParser = new ArgumentParser(this.getClass().getName(), ToolMessages.INFO_UNCONFIGURE_USAGE_DESCRIPTION.get(), false);
        try {
            this.checkOptions = new BooleanArgument("checkOptions", null, "checkOptions", ToolMessages.INFO_DESCRIPTION_CHECK_OPTIONS.get());
            this.checkOptions.setHidden(true);
            this.argParser.addArgument(this.checkOptions);
            this.showUsage = new BooleanArgument("showusage", Character.valueOf('H'), "help", ToolMessages.INFO_DESCRIPTION_USAGE.get());
            this.argParser.addArgument(this.showUsage);
            this.argParser.setUsageArgument(this.showUsage);
        }
        catch (ArgumentException ae) {
            System.err.println(ae.getMessageObject());
            this.printUsage(false);
            System.exit(ReturnCode.APPLICATION_ERROR.getReturnCode());
        }
    }

    protected void willLaunchGui() {
    }

    protected void guiLaunchFailed(String logFilePath) {
    }

    protected CliApplication createCliApplication() {
        return null;
    }

    protected Message getFrameTitle() {
        return null;
    }

    public ArgumentParser getArgumentParser() {
        return this.argParser;
    }
}

