/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools;

import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.opends.messages.Message;
import org.opends.messages.ToolMessages;
import org.opends.server.admin.std.server.BackendCfg;
import org.opends.server.api.Backend;
import org.opends.server.api.plugin.PluginType;
import org.opends.server.config.ConfigConstants;
import org.opends.server.config.ConfigException;
import org.opends.server.core.CoreConfigManager;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.LockFileManager;
import org.opends.server.extensions.ConfigFileHandler;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.TextErrorLogPublisher;
import org.opends.server.loggers.TextWriter;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.TextDebugLogPublisher;
import org.opends.server.protocols.ldap.LDAPAttribute;
import org.opends.server.tasks.ImportTask;
import org.opends.server.tools.BackendToolUtils;
import org.opends.server.tools.ToolConstants;
import org.opends.server.tools.makeldif.TemplateFile;
import org.opends.server.tools.tasks.TaskTool;
import org.opends.server.types.AttributeType;
import org.opends.server.types.ByteString;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ExistingFileBehavior;
import org.opends.server.types.InitializationException;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.types.LDIFImportResult;
import org.opends.server.types.NullOutputStream;
import org.opends.server.types.RawAttribute;
import org.opends.server.types.SearchFilter;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.IntegerArgument;
import org.opends.server.util.args.LDAPConnectionArgumentParser;
import org.opends.server.util.args.StringArgument;
import org.opends.server.util.cli.CLIException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportLDIF
extends TaskTool {
    public static final int LDIF_BUFFER_SIZE = 0x100000;
    private BooleanArgument append = null;
    private BooleanArgument countRejects = null;
    private BooleanArgument displayUsage = null;
    private BooleanArgument isCompressed = null;
    private BooleanArgument isEncrypted = null;
    private BooleanArgument overwrite = null;
    private BooleanArgument quietMode = null;
    private BooleanArgument replaceExisting = null;
    private BooleanArgument skipSchemaValidation = null;
    private BooleanArgument clearBackend = null;
    private IntegerArgument randomSeed = null;
    private StringArgument backendID = null;
    private StringArgument configClass = null;
    private StringArgument configFile = null;
    private StringArgument excludeAttributeStrings = null;
    private StringArgument excludeBranchStrings = null;
    private StringArgument excludeFilterStrings = null;
    private StringArgument includeAttributeStrings = null;
    private StringArgument includeBranchStrings = null;
    private StringArgument includeFilterStrings = null;
    private StringArgument ldifFiles = null;
    private StringArgument rejectFile = null;
    private StringArgument skipFile = null;
    private StringArgument templateFile = null;

    public static void main(String[] args) {
        int retCode = ImportLDIF.mainImportLDIF(args, true, System.out, System.err);
        if (retCode != 0) {
            System.exit(StaticUtils.filterExitCode(retCode));
        }
    }

    public static int mainImportLDIF(String[] args) {
        return ImportLDIF.mainImportLDIF(args, true, System.out, System.err);
    }

    public static int mainImportLDIF(String[] args, boolean initializeServer, OutputStream outStream, OutputStream errStream) {
        ImportLDIF tool = new ImportLDIF();
        return tool.process(args, initializeServer, outStream, errStream);
    }

    private int process(String[] args, boolean initializeServer, OutputStream outStream, OutputStream errStream) {
        PrintStream out = outStream == null ? NullOutputStream.printStream() : new PrintStream(outStream);
        PrintStream err = errStream == null ? NullOutputStream.printStream() : new PrintStream(errStream);
        LDAPConnectionArgumentParser argParser = this.createArgParser("org.opends.server.tools.ImportLDIF", ToolMessages.INFO_LDIFIMPORT_TOOL_DESCRIPTION.get());
        try {
            this.configClass = new StringArgument("configclass", Character.valueOf('C'), "configClass", true, false, true, ToolMessages.INFO_CONFIGCLASS_PLACEHOLDER.get(), ConfigFileHandler.class.getName(), null, ToolMessages.INFO_DESCRIPTION_CONFIG_CLASS.get());
            this.configClass.setHidden(true);
            argParser.addArgument(this.configClass);
            this.configFile = new StringArgument("configfile", Character.valueOf('f'), "configFile", true, false, true, ToolMessages.INFO_CONFIGFILE_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_CONFIG_FILE.get());
            this.configFile.setHidden(true);
            argParser.addArgument(this.configFile);
            this.ldifFiles = new StringArgument("ldiffile", Character.valueOf('l'), "ldifFile", false, true, true, ToolMessages.INFO_LDIFFILE_PLACEHOLDER.get(), null, null, ToolMessages.INFO_LDIFIMPORT_DESCRIPTION_LDIF_FILE.get());
            argParser.addArgument(this.ldifFiles);
            this.templateFile = new StringArgument("templatefile", Character.valueOf('A'), "templateFile", false, false, true, ToolMessages.INFO_TEMPLATE_FILE_PLACEHOLDER.get(), null, null, ToolMessages.INFO_LDIFIMPORT_DESCRIPTION_TEMPLATE_FILE.get());
            argParser.addArgument(this.templateFile);
            this.append = new BooleanArgument("append", Character.valueOf('a'), "append", ToolMessages.INFO_LDIFIMPORT_DESCRIPTION_APPEND.get());
            argParser.addArgument(this.append);
            this.replaceExisting = new BooleanArgument("replaceexisting", Character.valueOf('r'), "replaceExisting", ToolMessages.INFO_LDIFIMPORT_DESCRIPTION_REPLACE_EXISTING.get());
            argParser.addArgument(this.replaceExisting);
            this.backendID = new StringArgument("backendid", Character.valueOf('n'), "backendID", false, false, true, ToolMessages.INFO_BACKENDNAME_PLACEHOLDER.get(), null, null, ToolMessages.INFO_LDIFIMPORT_DESCRIPTION_BACKEND_ID.get());
            argParser.addArgument(this.backendID);
            this.clearBackend = new BooleanArgument("clearbackend", Character.valueOf('F'), "clearBackend", ToolMessages.INFO_LDIFIMPORT_DESCRIPTION_CLEAR_BACKEND.get());
            argParser.addArgument(this.clearBackend);
            this.includeBranchStrings = new StringArgument("includebranch", Character.valueOf('b'), "includeBranch", false, true, true, ToolMessages.INFO_BRANCH_DN_PLACEHOLDER.get(), null, null, ToolMessages.INFO_LDIFIMPORT_DESCRIPTION_INCLUDE_BRANCH.get());
            argParser.addArgument(this.includeBranchStrings);
            this.excludeBranchStrings = new StringArgument("excludebranch", Character.valueOf('B'), "excludeBranch", false, true, true, ToolMessages.INFO_BRANCH_DN_PLACEHOLDER.get(), null, null, ToolMessages.INFO_LDIFIMPORT_DESCRIPTION_EXCLUDE_BRANCH.get());
            argParser.addArgument(this.excludeBranchStrings);
            this.includeAttributeStrings = new StringArgument("includeattribute", Character.valueOf('i'), "includeAttribute", false, true, true, ToolMessages.INFO_ATTRIBUTE_PLACEHOLDER.get(), null, null, ToolMessages.INFO_LDIFIMPORT_DESCRIPTION_INCLUDE_ATTRIBUTE.get());
            argParser.addArgument(this.includeAttributeStrings);
            this.excludeAttributeStrings = new StringArgument("excludeattribute", Character.valueOf('e'), "excludeAttribute", false, true, true, ToolMessages.INFO_ATTRIBUTE_PLACEHOLDER.get(), null, null, ToolMessages.INFO_LDIFIMPORT_DESCRIPTION_EXCLUDE_ATTRIBUTE.get());
            argParser.addArgument(this.excludeAttributeStrings);
            this.includeFilterStrings = new StringArgument("includefilter", Character.valueOf('I'), "includeFilter", false, true, true, ToolMessages.INFO_FILTER_PLACEHOLDER.get(), null, null, ToolMessages.INFO_LDIFIMPORT_DESCRIPTION_INCLUDE_FILTER.get());
            argParser.addArgument(this.includeFilterStrings);
            this.excludeFilterStrings = new StringArgument("excludefilter", Character.valueOf('E'), "excludeFilter", false, true, true, ToolMessages.INFO_FILTER_PLACEHOLDER.get(), null, null, ToolMessages.INFO_LDIFIMPORT_DESCRIPTION_EXCLUDE_FILTER.get());
            argParser.addArgument(this.excludeFilterStrings);
            this.rejectFile = new StringArgument("rejectfile", Character.valueOf('R'), "rejectFile", false, false, true, ToolMessages.INFO_REJECT_FILE_PLACEHOLDER.get(), null, null, ToolMessages.INFO_LDIFIMPORT_DESCRIPTION_REJECT_FILE.get());
            argParser.addArgument(this.rejectFile);
            this.skipFile = new StringArgument("skipfile", null, "skipFile", false, false, true, ToolMessages.INFO_SKIP_FILE_PLACEHOLDER.get(), null, null, ToolMessages.INFO_LDIFIMPORT_DESCRIPTION_SKIP_FILE.get());
            argParser.addArgument(this.skipFile);
            this.overwrite = new BooleanArgument("overwrite", Character.valueOf('O'), "overwrite", ToolMessages.INFO_LDIFIMPORT_DESCRIPTION_OVERWRITE.get());
            argParser.addArgument(this.overwrite);
            this.randomSeed = new IntegerArgument("randomseed", Character.valueOf('s'), "randomSeed", false, false, true, ToolMessages.INFO_SEED_PLACEHOLDER.get(), 0, null, false, 0, false, 0, ToolMessages.INFO_LDIFIMPORT_DESCRIPTION_RANDOM_SEED.get());
            argParser.addArgument(this.randomSeed);
            this.skipSchemaValidation = new BooleanArgument("skipschema", Character.valueOf('S'), "skipSchemaValidation", ToolMessages.INFO_LDIFIMPORT_DESCRIPTION_SKIP_SCHEMA_VALIDATION.get());
            argParser.addArgument(this.skipSchemaValidation);
            this.countRejects = new BooleanArgument("countrejects", null, "countRejects", ToolMessages.INFO_LDIFIMPORT_DESCRIPTION_COUNT_REJECTS.get());
            argParser.addArgument(this.countRejects);
            this.isCompressed = new BooleanArgument("iscompressed", Character.valueOf('c'), "isCompressed", ToolMessages.INFO_LDIFIMPORT_DESCRIPTION_IS_COMPRESSED.get());
            argParser.addArgument(this.isCompressed);
            this.isEncrypted = new BooleanArgument("isencrypted", Character.valueOf('y'), "isEncrypted", ToolMessages.INFO_LDIFIMPORT_DESCRIPTION_IS_ENCRYPTED.get());
            this.isEncrypted.setHidden(true);
            argParser.addArgument(this.isEncrypted);
            this.quietMode = new BooleanArgument("quietmode", ToolConstants.OPTION_SHORT_QUIET, "quiet", ToolMessages.INFO_LDIFIMPORT_DESCRIPTION_QUIET.get());
            argParser.addArgument(this.quietMode);
            this.displayUsage = new BooleanArgument("help", Character.valueOf('H'), "help", ToolMessages.INFO_DESCRIPTION_USAGE.get());
            argParser.addArgument(this.displayUsage);
            argParser.setUsageArgument(this.displayUsage);
        }
        catch (ArgumentException ae) {
            Message message = ToolMessages.ERR_CANNOT_INITIALIZE_ARGS.get(ae.getMessage());
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        try {
            argParser.getArguments().initArgumentsWithConfiguration();
        }
        catch (ConfigException ce) {
            // empty catch block
        }
        try {
            argParser.parseArguments(args);
            this.validateTaskArgs();
        }
        catch (ArgumentException ae) {
            Message message = ToolMessages.ERR_ERROR_PARSING_ARGS.get(ae.getMessage());
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            err.println(argParser.getUsage());
            return 1;
        }
        catch (CLIException ce) {
            err.println(StaticUtils.wrapText(ce.getMessageObject(), ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        if (argParser.usageOrVersionDisplayed()) {
            return 0;
        }
        if (this.ldifFiles.isPresent()) {
            if (this.templateFile.isPresent()) {
                Message message = ToolMessages.ERR_LDIFIMPORT_CONFLICTING_OPTIONS.get(this.ldifFiles.getLongIdentifier(), this.templateFile.getLongIdentifier());
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
        } else if (!this.templateFile.isPresent()) {
            Message message = ToolMessages.ERR_LDIFIMPORT_MISSING_REQUIRED_ARGUMENT.get(this.ldifFiles.getLongIdentifier(), this.templateFile.getLongIdentifier());
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        if (!this.includeBranchStrings.isPresent() && !this.backendID.isPresent()) {
            Message message = ToolMessages.ERR_LDIFIMPORT_MISSING_BACKEND_ARGUMENT.get(this.includeBranchStrings.getLongIdentifier(), this.backendID.getLongIdentifier());
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        if (this.countRejects.isPresent() && argParser.connectionArgumentsPresent()) {
            Message message = ToolMessages.ERR_LDIFIMPORT_COUNT_REJECTS_REQUIRES_OFFLINE.get(this.countRejects.getLongIdentifier());
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        if (this.quietMode.isPresent()) {
            out = new PrintStream(NullOutputStream.instance());
        }
        return this.process(argParser, initializeServer, out, err);
    }

    @Override
    public void addTaskAttributes(List<RawAttribute> attributes) {
        LinkedList<String> excludeBranches;
        LinkedList<String> includeBranches;
        LinkedList<String> excludeFilters;
        LinkedList<String> includeFilters;
        LinkedList<String> excludeAttributes;
        LinkedList<String> includeAttributes;
        String randomSeedValue;
        String templateFileValue;
        ArrayList<ByteString> values;
        LinkedList<String> fileList = this.ldifFiles.getValues();
        if (fileList != null && fileList.size() > 0 && fileList != null && fileList.size() > 0) {
            values = new ArrayList(fileList.size());
            for (String file : fileList) {
                values.add(ByteString.valueOf(file));
            }
            attributes.add(new LDAPAttribute("ds-task-import-ldif-file", values));
        }
        if ((templateFileValue = this.templateFile.getValue()) != null) {
            values = new ArrayList<ByteString>(1);
            values.add(ByteString.valueOf(templateFileValue));
            attributes.add(new LDAPAttribute("ds-task-import-template-file", values));
        }
        if ((randomSeedValue = this.randomSeed.getValue()) != null) {
            values = new ArrayList(1);
            values.add(ByteString.valueOf(randomSeedValue));
            attributes.add(new LDAPAttribute("ds-task-import-random-seed", values));
        }
        if (this.append.getValue() != null && !this.append.getValue().equals(this.append.getDefaultValue())) {
            values = new ArrayList(1);
            values.add(ByteString.valueOf(this.append.getValue()));
            attributes.add(new LDAPAttribute("ds-task-import-append", values));
        }
        if (this.replaceExisting.getValue() != null && !this.replaceExisting.getValue().equals(this.replaceExisting.getDefaultValue())) {
            values = new ArrayList(1);
            values.add(ByteString.valueOf(this.replaceExisting.getValue()));
            attributes.add(new LDAPAttribute("ds-task-import-replace-existing", values));
        }
        if (this.backendID.getValue() != null && !this.backendID.getValue().equals(this.backendID.getDefaultValue())) {
            values = new ArrayList(1);
            values.add(ByteString.valueOf(this.backendID.getValue()));
            attributes.add(new LDAPAttribute("ds-task-import-backend-id", values));
        }
        if ((includeAttributes = this.includeAttributeStrings.getValues()) != null && includeAttributes.size() > 0) {
            values = new ArrayList(includeAttributes.size());
            for (String includeAttribute : includeAttributes) {
                values.add(ByteString.valueOf(includeAttribute));
            }
            attributes.add(new LDAPAttribute("ds-task-import-include-attribute", values));
        }
        if ((excludeAttributes = this.excludeAttributeStrings.getValues()) != null && excludeAttributes.size() > 0) {
            values = new ArrayList(excludeAttributes.size());
            for (String excludeAttribute : excludeAttributes) {
                values.add(ByteString.valueOf(excludeAttribute));
            }
            attributes.add(new LDAPAttribute("ds-task-import-exclude-attribute", values));
        }
        if ((includeFilters = this.includeFilterStrings.getValues()) != null && includeFilters.size() > 0) {
            values = new ArrayList(includeFilters.size());
            for (String includeFilter : includeFilters) {
                values.add(ByteString.valueOf(includeFilter));
            }
            attributes.add(new LDAPAttribute("ds-task-import-include-filter", values));
        }
        if ((excludeFilters = this.excludeFilterStrings.getValues()) != null && excludeFilters.size() > 0) {
            values = new ArrayList(excludeFilters.size());
            for (String excludeFilter : excludeFilters) {
                values.add(ByteString.valueOf(excludeFilter));
            }
            attributes.add(new LDAPAttribute("ds-task-import-exclude-filter", values));
        }
        if ((includeBranches = this.includeBranchStrings.getValues()) != null && includeBranches.size() > 0) {
            values = new ArrayList(includeBranches.size());
            for (String includeBranche : includeBranches) {
                values.add(ByteString.valueOf(includeBranche));
            }
            attributes.add(new LDAPAttribute("ds-task-import-include-branch", values));
        }
        if ((excludeBranches = this.excludeBranchStrings.getValues()) != null && excludeBranches.size() > 0) {
            values = new ArrayList(excludeBranches.size());
            for (String excludeBranch : excludeBranches) {
                values.add(ByteString.valueOf(excludeBranch));
            }
            attributes.add(new LDAPAttribute("ds-task-import-exclude-branch", values));
        }
        if (this.rejectFile.getValue() != null && !this.rejectFile.getValue().equals(this.rejectFile.getDefaultValue())) {
            values = new ArrayList(1);
            values.add(ByteString.valueOf(this.rejectFile.getValue()));
            attributes.add(new LDAPAttribute("ds-task-import-reject-file", values));
        }
        if (this.skipFile.getValue() != null && !this.skipFile.getValue().equals(this.skipFile.getDefaultValue())) {
            values = new ArrayList(1);
            values.add(ByteString.valueOf(this.skipFile.getValue()));
            attributes.add(new LDAPAttribute("ds-task-import-skip-file", values));
        }
        if (this.overwrite.getValue() != null && !this.overwrite.getValue().equals(this.overwrite.getDefaultValue())) {
            values = new ArrayList(1);
            values.add(ByteString.valueOf(this.overwrite.getValue()));
            attributes.add(new LDAPAttribute("ds-task-import-overwrite-rejects", values));
        }
        if (this.skipSchemaValidation.getValue() != null && !this.skipSchemaValidation.getValue().equals(this.skipSchemaValidation.getDefaultValue())) {
            values = new ArrayList(1);
            values.add(ByteString.valueOf(this.skipSchemaValidation.getValue()));
            attributes.add(new LDAPAttribute("ds-task-import-skip-schema-validation", values));
        }
        if (this.isCompressed.getValue() != null && !this.isCompressed.getValue().equals(this.isCompressed.getDefaultValue())) {
            values = new ArrayList(1);
            values.add(ByteString.valueOf(this.isCompressed.getValue()));
            attributes.add(new LDAPAttribute("ds-task-import-is-compressed", values));
        }
        if (this.isEncrypted.getValue() != null && !this.isEncrypted.getValue().equals(this.isEncrypted.getDefaultValue())) {
            values = new ArrayList(1);
            values.add(ByteString.valueOf(this.isEncrypted.getValue()));
            attributes.add(new LDAPAttribute("ds-task-import-is-encrypted", values));
        }
        if (this.clearBackend.getValue() != null && !this.clearBackend.getValue().equals(this.clearBackend.getDefaultValue())) {
            values = new ArrayList(1);
            values.add(ByteString.valueOf(this.clearBackend.getValue()));
            attributes.add(new LDAPAttribute("ds-task-import-clear-backend", values));
        }
    }

    @Override
    public String getTaskObjectclass() {
        return "ds-task-import";
    }

    @Override
    public Class getTaskClass() {
        return ImportTask.class;
    }

    @Override
    protected int processLocal(boolean initializeServer, PrintStream out, PrintStream err) {
        ExistingFileBehavior existingBehavior;
        LDIFImportConfig importConfig;
        Message message;
        Message message2;
        ArrayList<List<DN>> dnList;
        ArrayList<BackendCfg> entryList;
        ArrayList<Backend> backendList;
        int code;
        ArrayList<SearchFilter> includeFilters;
        ArrayList<SearchFilter> excludeFilters;
        HashSet<AttributeType> includeAttributes;
        HashSet<AttributeType> excludeAttributes;
        DirectoryServer directoryServer = DirectoryServer.getInstance();
        if (initializeServer) {
            Message message3;
            try {
                DirectoryServer.bootstrapClient();
                DirectoryServer.initializeJMX();
            }
            catch (Exception e) {
                Message message4 = ToolMessages.ERR_SERVER_BOOTSTRAP_ERROR.get(StaticUtils.getExceptionMessage(e));
                err.println(StaticUtils.wrapText(message4, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            try {
                directoryServer.initializeConfiguration(this.configClass.getValue(), this.configFile.getValue());
            }
            catch (InitializationException ie) {
                Message message5 = ToolMessages.ERR_CANNOT_LOAD_CONFIG.get(ie.getMessage());
                err.println(StaticUtils.wrapText(message5, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (Exception e) {
                Message message6 = ToolMessages.ERR_CANNOT_LOAD_CONFIG.get(StaticUtils.getExceptionMessage(e));
                err.println(StaticUtils.wrapText(message6, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            try {
                directoryServer.initializeSchema();
            }
            catch (ConfigException ce) {
                Message message7 = ToolMessages.ERR_CANNOT_LOAD_SCHEMA.get(ce.getMessage());
                err.println(StaticUtils.wrapText(message7, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (InitializationException ie) {
                Message message8 = ToolMessages.ERR_CANNOT_LOAD_SCHEMA.get(ie.getMessage());
                err.println(StaticUtils.wrapText(message8, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (Exception e) {
                Message message9 = ToolMessages.ERR_CANNOT_LOAD_SCHEMA.get(StaticUtils.getExceptionMessage(e));
                err.println(StaticUtils.wrapText(message9, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            try {
                CoreConfigManager coreConfigManager = new CoreConfigManager();
                coreConfigManager.initializeCoreConfig();
            }
            catch (ConfigException ce) {
                Message message10 = ToolMessages.ERR_CANNOT_INITIALIZE_CORE_CONFIG.get(ce.getMessage());
                err.println(StaticUtils.wrapText(message10, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (InitializationException ie) {
                Message message11 = ToolMessages.ERR_CANNOT_INITIALIZE_CORE_CONFIG.get(ie.getMessage());
                err.println(StaticUtils.wrapText(message11, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (Exception e) {
                Message message12 = ToolMessages.ERR_CANNOT_INITIALIZE_CORE_CONFIG.get(StaticUtils.getExceptionMessage(e));
                err.println(StaticUtils.wrapText(message12, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            try {
                directoryServer.initializeCryptoManager();
            }
            catch (ConfigException ce) {
                Message message13 = ToolMessages.ERR_CANNOT_INITIALIZE_CRYPTO_MANAGER.get(ce.getMessage());
                err.println(StaticUtils.wrapText(message13, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (InitializationException ie) {
                Message message14 = ToolMessages.ERR_CANNOT_INITIALIZE_CRYPTO_MANAGER.get(ie.getMessage());
                err.println(StaticUtils.wrapText(message14, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (Exception e) {
                Message message15 = ToolMessages.ERR_CANNOT_INITIALIZE_CRYPTO_MANAGER.get(StaticUtils.getExceptionMessage(e));
                err.println(StaticUtils.wrapText(message15, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            if (!this.quietMode.isPresent()) {
                try {
                    TextErrorLogPublisher errorLogPublisher = TextErrorLogPublisher.getStartupTextErrorPublisher(new TextWriter.STREAM(out));
                    TextDebugLogPublisher debugLogPublisher = TextDebugLogPublisher.getStartupTextDebugPublisher(new TextWriter.STREAM(out));
                    ErrorLogger.addErrorLogPublisher(errorLogPublisher);
                    DebugLogger.addDebugLogPublisher(debugLogPublisher);
                }
                catch (Exception e) {
                    err.println("Error installing the custom error logger: " + StaticUtils.stackTraceToSingleLineString(e));
                }
            }
            try {
                directoryServer.initializePasswordPolicyComponents();
            }
            catch (ConfigException ce) {
                message3 = ToolMessages.ERR_LDIFIMPORT_CANNOT_INITIALIZE_PWPOLICY.get(ce.getMessage());
                err.println(StaticUtils.wrapText(message3, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (InitializationException ie) {
                message3 = ToolMessages.ERR_LDIFIMPORT_CANNOT_INITIALIZE_PWPOLICY.get(ie.getMessage());
                err.println(StaticUtils.wrapText(message3, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (Exception e) {
                message3 = ToolMessages.ERR_LDIFIMPORT_CANNOT_INITIALIZE_PWPOLICY.get(StaticUtils.getExceptionMessage(e));
                err.println(StaticUtils.wrapText(message3, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            try {
                HashSet<PluginType> pluginTypes = new HashSet<PluginType>(1);
                pluginTypes.add(PluginType.LDIF_IMPORT);
                directoryServer.initializePlugins(pluginTypes);
            }
            catch (ConfigException ce) {
                message3 = ToolMessages.ERR_LDIFIMPORT_CANNOT_INITIALIZE_PLUGINS.get(ce.getMessage());
                err.println(StaticUtils.wrapText(message3, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (InitializationException ie) {
                message3 = ToolMessages.ERR_LDIFIMPORT_CANNOT_INITIALIZE_PLUGINS.get(ie.getMessage());
                err.println(StaticUtils.wrapText(message3, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (Exception e) {
                message3 = ToolMessages.ERR_LDIFIMPORT_CANNOT_INITIALIZE_PLUGINS.get(StaticUtils.getExceptionMessage(e));
                err.println(StaticUtils.wrapText(message3, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
        }
        boolean excludeAllUserAttributes = false;
        boolean excludeAllOperationalAttributes = false;
        if (this.excludeAttributeStrings == null) {
            excludeAttributes = null;
        } else {
            excludeAttributes = new HashSet<AttributeType>();
            for (String attrName : this.excludeAttributeStrings.getValues()) {
                String lowerName = attrName.toLowerCase();
                if (lowerName.equals("*")) {
                    excludeAllUserAttributes = true;
                    continue;
                }
                if (lowerName.equals("+")) {
                    excludeAllOperationalAttributes = true;
                    continue;
                }
                AttributeType attrType = DirectoryServer.getAttributeType(lowerName);
                if (attrType == null) {
                    attrType = DirectoryServer.getDefaultAttributeType(attrName);
                }
                excludeAttributes.add(attrType);
            }
        }
        boolean includeAllUserAttributes = false;
        boolean includeAllOperationalAttributes = false;
        if (this.includeAttributeStrings == null) {
            includeAttributes = null;
        } else {
            includeAttributes = new HashSet<AttributeType>();
            for (String attrName : this.includeAttributeStrings.getValues()) {
                String lowerName = attrName.toLowerCase();
                if (lowerName.equals("*")) {
                    includeAllUserAttributes = true;
                    continue;
                }
                if (lowerName.equals("+")) {
                    includeAllOperationalAttributes = true;
                    continue;
                }
                AttributeType attrType = DirectoryServer.getAttributeType(lowerName);
                if (attrType == null) {
                    attrType = DirectoryServer.getDefaultAttributeType(attrName);
                }
                includeAttributes.add(attrType);
            }
        }
        if (this.excludeFilterStrings == null) {
            excludeFilters = null;
        } else {
            excludeFilters = new ArrayList<SearchFilter>();
            for (String filterString : this.excludeFilterStrings.getValues()) {
                try {
                    excludeFilters.add(SearchFilter.createFilterFromString(filterString));
                }
                catch (DirectoryException de) {
                    Message message16 = ToolMessages.ERR_LDIFIMPORT_CANNOT_PARSE_EXCLUDE_FILTER.get(filterString, de.getMessageObject());
                    ErrorLogger.logError(message16);
                    return 1;
                }
                catch (Exception e) {
                    Message message17 = ToolMessages.ERR_LDIFIMPORT_CANNOT_PARSE_EXCLUDE_FILTER.get(filterString, StaticUtils.getExceptionMessage(e));
                    ErrorLogger.logError(message17);
                    return 1;
                }
            }
        }
        if (this.includeFilterStrings == null) {
            includeFilters = null;
        } else {
            includeFilters = new ArrayList<SearchFilter>();
            for (String filterString : this.includeFilterStrings.getValues()) {
                try {
                    includeFilters.add(SearchFilter.createFilterFromString(filterString));
                }
                catch (DirectoryException de) {
                    Message message18 = ToolMessages.ERR_LDIFIMPORT_CANNOT_PARSE_INCLUDE_FILTER.get(filterString, de.getMessageObject());
                    ErrorLogger.logError(message18);
                    return 1;
                }
                catch (Exception e) {
                    Message message19 = ToolMessages.ERR_LDIFIMPORT_CANNOT_PARSE_INCLUDE_FILTER.get(filterString, StaticUtils.getExceptionMessage(e));
                    ErrorLogger.logError(message19);
                    return 1;
                }
            }
        }
        Backend backend = null;
        List<DN> defaultIncludeBranches = null;
        ArrayList<DN> excludeBranches = new ArrayList<DN>();
        ArrayList<DN> includeBranches = new ArrayList<DN>();
        if (this.includeBranchStrings.isPresent()) {
            includeBranches = new ArrayList();
            for (String s : this.includeBranchStrings.getValues()) {
                DN includeBranch;
                try {
                    includeBranch = DN.decode(s);
                }
                catch (DirectoryException de) {
                    Message message20 = ToolMessages.ERR_LDIFIMPORT_CANNOT_DECODE_INCLUDE_BASE.get(s, de.getMessageObject());
                    ErrorLogger.logError(message20);
                    return 1;
                }
                catch (Exception e) {
                    Message message21 = ToolMessages.ERR_LDIFIMPORT_CANNOT_DECODE_INCLUDE_BASE.get(s, StaticUtils.getExceptionMessage(e));
                    ErrorLogger.logError(message21);
                    return 1;
                }
                includeBranches.add(includeBranch);
            }
        }
        if ((code = BackendToolUtils.getBackends(backendList = new ArrayList<Backend>(), entryList = new ArrayList<BackendCfg>(), dnList = new ArrayList<List<DN>>())) != 0) {
            return code;
        }
        int numBackends = backendList.size();
        for (int i = 0; i < numBackends; ++i) {
            Backend b = backendList.get(i);
            if (this.backendID.isPresent()) {
                if (!this.backendID.getValue().equals(b.getBackendID())) {
                    continue;
                }
            } else {
                boolean useBackend = false;
                for (DN baseDN : dnList.get(i)) {
                    for (DN includeDN : includeBranches) {
                        if (!baseDN.isAncestorOf(includeDN)) continue;
                        useBackend = true;
                        break;
                    }
                    if (!useBackend) continue;
                    break;
                }
                if (!useBackend) continue;
            }
            if (backend == null) {
                backend = b;
                defaultIncludeBranches = dnList.get(i);
                continue;
            }
            Message message22 = ToolMessages.ERR_LDIFIMPORT_MULTIPLE_BACKENDS_FOR_ID.get();
            ErrorLogger.logError(message22);
            return 1;
        }
        if (backend == null) {
            Message message23 = ToolMessages.ERR_LDIFIMPORT_NO_BACKENDS_FOR_ID.get();
            ErrorLogger.logError(message23);
            return 1;
        }
        if (!backend.supportsLDIFImport()) {
            Message message24 = ToolMessages.ERR_LDIFIMPORT_CANNOT_IMPORT.get(this.backendID.getValue());
            ErrorLogger.logError(message24);
            return 1;
        }
        for (List<DN> baseList : dnList) {
            block63: for (DN baseDN : baseList) {
                for (DN importBase : defaultIncludeBranches) {
                    if (!baseDN.isDescendantOf(importBase) || baseDN.equals(importBase)) continue;
                    if (excludeBranches.contains(baseDN)) continue block63;
                    excludeBranches.add(baseDN);
                    continue block63;
                }
            }
        }
        if (this.backendID.isPresent() && !this.includeBranchStrings.isPresent() && !this.append.isPresent() && defaultIncludeBranches.size() > 1 && !this.clearBackend.isPresent()) {
            StringBuilder builder = new StringBuilder();
            builder.append(backend.getBaseDNs()[0].toNormalizedString());
            for (int i = 1; i < backend.getBaseDNs().length; ++i) {
                builder.append(" / ");
                builder.append(backend.getBaseDNs()[i].toNormalizedString());
            }
            Message message25 = ToolMessages.ERR_LDIFIMPORT_MISSING_CLEAR_BACKEND.get(builder.toString(), this.clearBackend.getLongIdentifier());
            err.println(StaticUtils.wrapText(message25, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        for (String s : this.excludeBranchStrings.getValues()) {
            DN excludeBranch;
            try {
                excludeBranch = DN.decode(s);
            }
            catch (DirectoryException de) {
                message2 = ToolMessages.ERR_LDIFIMPORT_CANNOT_DECODE_EXCLUDE_BASE.get(s, de.getMessageObject());
                ErrorLogger.logError(message2);
                return 1;
            }
            catch (Exception e) {
                message2 = ToolMessages.ERR_LDIFIMPORT_CANNOT_DECODE_EXCLUDE_BASE.get(s, StaticUtils.getExceptionMessage(e));
                ErrorLogger.logError(message2);
                return 1;
            }
            if (excludeBranches.contains(excludeBranch)) continue;
            excludeBranches.add(excludeBranch);
        }
        if (!this.includeBranchStrings.isPresent()) {
            includeBranches = defaultIncludeBranches;
        } else {
            for (DN includeBranch : includeBranches) {
                if (Backend.handlesEntry(includeBranch, defaultIncludeBranches, excludeBranches)) continue;
                Message message26 = ToolMessages.ERR_LDIFIMPORT_INVALID_INCLUDE_BASE.get(includeBranch.toNormalizedString(), this.backendID.getValue());
                ErrorLogger.logError(message26);
                return 1;
            }
        }
        if (this.ldifFiles.isPresent()) {
            ArrayList<String> fileList = new ArrayList<String>(this.ldifFiles.getValues());
            int badFileCount = 0;
            for (String pathname : fileList) {
                File f = new File(pathname);
                if (f.canRead()) continue;
                message = ToolMessages.ERR_LDIFIMPORT_CANNOT_READ_FILE.get(pathname);
                ErrorLogger.logError(message);
                ++badFileCount;
            }
            if (badFileCount > 0) {
                return 1;
            }
            importConfig = new LDIFImportConfig(fileList);
        } else {
            Random random;
            if (this.randomSeed.isPresent()) {
                try {
                    random = new Random(this.randomSeed.getIntValue());
                }
                catch (Exception e) {
                    random = new Random();
                }
            } else {
                random = new Random();
            }
            String resourcePath = DirectoryServer.getInstanceRoot() + File.separator + ConfigConstants.PATH_MAKELDIF_RESOURCE_DIR;
            TemplateFile tf = new TemplateFile(resourcePath, random);
            ArrayList<Message> warnings = new ArrayList<Message>();
            try {
                tf.parse(this.templateFile.getValue(), warnings);
            }
            catch (Exception e) {
                message = ToolMessages.ERR_LDIFIMPORT_CANNOT_PARSE_TEMPLATE_FILE.get(this.templateFile.getValue(), e.getMessage());
                ErrorLogger.logError(message);
                return 1;
            }
            importConfig = new LDIFImportConfig(tf);
        }
        importConfig.setAppendToExistingData(this.append.isPresent());
        importConfig.setReplaceExistingEntries(this.replaceExisting.isPresent());
        importConfig.setCompressed(this.isCompressed.isPresent());
        importConfig.setClearBackend(this.clearBackend.isPresent());
        importConfig.setEncrypted(this.isEncrypted.isPresent());
        importConfig.setExcludeAttributes(excludeAttributes);
        importConfig.setExcludeBranches(excludeBranches);
        importConfig.setExcludeFilters(excludeFilters);
        importConfig.setIncludeAttributes(includeAttributes);
        importConfig.setIncludeBranches(includeBranches);
        importConfig.setIncludeFilters(includeFilters);
        importConfig.setValidateSchema(!this.skipSchemaValidation.isPresent());
        importConfig.setBufferSize(0x100000);
        importConfig.setExcludeAllUserAttributes(excludeAllUserAttributes);
        importConfig.setExcludeAllOperationalAttributes(excludeAllOperationalAttributes);
        importConfig.setIncludeAllOpAttributes(includeAllOperationalAttributes);
        importConfig.setIncludeAllUserAttributes(includeAllUserAttributes);
        importConfig.setInvokeImportPlugins(true);
        if (this.rejectFile != null) {
            try {
                existingBehavior = this.overwrite.isPresent() ? ExistingFileBehavior.OVERWRITE : ExistingFileBehavior.APPEND;
                importConfig.writeRejectedEntries(this.rejectFile.getValue(), existingBehavior);
            }
            catch (Exception e) {
                Message message27 = ToolMessages.ERR_LDIFIMPORT_CANNOT_OPEN_REJECTS_FILE.get(this.rejectFile.getValue(), StaticUtils.getExceptionMessage(e));
                ErrorLogger.logError(message27);
                return 1;
            }
        }
        if (this.skipFile != null) {
            try {
                existingBehavior = this.overwrite.isPresent() ? ExistingFileBehavior.OVERWRITE : ExistingFileBehavior.APPEND;
                importConfig.writeSkippedEntries(this.skipFile.getValue(), existingBehavior);
            }
            catch (Exception e) {
                Message message28 = ToolMessages.ERR_LDIFIMPORT_CANNOT_OPEN_SKIP_FILE.get(this.skipFile.getValue(), StaticUtils.getExceptionMessage(e));
                ErrorLogger.logError(message28);
                return 1;
            }
        }
        DN[] baseDNs = new DN[defaultIncludeBranches.size()];
        defaultIncludeBranches.toArray(baseDNs);
        try {
            String lockFile = LockFileManager.getBackendLockFileName(backend);
            StringBuilder failureReason = new StringBuilder();
            if (!LockFileManager.acquireExclusiveLock(lockFile, failureReason)) {
                message2 = ToolMessages.ERR_LDIFIMPORT_CANNOT_LOCK_BACKEND.get(backend.getBackendID(), String.valueOf(failureReason));
                ErrorLogger.logError(message2);
                return 1;
            }
        }
        catch (Exception e) {
            Message message29 = ToolMessages.ERR_LDIFIMPORT_CANNOT_LOCK_BACKEND.get(backend.getBackendID(), StaticUtils.getExceptionMessage(e));
            ErrorLogger.logError(message29);
            return 1;
        }
        int retCode = 0;
        try {
            LDIFImportResult importResult = backend.importLDIF(importConfig);
            if (this.countRejects.isPresent()) {
                retCode = importResult.getEntriesRejected() > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)importResult.getEntriesRejected();
            }
        }
        catch (DirectoryException de) {
            message2 = ToolMessages.ERR_LDIFIMPORT_ERROR_DURING_IMPORT.get(de.getMessageObject());
            ErrorLogger.logError(message2);
            retCode = 1;
        }
        catch (Exception e) {
            message2 = ToolMessages.ERR_LDIFIMPORT_ERROR_DURING_IMPORT.get(StaticUtils.getExceptionMessage(e));
            ErrorLogger.logError(message2);
            retCode = 1;
        }
        try {
            String lockFile = LockFileManager.getBackendLockFileName(backend);
            StringBuilder failureReason = new StringBuilder();
            if (!LockFileManager.releaseLock(lockFile, failureReason)) {
                Message message30 = ToolMessages.WARN_LDIFIMPORT_CANNOT_UNLOCK_BACKEND.get(backend.getBackendID(), String.valueOf(failureReason));
                ErrorLogger.logError(message30);
                retCode = 1;
            }
        }
        catch (Exception e) {
            message2 = ToolMessages.WARN_LDIFIMPORT_CANNOT_UNLOCK_BACKEND.get(backend.getBackendID(), StaticUtils.getExceptionMessage(e));
            ErrorLogger.logError(message2);
            retCode = 1;
        }
        importConfig.close();
        return retCode;
    }

    @Override
    public String getTaskId() {
        return null;
    }
}

