/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.servicetag;

import java.net.InetAddress;
import java.net.UnknownHostException;

public class SystemEnvironment {
    private String hostname;
    private String osName;
    private String osVersion;
    private String osArchitecture;
    private static SystemEnvironment sysEnv = null;

    private SystemEnvironment() {
        try {
            this.hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ex) {
            this.hostname = "Unknown host";
        }
        this.osName = System.getProperty("os.name");
        this.osVersion = System.getProperty("os.version");
        this.osArchitecture = System.getProperty("os.arch");
    }

    public static synchronized SystemEnvironment getSystemEnvironment() {
        if (sysEnv == null) {
            sysEnv = new SystemEnvironment();
        }
        return sysEnv;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getOsName() {
        return this.osName;
    }

    public String getOsVersion() {
        return this.osVersion;
    }

    public String getOsArchitecture() {
        return this.osArchitecture;
    }
}

