/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.SchemaMessages;
import org.opends.server.admin.std.server.AttributeSyntaxCfg;
import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.types.ByteSequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IA5StringSyntax
extends AttributeSyntax<AttributeSyntaxCfg> {
    private ApproximateMatchingRule defaultApproximateMatchingRule;
    private EqualityMatchingRule defaultEqualityMatchingRule;
    private OrderingMatchingRule defaultOrderingMatchingRule;
    private SubstringMatchingRule defaultSubstringMatchingRule;

    @Override
    public void initializeSyntax(AttributeSyntaxCfg configuration) throws ConfigException {
        this.defaultApproximateMatchingRule = DirectoryServer.getApproximateMatchingRule("1.3.6.1.4.1.26027.1.4.1");
        if (this.defaultApproximateMatchingRule == null) {
            ErrorLogger.logError(SchemaMessages.ERR_ATTR_SYNTAX_UNKNOWN_APPROXIMATE_MATCHING_RULE.get("1.3.6.1.4.1.26027.1.4.1", "IA5String"));
        }
        this.defaultEqualityMatchingRule = DirectoryServer.getEqualityMatchingRule("1.3.6.1.4.1.1466.109.114.2");
        if (this.defaultEqualityMatchingRule == null) {
            ErrorLogger.logError(SchemaMessages.ERR_ATTR_SYNTAX_UNKNOWN_EQUALITY_MATCHING_RULE.get("1.3.6.1.4.1.1466.109.114.2", "IA5String"));
        }
        this.defaultOrderingMatchingRule = DirectoryServer.getOrderingMatchingRule("2.5.13.3");
        if (this.defaultOrderingMatchingRule == null) {
            ErrorLogger.logError(SchemaMessages.ERR_ATTR_SYNTAX_UNKNOWN_ORDERING_MATCHING_RULE.get("2.5.13.3", "IA5String"));
        }
        this.defaultSubstringMatchingRule = DirectoryServer.getSubstringMatchingRule("1.3.6.1.4.1.1466.109.114.3");
        if (this.defaultSubstringMatchingRule == null) {
            ErrorLogger.logError(SchemaMessages.ERR_ATTR_SYNTAX_UNKNOWN_SUBSTRING_MATCHING_RULE.get("1.3.6.1.4.1.1466.109.114.3", "IA5String"));
        }
    }

    @Override
    public String getSyntaxName() {
        return "IA5String";
    }

    @Override
    public String getOID() {
        return "1.3.6.1.4.1.1466.115.121.1.26";
    }

    @Override
    public String getDescription() {
        return "IA5 String";
    }

    @Override
    public EqualityMatchingRule getEqualityMatchingRule() {
        return this.defaultEqualityMatchingRule;
    }

    @Override
    public OrderingMatchingRule getOrderingMatchingRule() {
        return this.defaultOrderingMatchingRule;
    }

    @Override
    public SubstringMatchingRule getSubstringMatchingRule() {
        return this.defaultSubstringMatchingRule;
    }

    @Override
    public ApproximateMatchingRule getApproximateMatchingRule() {
        return this.defaultApproximateMatchingRule;
    }

    @Override
    public boolean valueIsAcceptable(ByteSequence value, MessageBuilder invalidReason) {
        for (int i = 0; i < value.length(); ++i) {
            byte b = value.byteAt(i);
            if ((b & 0x7F) == b) continue;
            Message message = SchemaMessages.WARN_ATTR_SYNTAX_IA5_ILLEGAL_CHARACTER.get(((Object)value).toString(), String.valueOf(b));
            invalidReason.append(message);
            return false;
        }
        return true;
    }

    @Override
    public boolean isBinary() {
        return false;
    }
}

