/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.server;

import java.io.IOException;
import org.opends.messages.Message;
import org.opends.messages.ReplicationMessages;
import org.opends.server.api.DirectoryThread;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.replication.common.ServerStatus;
import org.opends.server.replication.protocol.AckMsg;
import org.opends.server.replication.protocol.ChangeStatusMsg;
import org.opends.server.replication.protocol.DoneMsg;
import org.opends.server.replication.protocol.EntryMsg;
import org.opends.server.replication.protocol.ErrorMsg;
import org.opends.server.replication.protocol.InitializeRequestMsg;
import org.opends.server.replication.protocol.InitializeTargetMsg;
import org.opends.server.replication.protocol.MonitorMsg;
import org.opends.server.replication.protocol.MonitorRequestMsg;
import org.opends.server.replication.protocol.NotSupportedOldVersionPDUException;
import org.opends.server.replication.protocol.ProtocolSession;
import org.opends.server.replication.protocol.ReplicationMsg;
import org.opends.server.replication.protocol.ResetGenerationIdMsg;
import org.opends.server.replication.protocol.RoutableMsg;
import org.opends.server.replication.protocol.TopologyMsg;
import org.opends.server.replication.protocol.UpdateMsg;
import org.opends.server.replication.protocol.WindowMsg;
import org.opends.server.replication.protocol.WindowProbeMsg;
import org.opends.server.replication.server.ReplicationServerDomain;
import org.opends.server.replication.server.ServerHandler;
import org.opends.server.util.StaticUtils;

public class ServerReader
extends DirectoryThread {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private short serverId;
    private ProtocolSession session;
    private ServerHandler handler;
    private ReplicationServerDomain replicationServerDomain;

    public ServerReader(ProtocolSession session, short serverId, ServerHandler handler, ReplicationServerDomain replicationServerDomain) {
        super("Replication Reader for " + handler.toString() + " in RS " + replicationServerDomain.getReplicationServer().getServerId());
        this.session = session;
        this.serverId = serverId;
        this.handler = handler;
        this.replicationServerDomain = replicationServerDomain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block51: {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("In RS " + this.replicationServerDomain.getReplicationServer().getMonitorInstanceName() + (this.handler.isReplicationServer() ? " RS " : " LS") + " reader starting for serverId=" + this.serverId);
            }
            while (true) {
                Message message;
                try {
                    while (true) {
                        RoutableMsg initializeMsg;
                        ReplicationMsg msg;
                        if ((msg = this.session.receive()) instanceof AckMsg) {
                            AckMsg ack = (AckMsg)msg;
                            this.handler.checkWindow();
                            this.replicationServerDomain.processAck(ack, this.handler);
                            continue;
                        }
                        if (msg instanceof UpdateMsg) {
                            boolean filtered = false;
                            if (this.handler.isLDAPserver()) {
                                ServerStatus dsStatus = this.handler.getStatus();
                                if (dsStatus == ServerStatus.BAD_GEN_ID_STATUS || dsStatus == ServerStatus.FULL_UPDATE_STATUS) {
                                    long referenceGenerationId = this.replicationServerDomain.getGenerationId();
                                    if (dsStatus == ServerStatus.BAD_GEN_ID_STATUS) {
                                        ErrorLogger.logError(ReplicationMessages.ERR_IGNORING_UPDATE_FROM_DS_BADGENID.get(Short.toString(this.replicationServerDomain.getReplicationServer().getServerId()), this.replicationServerDomain.getBaseDn(), ((UpdateMsg)msg).getChangeNumber().toString(), Short.toString(this.handler.getServerId()), Long.toString(referenceGenerationId), Long.toString(this.handler.getGenerationId())));
                                    }
                                    if (dsStatus == ServerStatus.FULL_UPDATE_STATUS) {
                                        ErrorLogger.logError(ReplicationMessages.ERR_IGNORING_UPDATE_FROM_DS_FULLUP.get(Short.toString(this.replicationServerDomain.getReplicationServer().getServerId()), this.replicationServerDomain.getBaseDn(), ((UpdateMsg)msg).getChangeNumber().toString(), Short.toString(this.handler.getServerId())));
                                    }
                                    filtered = true;
                                }
                            } else {
                                long referenceGenerationId = this.replicationServerDomain.getGenerationId();
                                if (referenceGenerationId > 0L && referenceGenerationId != this.handler.getGenerationId()) {
                                    ErrorLogger.logError(ReplicationMessages.ERR_IGNORING_UPDATE_FROM_RS.get(Short.toString(this.replicationServerDomain.getReplicationServer().getServerId()), this.replicationServerDomain.getBaseDn(), ((UpdateMsg)msg).getChangeNumber().toString(), Short.toString(this.handler.getServerId()), Long.toString(referenceGenerationId), Long.toString(this.handler.getGenerationId())));
                                    filtered = true;
                                }
                            }
                            if (filtered) continue;
                            UpdateMsg update = (UpdateMsg)msg;
                            this.handler.decAndCheckWindow();
                            this.replicationServerDomain.put(update, this.handler);
                            continue;
                        }
                        if (msg instanceof WindowMsg) {
                            WindowMsg windowMsg = (WindowMsg)msg;
                            this.handler.updateWindow(windowMsg);
                            continue;
                        }
                        if (msg instanceof InitializeRequestMsg) {
                            initializeMsg = (InitializeRequestMsg)msg;
                            this.handler.process(initializeMsg);
                            continue;
                        }
                        if (msg instanceof InitializeTargetMsg) {
                            initializeMsg = (InitializeTargetMsg)msg;
                            this.handler.process(initializeMsg);
                            continue;
                        }
                        if (msg instanceof EntryMsg) {
                            EntryMsg entryMsg = (EntryMsg)msg;
                            this.handler.process(entryMsg);
                            continue;
                        }
                        if (msg instanceof DoneMsg) {
                            DoneMsg doneMsg = (DoneMsg)msg;
                            this.handler.process(doneMsg);
                            continue;
                        }
                        if (msg instanceof ErrorMsg) {
                            ErrorMsg errorMsg = (ErrorMsg)msg;
                            this.handler.process(errorMsg);
                            continue;
                        }
                        if (msg instanceof ResetGenerationIdMsg) {
                            ResetGenerationIdMsg genIdMsg = (ResetGenerationIdMsg)msg;
                            this.replicationServerDomain.resetGenerationId(this.handler, genIdMsg);
                            continue;
                        }
                        if (msg instanceof WindowProbeMsg) {
                            WindowProbeMsg windowProbeMsg = (WindowProbeMsg)msg;
                            this.handler.process(windowProbeMsg);
                            continue;
                        }
                        if (msg instanceof TopologyMsg) {
                            TopologyMsg topoMsg = (TopologyMsg)msg;
                            this.replicationServerDomain.receiveTopoInfoFromRS(topoMsg, this.handler, true);
                            continue;
                        }
                        if (msg instanceof ChangeStatusMsg) {
                            ChangeStatusMsg csMsg = (ChangeStatusMsg)msg;
                            this.replicationServerDomain.processNewStatus(this.handler, csMsg);
                            continue;
                        }
                        if (msg instanceof MonitorRequestMsg) {
                            MonitorRequestMsg replServerMonitorRequestMsg = (MonitorRequestMsg)msg;
                            this.handler.process(replServerMonitorRequestMsg);
                            continue;
                        }
                        if (msg instanceof MonitorMsg) {
                            MonitorMsg replServerMonitorMsg = (MonitorMsg)msg;
                            this.handler.process(replServerMonitorMsg);
                            continue;
                        }
                        if (msg == null) break;
                    }
                    message = ReplicationMessages.NOTE_READER_NULL_MSG.get(this.handler.toString());
                    ErrorLogger.logError(message);
                }
                catch (NotSupportedOldVersionPDUException e) {
                    if (!DebugLogger.debugEnabled()) continue;
                    TRACER.debugInfo("In " + this.replicationServerDomain.getReplicationServer().getMonitorInstanceName() + ":" + e.getMessage());
                    continue;
                }
                catch (IOException e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugInfo("In RS " + this.replicationServerDomain.getReplicationServer().getMonitorInstanceName() + " reader IO EXCEPTION for serverID=" + this.serverId + StaticUtils.stackTraceToSingleLineString(e) + " " + e.getLocalizedMessage());
                    }
                    message = ReplicationMessages.NOTE_SERVER_DISCONNECT.get(this.handler.toString(), Short.toString(this.replicationServerDomain.getReplicationServer().getServerId()));
                    ErrorLogger.logError(message);
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugInfo("In RS " + this.replicationServerDomain.getReplicationServer().getMonitorInstanceName() + " server reader for serverID=" + this.serverId + " is closing the session");
                    }
                    try {
                        this.session.close();
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                    this.replicationServerDomain.stopServer(this.handler);
                    break block51;
                }
                catch (ClassNotFoundException e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugInfo("In RS <" + this.replicationServerDomain.getReplicationServer().getMonitorInstanceName() + " reader CNF EXCEPTION serverID=" + this.serverId + StaticUtils.stackTraceToSingleLineString(e));
                    }
                    message = ReplicationMessages.ERR_UNKNOWN_MESSAGE.get(this.handler.toString());
                    ErrorLogger.logError(message);
                    break block51;
                    catch (Exception e3) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugInfo("In RS <" + this.replicationServerDomain.getReplicationServer().getMonitorInstanceName() + " server reader EXCEPTION serverID=" + this.serverId + StaticUtils.stackTraceToSingleLineString(e3));
                        }
                        message = ReplicationMessages.NOTE_READER_EXCEPTION.get(this.handler.toString());
                        ErrorLogger.logError(message);
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugInfo("In RS " + this.replicationServerDomain.getReplicationServer().getMonitorInstanceName() + " server reader for serverID=" + this.serverId + " is closing the session");
                        }
                        try {
                            this.session.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        this.replicationServerDomain.stopServer(this.handler);
                        break block51;
                    }
                    finally {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugInfo("In RS " + this.replicationServerDomain.getReplicationServer().getMonitorInstanceName() + " server reader for serverID=" + this.serverId + " is closing the session");
                        }
                        try {
                            this.session.close();
                        }
                        catch (IOException e4) {}
                        this.replicationServerDomain.stopServer(this.handler);
                    }
                }
                break;
            }
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("In RS " + this.replicationServerDomain.getReplicationServer().getMonitorInstanceName() + " server reader for serverID=" + this.serverId + " is closing the session");
            }
            try {
                this.session.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.replicationServerDomain.stopServer(this.handler);
            return;
        }
        if (!DebugLogger.debugEnabled()) return;
        TRACER.debugInfo("In RS " + this.replicationServerDomain.getReplicationServer().getMonitorInstanceName() + (this.handler.isReplicationServer() ? " RS" : " LDAP") + " server reader stopped for serverID=" + this.serverId);
    }
}

