/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.server;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.ReplicationMessages;
import org.opends.server.admin.std.server.MonitorProviderCfg;
import org.opends.server.api.MonitorProvider;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.replication.common.AssuredMode;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.common.DSInfo;
import org.opends.server.replication.common.RSInfo;
import org.opends.server.replication.common.ServerState;
import org.opends.server.replication.common.ServerStatus;
import org.opends.server.replication.common.StatusMachine;
import org.opends.server.replication.common.StatusMachineEvent;
import org.opends.server.replication.protocol.AckMsg;
import org.opends.server.replication.protocol.ChangeStatusMsg;
import org.opends.server.replication.protocol.ErrorMsg;
import org.opends.server.replication.protocol.HeartbeatThread;
import org.opends.server.replication.protocol.NotSupportedOldVersionPDUException;
import org.opends.server.replication.protocol.ProtocolSession;
import org.opends.server.replication.protocol.ProtocolVersion;
import org.opends.server.replication.protocol.ReplServerStartMsg;
import org.opends.server.replication.protocol.ReplicationMsg;
import org.opends.server.replication.protocol.ResetGenerationIdMsg;
import org.opends.server.replication.protocol.RoutableMsg;
import org.opends.server.replication.protocol.ServerStartMsg;
import org.opends.server.replication.protocol.StartSessionMsg;
import org.opends.server.replication.protocol.TopologyMsg;
import org.opends.server.replication.protocol.UpdateMsg;
import org.opends.server.replication.protocol.WindowMsg;
import org.opends.server.replication.protocol.WindowProbeMsg;
import org.opends.server.replication.server.LightweightServerHandler;
import org.opends.server.replication.server.MonitorData;
import org.opends.server.replication.server.MsgQueue;
import org.opends.server.replication.server.ReplicationIterator;
import org.opends.server.replication.server.ReplicationIteratorComparator;
import org.opends.server.replication.server.ReplicationServer;
import org.opends.server.replication.server.ReplicationServerDomain;
import org.opends.server.replication.server.ServerReader;
import org.opends.server.replication.server.ServerWriter;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeBuilder;
import org.opends.server.types.Attributes;
import org.opends.server.types.InitializationException;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.TimeThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerHandler
extends MonitorProvider<MonitorProviderCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static final int SHUTDOWN_JOIN_TIMEOUT = 30000;
    private short serverId;
    private ProtocolSession session;
    private final MsgQueue msgQueue = new MsgQueue();
    private MsgQueue lateQueue = new MsgQueue();
    private ReplicationServerDomain replicationServerDomain = null;
    private String serverURL;
    private int outCount = 0;
    private int inCount = 0;
    private int assuredSrReceivedUpdates = 0;
    private AtomicInteger assuredSrReceivedUpdatesTimeout = new AtomicInteger();
    private int assuredSrSentUpdates = 0;
    private AtomicInteger assuredSrSentUpdatesTimeout = new AtomicInteger();
    private int assuredSdReceivedUpdates = 0;
    private AtomicInteger assuredSdReceivedUpdatesTimeout = new AtomicInteger();
    private int assuredSdSentUpdates = 0;
    private AtomicInteger assuredSdSentUpdatesTimeout = new AtomicInteger();
    private int maxReceiveQueue = 0;
    private int maxSendQueue = 0;
    private int maxReceiveDelay = 0;
    private int maxSendDelay = 0;
    private int maxQueueSize = 5000;
    private int maxQueueBytesSize = this.maxQueueSize * 100;
    private int restartReceiveQueue;
    private int restartSendQueue;
    private int restartReceiveDelay;
    private int restartSendDelay;
    private boolean serverIsLDAPserver;
    private boolean following = false;
    private ServerState serverState;
    private boolean activeWriter = true;
    private ServerWriter writer = null;
    private String baseDn = null;
    private int rcvWindow;
    private int rcvWindowSizeHalf;
    private int maxRcvWindow;
    private ServerReader reader;
    private Semaphore sendWindow;
    private int sendWindowSize;
    private boolean flowControl = false;
    private int saturationCount = 0;
    private short replicationServerId;
    private short protocolVersion = (short)-1;
    private long generationId = -1L;
    private byte groupId = (byte)-1;
    private ServerStatus status = ServerStatus.INVALID_STATUS;
    private List<String> refUrls = new ArrayList<String>();
    private boolean assuredFlag = false;
    private AssuredMode assuredMode = AssuredMode.SAFE_DATA_MODE;
    private byte safeDataLevel = (byte)-1;
    private String serverAddressURL;
    private final Map<Short, LightweightServerHandler> directoryServers = new ConcurrentHashMap<Short, LightweightServerHandler>();
    private long heartbeatInterval = 0L;
    HeartbeatThread heartbeatThread = null;
    private boolean shutdownWriter = false;
    private AtomicBoolean shuttingDown = new AtomicBoolean(false);

    public ServerHandler(ProtocolSession session, int queueSize) {
        super("Server Handler");
        this.session = session;
        this.maxQueueSize = queueSize;
        this.maxQueueBytesSize = queueSize * 100;
        this.protocolVersion = ProtocolVersion.getCurrentVersion();
    }

    public DSInfo toDSInfo() {
        DSInfo dsInfo = new DSInfo(this.serverId, this.replicationServerId, this.generationId, this.status, this.assuredFlag, this.assuredMode, this.safeDataLevel, this.groupId, this.refUrls);
        return dsInfo;
    }

    public RSInfo toRSInfo() {
        RSInfo rsInfo = new RSInfo(this.serverId, this.generationId, this.groupId);
        return rsInfo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start(String baseDn, short replicationServerId, String replicationServerURL, int windowSize, boolean sslEncryption, ReplicationServer replicationServer) {
        block81: {
            ReplicationServerDomain rsd;
            if (baseDn != null && (rsd = replicationServer.getReplicationServerDomain(baseDn, false)) != null) {
                try {
                    rsd.lock();
                }
                catch (InterruptedException ex) {
                    return;
                }
            }
            long oldGenerationId = -100L;
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("In " + replicationServer.getMonitorInstanceName() + " starts a new LS or RS " + (baseDn == null ? "incoming connection" : "outgoing connection"));
            }
            this.replicationServerId = replicationServerId;
            this.rcvWindowSizeHalf = windowSize / 2;
            this.maxRcvWindow = windowSize;
            this.rcvWindow = windowSize;
            long localGenerationId = -1L;
            ReplServerStartMsg outReplServerStartMsg = null;
            boolean log_error_message = true;
            try {
                block84: {
                    block82: {
                        ReplicationMsg msg2;
                        TopologyMsg outTopoMsg;
                        block83: {
                            ReplicationMsg msg;
                            if (baseDn != null) {
                                this.baseDn = baseDn;
                                this.replicationServerDomain = replicationServer.getReplicationServerDomain(baseDn, true);
                                if (!this.replicationServerDomain.hasLock()) {
                                    try {
                                        this.replicationServerDomain.lock();
                                    }
                                    catch (InterruptedException ex) {
                                        return;
                                    }
                                }
                                localGenerationId = this.replicationServerDomain.getGenerationId();
                                ServerState localServerState = this.replicationServerDomain.getDbServerState();
                                outReplServerStartMsg = new ReplServerStartMsg(replicationServerId, replicationServerURL, baseDn, windowSize, localServerState, this.protocolVersion, localGenerationId, sslEncryption, replicationServer.getGroupId(), this.replicationServerDomain.getReplicationServer().getDegradedStatusThreshold());
                                this.session.publish(outReplServerStartMsg);
                            }
                            if ((msg = this.session.receive()) instanceof ServerStartMsg) {
                                ServerStartMsg serverStartMsg = (ServerStartMsg)msg;
                                this.generationId = serverStartMsg.getGenerationId();
                                this.protocolVersion = ProtocolVersion.minWithCurrent(serverStartMsg.getVersion());
                                this.serverId = serverStartMsg.getServerId();
                                this.serverURL = serverStartMsg.getServerURL();
                                this.baseDn = serverStartMsg.getBaseDn();
                                this.serverState = serverStartMsg.getServerState();
                                this.groupId = serverStartMsg.getGroupId();
                                this.maxReceiveDelay = serverStartMsg.getMaxReceiveDelay();
                                this.maxReceiveQueue = serverStartMsg.getMaxReceiveQueue();
                                this.maxSendDelay = serverStartMsg.getMaxSendDelay();
                                this.maxSendQueue = serverStartMsg.getMaxSendQueue();
                                this.heartbeatInterval = serverStartMsg.getHeartbeatInterval();
                                sslEncryption = serverStartMsg.getSSLEncryption();
                                this.restartReceiveQueue = this.maxReceiveQueue > 0 ? (this.maxReceiveQueue > 1000 ? this.maxReceiveQueue - 200 : this.maxReceiveQueue * 8 / 10) : 0;
                                this.restartSendQueue = this.maxSendQueue > 0 ? (this.maxSendQueue > 1000 ? this.maxSendQueue - 200 : this.maxSendQueue * 8 / 10) : 0;
                                this.restartReceiveDelay = this.maxReceiveDelay > 0 ? (this.maxReceiveDelay > 10 ? this.maxReceiveDelay - 1 : this.maxReceiveDelay) : 0;
                                this.restartSendDelay = this.maxSendDelay > 0 ? (this.maxSendDelay > 10 ? this.maxSendDelay - 1 : this.maxSendDelay) : 0;
                                if (this.heartbeatInterval < 0L) {
                                    this.heartbeatInterval = 0L;
                                }
                                this.serverIsLDAPserver = true;
                                this.replicationServerDomain = replicationServer.getReplicationServerDomain(this.baseDn, true);
                                this.replicationServerDomain.waitDisconnection(serverStartMsg.getServerId());
                                if (!this.replicationServerDomain.hasLock()) {
                                    try {
                                        this.replicationServerDomain.lock();
                                    }
                                    catch (InterruptedException ex) {
                                        return;
                                    }
                                }
                                if (!this.replicationServerDomain.checkForDuplicateDS(this)) {
                                    this.closeSession(null);
                                    if (this.replicationServerDomain != null && this.replicationServerDomain.hasLock()) {
                                        this.replicationServerDomain.release();
                                    }
                                    return;
                                }
                                localGenerationId = this.replicationServerDomain.getGenerationId();
                                ServerState localServerState = this.replicationServerDomain.getDbServerState();
                                ReplServerStartMsg replServerStartMsg = new ReplServerStartMsg(replicationServerId, replicationServerURL, this.baseDn, windowSize, localServerState, this.protocolVersion, localGenerationId, sslEncryption, replicationServer.getGroupId(), this.replicationServerDomain.getReplicationServer().getDegradedStatusThreshold());
                                this.session.publish(replServerStartMsg);
                                this.sendWindowSize = serverStartMsg.getWindowSize();
                                if (!sslEncryption) {
                                    this.session.stopEncryption();
                                }
                                if (DebugLogger.debugEnabled()) {
                                    TRACER.debugInfo("In " + this.replicationServerDomain.getReplicationServer().getMonitorInstanceName() + ":" + "\nSH HANDSHAKE RECEIVED:\n" + serverStartMsg.toString() + "\nAND REPLIED:\n" + replServerStartMsg.toString());
                                }
                            } else if (msg instanceof ReplServerStartMsg) {
                                ReplServerStartMsg inReplServerStartMsg = (ReplServerStartMsg)msg;
                                this.protocolVersion = ProtocolVersion.minWithCurrent(inReplServerStartMsg.getVersion());
                                this.generationId = inReplServerStartMsg.getGenerationId();
                                this.serverId = inReplServerStartMsg.getServerId();
                                this.serverURL = inReplServerStartMsg.getServerURL();
                                int separator = this.serverURL.lastIndexOf(58);
                                this.serverAddressURL = this.session.getRemoteAddress() + ":" + this.serverURL.substring(separator + 1);
                                this.serverIsLDAPserver = false;
                                if (this.protocolVersion > 1) {
                                    this.groupId = inReplServerStartMsg.getGroupId();
                                }
                                this.baseDn = inReplServerStartMsg.getBaseDn();
                                if (baseDn == null) {
                                    this.replicationServerDomain = replicationServer.getReplicationServerDomain(this.baseDn, true);
                                    if (!this.replicationServerDomain.hasLock()) {
                                        try {
                                            Random random = new Random();
                                            int randomTime = random.nextInt(6);
                                            long timeout = 3000 + randomTime * 1000;
                                            boolean noTimeout = this.replicationServerDomain.tryLock(timeout);
                                            if (!noTimeout) {
                                                Message message = ReplicationMessages.NOTE_TIMEOUT_WHEN_CROSS_CONNECTION.get(this.baseDn, Short.toString(this.serverId), Short.toString(replicationServer.getServerId()));
                                                this.closeSession(message);
                                                return;
                                            }
                                        }
                                        catch (InterruptedException ex) {
                                            return;
                                        }
                                    }
                                    localGenerationId = this.replicationServerDomain.getGenerationId();
                                    ServerState domServerState = this.replicationServerDomain.getDbServerState();
                                    sslEncryption = inReplServerStartMsg.getSSLEncryption();
                                    outReplServerStartMsg = new ReplServerStartMsg(replicationServerId, replicationServerURL, this.baseDn, windowSize, domServerState, this.protocolVersion, localGenerationId, sslEncryption, replicationServer.getGroupId(), this.replicationServerDomain.getReplicationServer().getDegradedStatusThreshold());
                                    if (this.protocolVersion > 1) {
                                        this.session.publish(outReplServerStartMsg);
                                    } else {
                                        this.session.publish(outReplServerStartMsg, (short)1);
                                    }
                                    if (DebugLogger.debugEnabled()) {
                                        TRACER.debugInfo("In " + this.replicationServerDomain.getReplicationServer().getMonitorInstanceName() + ":" + "\nSH HANDSHAKE RECEIVED:\n" + inReplServerStartMsg.toString() + "\nAND REPLIED:\n" + outReplServerStartMsg.toString());
                                    }
                                } else {
                                    if (!this.baseDn.equals(baseDn)) {
                                        Message message = ReplicationMessages.ERR_RS_DN_DOES_NOT_MATCH.get(this.baseDn.toString(), baseDn.toString());
                                        this.closeSession(message);
                                        if (this.replicationServerDomain != null && this.replicationServerDomain.hasLock()) {
                                            this.replicationServerDomain.release();
                                        }
                                        return;
                                    }
                                    if (DebugLogger.debugEnabled()) {
                                        TRACER.debugInfo("In " + this.replicationServerDomain.getReplicationServer().getMonitorInstanceName() + ":" + "\nSH HANDSHAKE SENT:\n" + outReplServerStartMsg.toString() + "\nAND RECEIVED:\n" + inReplServerStartMsg.toString());
                                    }
                                }
                                this.serverState = inReplServerStartMsg.getServerState();
                                this.sendWindowSize = inReplServerStartMsg.getWindowSize();
                                if (!this.replicationServerDomain.checkForDuplicateRS(this)) {
                                    this.closeSession(null);
                                    if (this.replicationServerDomain != null && this.replicationServerDomain.hasLock()) {
                                        this.replicationServerDomain.release();
                                    }
                                    return;
                                }
                                if (!sslEncryption) {
                                    this.session.stopEncryption();
                                }
                            } else {
                                this.closeSession(null);
                                if (this.replicationServerDomain != null && this.replicationServerDomain.hasLock()) {
                                    this.replicationServerDomain.release();
                                }
                                return;
                            }
                            if (this.protocolVersion <= 1) break block82;
                            outTopoMsg = null;
                            if (baseDn != null) {
                                outTopoMsg = this.replicationServerDomain.createTopologyMsgForRS();
                                this.session.publish(outTopoMsg);
                            }
                            log_error_message = false;
                            msg2 = this.session.receive();
                            log_error_message = true;
                            if (!(msg2 instanceof TopologyMsg)) break block83;
                            TopologyMsg inTopoMsg = (TopologyMsg)msg2;
                            if (this.generationId == localGenerationId) {
                                if (DebugLogger.debugEnabled()) {
                                    TRACER.debugInfo("In " + this.replicationServerDomain.getReplicationServer().getMonitorInstanceName() + " RS with serverID=" + this.serverId + " is connected with the right generation ID");
                                }
                            } else if (localGenerationId > 0L) {
                                if (this.generationId > 0L && this.generationId != localGenerationId) {
                                    if (this.replicationServerDomain.getGenerationIdSavedStatus()) {
                                        Message message = ReplicationMessages.NOTE_BAD_GENERATION_ID_FROM_RS.get(this.baseDn, Short.toString(this.serverId), Long.toString(this.generationId), Long.toString(localGenerationId));
                                        ErrorLogger.logError(message);
                                    } else {
                                        Message message = ReplicationMessages.NOTE_BAD_GENERATION_ID_FROM_RS.get(this.baseDn, Short.toString(this.serverId), Long.toString(this.generationId), Long.toString(localGenerationId));
                                        ErrorLogger.logError(message);
                                    }
                                }
                            } else {
                                oldGenerationId = this.replicationServerDomain.setGenerationId(this.generationId, false);
                            }
                            if (baseDn == null) {
                                outTopoMsg = this.replicationServerDomain.createTopologyMsgForRS();
                                this.session.publish(outTopoMsg);
                                if (DebugLogger.debugEnabled()) {
                                    TRACER.debugInfo("In " + this.replicationServerDomain.getReplicationServer().getMonitorInstanceName() + ":" + "\nSH HANDSHAKE RECEIVED:\n" + inTopoMsg.toString() + "\nAND REPLIED:\n" + outTopoMsg.toString());
                                }
                            } else if (DebugLogger.debugEnabled()) {
                                TRACER.debugInfo("In " + this.replicationServerDomain.getReplicationServer().getMonitorInstanceName() + ":" + "\nSH HANDSHAKE SENT:\n" + outTopoMsg.toString() + "\nAND RECEIVED:\n" + inTopoMsg.toString());
                            }
                            Map<Short, ServerHandler> connectedRSs = this.replicationServerDomain.getConnectedRSs();
                            connectedRSs.put(this.serverId, this);
                            this.replicationServerDomain.receiveTopoInfoFromRS(inTopoMsg, this, false);
                            break block84;
                        }
                        if (msg2 instanceof StartSessionMsg) {
                            StartSessionMsg startSessionMsg = (StartSessionMsg)msg2;
                            this.status = startSessionMsg.getStatus();
                            if (!StatusMachine.isValidInitialStatus(this.status)) {
                                Message mesg = ReplicationMessages.ERR_RS_INVALID_INIT_STATUS.get(this.status.toString(), this.baseDn.toString(), Short.toString(this.serverId));
                                this.closeSession(mesg);
                                if (this.replicationServerDomain != null && this.replicationServerDomain.hasLock()) {
                                    this.replicationServerDomain.release();
                                }
                                return;
                            }
                            this.refUrls = startSessionMsg.getReferralsURLs();
                            this.assuredFlag = startSessionMsg.isAssured();
                            this.assuredMode = startSessionMsg.getAssuredMode();
                            this.safeDataLevel = startSessionMsg.getSafeDataLevel();
                            if (localGenerationId > 0L) {
                                if (this.generationId != localGenerationId) {
                                    Message message = ReplicationMessages.NOTE_BAD_GENERATION_ID_FROM_DS.get(this.baseDn, Short.toString(this.serverId), Long.toString(this.generationId), Long.toString(localGenerationId));
                                    ErrorLogger.logError(message);
                                }
                            } else if (this.generationId > 0L && !this.serverState.isEmpty()) {
                                Message message = ReplicationMessages.NOTE_BAD_GENERATION_ID_FROM_DS.get(this.baseDn, Short.toString(this.serverId), Long.toString(this.generationId), Long.toString(localGenerationId));
                                ErrorLogger.logError(message);
                            } else {
                                oldGenerationId = this.replicationServerDomain.setGenerationId(this.generationId, false);
                            }
                            outTopoMsg = this.replicationServerDomain.createTopologyMsgForDS(this.serverId);
                            this.session.publish(outTopoMsg);
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugInfo("In " + this.replicationServerDomain.getReplicationServer().getMonitorInstanceName() + ":" + "\nSH HANDSHAKE RECEIVED:\n" + startSessionMsg.toString() + "\nAND REPLIED:\n" + outTopoMsg.toString());
                            }
                            Map<Short, ServerHandler> connectedDSs = this.replicationServerDomain.getConnectedDSs();
                            connectedDSs.put(this.serverId, this);
                            this.replicationServerDomain.sendTopoInfoToDSs(this);
                            this.replicationServerDomain.sendTopoInfoToRSs();
                            break block84;
                        } else {
                            this.closeSession(null);
                            if (this.replicationServerDomain != null && this.replicationServerDomain.hasLock()) {
                                this.replicationServerDomain.release();
                            }
                            return;
                        }
                    }
                    if (this.generationId == localGenerationId) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugInfo("In " + this.replicationServerDomain.getReplicationServer().getMonitorInstanceName() + " RS V1 with serverID=" + this.serverId + " is connected with the right generation ID");
                        }
                    } else if (localGenerationId > 0L) {
                        if (this.generationId > 0L && this.generationId != localGenerationId) {
                            Message message;
                            if (this.replicationServerDomain.getGenerationIdSavedStatus()) {
                                message = ReplicationMessages.NOTE_BAD_GENERATION_ID_FROM_RS.get(this.baseDn, Short.toString(this.serverId), Long.toString(this.generationId), Long.toString(localGenerationId));
                                ErrorLogger.logError(message);
                            } else {
                                message = ReplicationMessages.NOTE_BAD_GENERATION_ID_FROM_RS.get(this.baseDn, Short.toString(this.serverId), Long.toString(this.generationId), Long.toString(localGenerationId));
                                ErrorLogger.logError(message);
                            }
                        }
                    } else {
                        oldGenerationId = this.replicationServerDomain.setGenerationId(this.generationId, false);
                    }
                    Map<Short, ServerHandler> connectedRSs = this.replicationServerDomain.getConnectedRSs();
                    connectedRSs.put(this.serverId, this);
                }
                this.session.setSoTimeout(0);
                this.sendWindow = new Semaphore(this.sendWindowSize);
                this.writer = new ServerWriter(this.session, this.serverId, this, this.replicationServerDomain);
                this.reader = new ServerReader(this.session, this.serverId, this, this.replicationServerDomain);
                this.reader.start();
                this.writer.start();
                if (this.heartbeatInterval > 0L) {
                    this.heartbeatThread = new HeartbeatThread("Replication Heartbeat to DS " + this.serverURL + " " + this.serverId + " for " + this.baseDn + " in RS " + replicationServerId, this.session, this.heartbeatInterval / 3L);
                    this.heartbeatThread.start();
                }
                if (this.serverIsLDAPserver && !this.replicationServerDomain.isRunningStatusAnalyzer()) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugInfo("In " + this.replicationServerDomain.getReplicationServer().getMonitorInstanceName() + " SH for remote server " + this.getMonitorInstanceName() + " is starting status analyzer");
                    }
                    this.replicationServerDomain.startStatusAnalyzer();
                }
                DirectoryServer.deregisterMonitorProvider(this.getMonitorInstanceName());
                DirectoryServer.registerMonitorProvider(this);
            }
            catch (NotSupportedOldVersionPDUException e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugInfo("In " + replicationServer.getMonitorInstanceName() + ":" + e.getMessage());
                }
                this.closeSession(null);
            }
            catch (Exception e) {
                if (log_error_message || baseDn != null) {
                    MessageBuilder mb = new MessageBuilder();
                    mb.append(ReplicationMessages.ERR_REPLICATION_SERVER_CONNECTION_ERROR.get(this.getMonitorInstanceName()));
                    mb.append(": " + StaticUtils.stackTraceToSingleLineString(e));
                    this.closeSession(mb.toMessage());
                } else {
                    this.closeSession(null);
                }
                if (oldGenerationId == -100L) break block81;
                this.replicationServerDomain.setGenerationId(oldGenerationId, false);
            }
        }
        if (this.replicationServerDomain != null && this.replicationServerDomain.hasLock()) {
            this.replicationServerDomain.release();
        }
    }

    private void closeSession(Message msg) {
        if (msg != null) {
            ErrorLogger.logError(msg);
        }
        try {
            this.session.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public short getServerId() {
        return this.serverId;
    }

    public String getServerAddressURL() {
        return this.serverAddressURL;
    }

    public String getServerURL() {
        return this.serverURL;
    }

    public void incrementOutCount() {
        ++this.outCount;
    }

    public void incrementInCount() {
        ++this.inCount;
    }

    public int getInCount() {
        return this.inCount;
    }

    public int getOutCount() {
        return this.outCount;
    }

    public int getAssuredSrReceivedUpdates() {
        return this.assuredSrReceivedUpdates;
    }

    public AtomicInteger getAssuredSrReceivedUpdatesTimeout() {
        return this.assuredSrReceivedUpdatesTimeout;
    }

    public int getAssuredSrSentUpdates() {
        return this.assuredSrSentUpdates;
    }

    public AtomicInteger getAssuredSrSentUpdatesTimeout() {
        return this.assuredSrSentUpdatesTimeout;
    }

    public int getAssuredSdReceivedUpdates() {
        return this.assuredSdReceivedUpdates;
    }

    public AtomicInteger getAssuredSdReceivedUpdatesTimeout() {
        return this.assuredSdReceivedUpdatesTimeout;
    }

    public int getAssuredSdSentUpdates() {
        return this.assuredSdSentUpdates;
    }

    public AtomicInteger getAssuredSdSentUpdatesTimeout() {
        return this.assuredSdSentUpdatesTimeout;
    }

    public void incrementAssuredSrReceivedUpdates() {
        ++this.assuredSrReceivedUpdates;
    }

    public void incrementAssuredSrReceivedUpdatesTimeout() {
        this.assuredSrReceivedUpdatesTimeout.incrementAndGet();
    }

    public void incrementAssuredSrSentUpdates() {
        ++this.assuredSrSentUpdates;
    }

    public void incrementAssuredSrSentUpdatesTimeout() {
        this.assuredSrSentUpdatesTimeout.incrementAndGet();
    }

    public void incrementAssuredSdReceivedUpdates() {
        ++this.assuredSdReceivedUpdates;
    }

    public void incrementAssuredSdReceivedUpdatesTimeout() {
        this.assuredSdReceivedUpdatesTimeout.incrementAndGet();
    }

    public void incrementAssuredSdSentUpdates() {
        ++this.assuredSdSentUpdates;
    }

    public void incrementAssuredSdSentUpdatesTimeout() {
        this.assuredSdSentUpdatesTimeout.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSaturated(ChangeNumber changeNumber, ServerHandler sourceHandler) {
        MsgQueue msgQueue = this.msgQueue;
        synchronized (msgQueue) {
            UpdateMsg firstUpdate;
            int size = this.msgQueue.count();
            if (this.maxReceiveQueue > 0 && size >= this.maxReceiveQueue) {
                return true;
            }
            if (sourceHandler.maxSendQueue > 0 && size >= sourceHandler.maxSendQueue) {
                return true;
            }
            if (!this.msgQueue.isEmpty() && (firstUpdate = this.msgQueue.first()) != null) {
                long timeDiff = changeNumber.getTimeSec() - firstUpdate.getChangeNumber().getTimeSec();
                if (this.maxReceiveDelay > 0 && timeDiff >= (long)this.maxReceiveDelay) {
                    return true;
                }
                if (sourceHandler.maxSendDelay > 0 && timeDiff >= (long)sourceHandler.maxSendDelay) {
                    return true;
                }
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean restartAfterSaturation(ServerHandler source) {
        MsgQueue msgQueue = this.msgQueue;
        synchronized (msgQueue) {
            int queueSize = this.msgQueue.count();
            if (this.maxReceiveQueue > 0 && queueSize >= this.restartReceiveQueue) {
                return false;
            }
            if (source != null && source.maxSendQueue > 0 && queueSize >= source.restartSendQueue) {
                return false;
            }
            if (!this.msgQueue.isEmpty()) {
                UpdateMsg firstUpdate = this.msgQueue.first();
                UpdateMsg lastUpdate = this.msgQueue.last();
                if (firstUpdate != null && lastUpdate != null) {
                    long timeDiff = lastUpdate.getChangeNumber().getTimeSec() - firstUpdate.getChangeNumber().getTimeSec();
                    if (this.maxReceiveDelay > 0 && timeDiff >= (long)this.restartReceiveDelay) {
                        return false;
                    }
                    if (source != null && source.maxSendDelay > 0 && timeDiff >= (long)source.restartSendDelay) {
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public boolean isReplicationServer() {
        return !this.serverIsLDAPserver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRcvMsgQueueSize() {
        MsgQueue msgQueue = this.msgQueue;
        synchronized (msgQueue) {
            if (this.isFollowing()) {
                return this.msgQueue.count();
            }
            ServerState dbState = this.replicationServerDomain.getDbServerState();
            return ServerState.diffChanges(dbState, this.serverState);
        }
    }

    public long getApproxDelay() {
        long olderUpdateTime = this.getOlderUpdateTime();
        if (olderUpdateTime == 0L) {
            return 0L;
        }
        long currentTime = TimeThread.getTime();
        return (currentTime - olderUpdateTime) / 1000L;
    }

    public Long getApproxFirstMissingDate() {
        Long result = 0L;
        ChangeNumber olderUpdateCN = this.getOlderUpdateCN();
        if (olderUpdateCN != null) {
            result = olderUpdateCN.getTime();
        }
        return result;
    }

    public long getOlderUpdateTime() {
        ChangeNumber olderUpdateCN = this.getOlderUpdateCN();
        if (olderUpdateCN == null) {
            return 0L;
        }
        return olderUpdateCN.getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChangeNumber getOlderUpdateCN() {
        ChangeNumber result = null;
        MsgQueue msgQueue = this.msgQueue;
        synchronized (msgQueue) {
            if (this.isFollowing()) {
                if (this.msgQueue.isEmpty()) {
                    result = null;
                } else {
                    UpdateMsg msg = this.msgQueue.first();
                    result = msg.getChangeNumber();
                }
            } else if (this.lateQueue.isEmpty()) {
                ReplicationIteratorComparator comparator = new ReplicationIteratorComparator();
                TreeSet<ReplicationIterator> iteratorSortedSet = new TreeSet<ReplicationIterator>(comparator);
                try {
                    for (short serverId : this.replicationServerDomain.getServers()) {
                        ChangeNumber lastCsn;
                        ReplicationIterator iterator = this.replicationServerDomain.getChangelogIterator(serverId, lastCsn = this.serverState.getMaxChangeNumber(serverId));
                        if (iterator == null || iterator.getChange() == null) continue;
                        iteratorSortedSet.add(iterator);
                    }
                    UpdateMsg msg = ((ReplicationIterator)iteratorSortedSet.first()).getChange();
                    result = msg.getChangeNumber();
                }
                catch (Exception e) {
                    result = null;
                    return result;
                }
                finally {
                    for (ReplicationIterator iterator : iteratorSortedSet) {
                        iterator.releaseCursor();
                    }
                }
            } else {
                UpdateMsg msg = this.lateQueue.first();
                result = msg.getChangeNumber();
            }
        }
        return result;
    }

    public boolean isFollowing() {
        return this.following;
    }

    public void setFollowing(boolean following) {
        this.following = following;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(UpdateMsg update, ServerHandler sourceHandler) {
        MsgQueue msgQueue = this.msgQueue;
        synchronized (msgQueue) {
            if (this.msgQueue.isEmpty()) {
                this.msgQueue.notify();
            }
            this.msgQueue.add(update);
            while (this.msgQueue.count() > this.maxQueueSize || this.msgQueue.bytesCount() > this.maxQueueBytesSize) {
                this.setFollowing(false);
                this.msgQueue.removeFirst();
            }
        }
        if (this.isSaturated(update.getChangeNumber(), sourceHandler)) {
            sourceHandler.setSaturated(true);
        }
    }

    private void setSaturated(boolean value) {
        this.flowControl = value;
    }

    public UpdateMsg take() {
        boolean interrupted = true;
        UpdateMsg msg = this.getnextMessage();
        if (++this.saturationCount > 10) {
            this.saturationCount = 0;
            try {
                this.replicationServerDomain.checkAllSaturation();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        boolean acquired = false;
        do {
            try {
                acquired = this.sendWindow.tryAcquire(500L, TimeUnit.MILLISECONDS);
                interrupted = false;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        } while ((interrupted || !acquired) && !this.shutdownWriter);
        if (msg != null) {
            this.incrementOutCount();
            if (msg.isAssured()) {
                if (msg.getAssuredMode() == AssuredMode.SAFE_READ_MODE) {
                    this.incrementAssuredSrSentUpdates();
                } else if (!this.isLDAPserver()) {
                    this.incrementAssuredSdSentUpdates();
                }
            }
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UpdateMsg getnextMessage() {
        while (this.activeWriter) {
            UpdateMsg msg;
            if (!this.following) {
                if (this.lateQueue.isEmpty()) {
                    MsgQueue msgQueue;
                    ReplicationIteratorComparator comparator = new ReplicationIteratorComparator();
                    TreeSet<ReplicationIterator> iteratorSortedSet = new TreeSet<ReplicationIterator>(comparator);
                    for (short serverId : this.replicationServerDomain.getServers()) {
                        ChangeNumber lastCsn;
                        ReplicationIterator iterator = this.replicationServerDomain.getChangelogIterator(serverId, lastCsn = this.serverState.getMaxChangeNumber(serverId));
                        if (iterator == null) continue;
                        if (iterator.getChange() != null) {
                            iteratorSortedSet.add(iterator);
                            continue;
                        }
                        iterator.releaseCursor();
                    }
                    while (!iteratorSortedSet.isEmpty() && this.lateQueue.count() < 100 && this.lateQueue.bytesCount() < 50000) {
                        ReplicationIterator iterator = (ReplicationIterator)iteratorSortedSet.first();
                        iteratorSortedSet.remove(iterator);
                        this.lateQueue.add(iterator.getChange());
                        if (iterator.next()) {
                            iteratorSortedSet.add(iterator);
                            continue;
                        }
                        iterator.releaseCursor();
                    }
                    for (ReplicationIterator iterator : iteratorSortedSet) {
                        iterator.releaseCursor();
                    }
                    if (this.lateQueue.isEmpty()) {
                        msgQueue = this.msgQueue;
                        synchronized (msgQueue) {
                            if (this.msgQueue.count() < this.maxQueueSize && this.msgQueue.bytesCount() < this.maxQueueBytesSize) {
                                this.setFollowing(true);
                            }
                        }
                    } else {
                        msg = this.lateQueue.first();
                        msgQueue = this.msgQueue;
                        synchronized (msgQueue) {
                            if (this.msgQueue.contains(msg)) {
                                UpdateMsg msg1;
                                this.setFollowing(true);
                                this.lateQueue.clear();
                                do {
                                    msg1 = this.msgQueue.removeFirst();
                                } while (!msg.getChangeNumber().equals(msg1.getChangeNumber()));
                                this.updateServerState(msg);
                                return msg;
                            }
                        }
                    }
                } else {
                    msg = this.lateQueue.removeFirst();
                    this.updateServerState(msg);
                    return msg;
                }
            }
            MsgQueue msgQueue = this.msgQueue;
            synchronized (msgQueue) {
                if (this.following) {
                    try {
                        while (this.msgQueue.isEmpty() && this.following) {
                            this.msgQueue.wait(500L);
                            if (this.activeWriter) continue;
                            return null;
                        }
                    }
                    catch (InterruptedException e) {
                        return null;
                    }
                    if (this.following && this.updateServerState(msg = this.msgQueue.removeFirst())) {
                        return msg;
                    }
                }
            }
        }
        return null;
    }

    public boolean updateServerState(UpdateMsg msg) {
        return this.serverState.update(msg.getChangeNumber());
    }

    public ServerState getServerState() {
        return this.serverState;
    }

    public void sendAck(AckMsg ack) throws IOException {
        this.session.publish(ack);
    }

    public boolean isLDAPserver() {
        return this.serverIsLDAPserver;
    }

    @Override
    public void initializeMonitorProvider(MonitorProviderCfg configuration) throws ConfigException, InitializationException {
    }

    @Override
    public String getMonitorInstanceName() {
        String str = this.serverURL + " " + String.valueOf(this.serverId);
        if (this.serverIsLDAPserver) {
            return "Connected Replica " + str + ",cn=" + this.replicationServerDomain.getMonitorInstanceName();
        }
        return "Connected Replication Server " + str + ",cn=" + this.replicationServerDomain.getMonitorInstanceName();
    }

    @Override
    public long getUpdateInterval() {
        return 0L;
    }

    @Override
    public void updateMonitorData() {
    }

    public ArrayList<Attribute> getMonitorData() {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        if (this.serverIsLDAPserver) {
            attributes.add(Attributes.create("replica", this.serverURL));
            attributes.add(Attributes.create("connected-to", this.replicationServerDomain.getReplicationServer().getMonitorInstanceName()));
        } else {
            attributes.add(Attributes.create("Replication-Server", this.serverURL));
        }
        attributes.add(Attributes.create("server-id", String.valueOf(this.serverId)));
        attributes.add(Attributes.create("domain-name", this.baseDn.toString()));
        try {
            MonitorData md = this.replicationServerDomain.computeMonitorData();
            if (this.serverIsLDAPserver) {
                Long approxFirstMissingDate = md.getApproxFirstMissingDate(this.serverId);
                if (approxFirstMissingDate != null && approxFirstMissingDate > 0L) {
                    Date date = new Date(approxFirstMissingDate);
                    attributes.add(Attributes.create("approx-older-change-not-synchronized", date.toString()));
                    attributes.add(Attributes.create("approx-older-change-not-synchronized-millis", String.valueOf(approxFirstMissingDate)));
                }
                long missingChanges = md.getMissingChanges(this.serverId);
                attributes.add(Attributes.create("missing-changes", String.valueOf(missingChanges)));
                long delay = md.getApproxDelay(this.serverId);
                attributes.add(Attributes.create("approximate-delay", String.valueOf(delay)));
                AttributeBuilder builder = new AttributeBuilder("server-state");
                ServerState state = md.getLDAPServerState(this.serverId);
                if (state != null) {
                    for (String str : state.toStringSet()) {
                        builder.add(str);
                    }
                    attributes.add(builder.toAttribute());
                }
            } else {
                long missingChanges = md.getMissingChangesRS(this.serverId);
                attributes.add(Attributes.create("missing-changes", String.valueOf(missingChanges)));
                AttributeBuilder builder = new AttributeBuilder("server-state");
                ServerState state = md.getRSStates(this.serverId);
                if (state != null) {
                    for (String str : state.toStringSet()) {
                        builder.add(str);
                    }
                    attributes.add(builder.toAttribute());
                }
            }
        }
        catch (Exception e) {
            Message message = ReplicationMessages.ERR_ERROR_RETRIEVING_MONITOR_DATA.get(StaticUtils.stackTraceToSingleLineString(e));
            attributes.add(Attributes.create("error", message.toString()));
        }
        attributes.add(Attributes.create("queue-size", String.valueOf(this.msgQueue.count())));
        attributes.add(Attributes.create("queue-size-bytes", String.valueOf(this.msgQueue.bytesCount())));
        attributes.add(Attributes.create("following", String.valueOf(this.following)));
        attributes.add(Attributes.create("max-waiting-changes", String.valueOf(this.maxQueueSize)));
        attributes.add(Attributes.create("sent-updates", String.valueOf(this.getOutCount())));
        attributes.add(Attributes.create("received-updates", String.valueOf(this.getInCount())));
        attributes.add(Attributes.create("assured-sr-received-updates", String.valueOf(this.getAssuredSrReceivedUpdates())));
        attributes.add(Attributes.create("assured-sr-received-updates-timeout", String.valueOf(this.getAssuredSrReceivedUpdatesTimeout())));
        attributes.add(Attributes.create("assured-sr-sent-updates", String.valueOf(this.getAssuredSrSentUpdates())));
        attributes.add(Attributes.create("assured-sr-sent-updates-timeout", String.valueOf(this.getAssuredSrSentUpdatesTimeout())));
        attributes.add(Attributes.create("assured-sd-received-updates", String.valueOf(this.getAssuredSdReceivedUpdates())));
        if (!this.isLDAPserver()) {
            attributes.add(Attributes.create("assured-sd-sent-updates", String.valueOf(this.getAssuredSdSentUpdates())));
            attributes.add(Attributes.create("assured-sd-sent-updates-timeout", String.valueOf(this.getAssuredSdSentUpdatesTimeout())));
        } else {
            attributes.add(Attributes.create("assured-sd-received-updates-timeout", String.valueOf(this.getAssuredSdReceivedUpdatesTimeout())));
        }
        attributes.add(Attributes.create("max-send-window", String.valueOf(this.sendWindowSize)));
        attributes.add(Attributes.create("current-send-window", String.valueOf(this.sendWindow.availablePermits())));
        attributes.add(Attributes.create("max-rcv-window", String.valueOf(this.maxRcvWindow)));
        attributes.add(Attributes.create("current-rcv-window", String.valueOf(this.rcvWindow)));
        attributes.add(Attributes.create("ssl-encryption", String.valueOf(this.session.isEncrypted())));
        attributes.add(Attributes.create("generation-id", String.valueOf(this.generationId)));
        return attributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.shutdownWriter = true;
        this.activeWriter = false;
        MsgQueue msgQueue = this.msgQueue;
        synchronized (msgQueue) {
            this.msgQueue.clear();
            this.msgQueue.notify();
            this.msgQueue.notifyAll();
        }
        try {
            this.session.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        Map<Short, LightweightServerHandler> e = this.directoryServers;
        synchronized (e) {
            for (LightweightServerHandler lsh : this.directoryServers.values()) {
                lsh.stopHandler();
            }
            this.directoryServers.clear();
        }
        if (this.heartbeatThread != null) {
            this.heartbeatThread.shutdown();
        }
        DirectoryServer.deregisterMonitorProvider(this.getMonitorInstanceName());
        try {
            if (this.writer != null && !Thread.currentThread().equals(this.writer)) {
                this.writer.join(30000L);
            }
            if (this.reader != null && !Thread.currentThread().equals(this.reader)) {
                this.reader.join(30000L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public String toString() {
        String localString;
        if (this.serverId != 0) {
            localString = this.serverIsLDAPserver ? "Directory Server " : "Replication Server ";
            localString = localString + this.serverId + " " + this.serverURL + " " + this.baseDn;
        } else {
            localString = "Unknown server";
        }
        return localString;
    }

    public synchronized void decAndCheckWindow() throws IOException {
        --this.rcvWindow;
        this.checkWindow();
    }

    public synchronized void checkWindow() throws IOException {
        if (this.rcvWindow < this.rcvWindowSizeHalf) {
            if (this.flowControl && this.replicationServerDomain.restartAfterSaturation(this)) {
                this.flowControl = false;
            }
            if (!this.flowControl) {
                WindowMsg msg = new WindowMsg(this.rcvWindowSizeHalf);
                this.session.publish(msg);
                this.rcvWindow += this.rcvWindowSizeHalf;
            }
        }
    }

    public void updateWindow(WindowMsg windowMsg) {
        this.sendWindow.release(windowMsg.getNumAck());
    }

    public long getHeartbeatInterval() {
        return this.heartbeatInterval;
    }

    public void process(RoutableMsg msg) {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("In " + this.replicationServerDomain.getReplicationServer().getMonitorInstanceName() + " SH for remote server " + this.getMonitorInstanceName() + ":" + "\nprocesses received msg:\n" + msg);
        }
        this.replicationServerDomain.process(msg, this);
    }

    public void sendTopoInfo(TopologyMsg topoMsg) throws IOException {
        if (this.protocolVersion > 1) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("In " + this.replicationServerDomain.getReplicationServer().getMonitorInstanceName() + " SH for remote server " + this.getMonitorInstanceName() + ":" + "\nsends message:\n" + topoMsg);
            }
            this.session.publish(topoMsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveTopoInfoFromRS(TopologyMsg topoMsg) {
        List<RSInfo> rsInfos = topoMsg.getRsList();
        RSInfo rsInfo = rsInfos.get(0);
        this.generationId = rsInfo.getGenerationId();
        this.groupId = rsInfo.getGroupId();
        List<DSInfo> dsInfos = topoMsg.getDsList();
        Map<Short, LightweightServerHandler> map = this.directoryServers;
        synchronized (map) {
            for (LightweightServerHandler lsh : this.directoryServers.values()) {
                lsh.stopHandler();
            }
            this.directoryServers.clear();
            for (DSInfo dsInfo : dsInfos) {
                LightweightServerHandler lsh = new LightweightServerHandler(this, this.serverId, dsInfo.getDsId(), dsInfo.getGenerationId(), dsInfo.getGroupId(), dsInfo.getStatus(), dsInfo.getRefUrls(), dsInfo.isAssured(), dsInfo.getAssuredMode(), dsInfo.getSafeDataLevel());
                lsh.startHandler();
                this.directoryServers.put(lsh.getServerId(), lsh);
            }
        }
    }

    public ServerStatus processNewStatus(ChangeStatusMsg csMsg) {
        if (!this.serverIsLDAPserver) {
            Message msg = ReplicationMessages.ERR_RECEIVED_CHANGE_STATUS_NOT_FROM_DS.get(this.baseDn.toString(), Short.toString(this.serverId), csMsg.toString());
            ErrorLogger.logError(msg);
            return ServerStatus.INVALID_STATUS;
        }
        ServerStatus reqStatus = csMsg.getNewStatus();
        StatusMachineEvent event = StatusMachineEvent.statusToEvent(reqStatus);
        if (event == StatusMachineEvent.INVALID_EVENT) {
            Message msg = ReplicationMessages.ERR_RS_INVALID_NEW_STATUS.get(reqStatus.toString(), this.baseDn.toString(), Short.toString(this.serverId));
            ErrorLogger.logError(msg);
            return ServerStatus.INVALID_STATUS;
        }
        ServerStatus newStatus = StatusMachine.computeNewStatus(this.status, event);
        if (newStatus == ServerStatus.INVALID_STATUS) {
            Message msg = ReplicationMessages.ERR_RS_CANNOT_CHANGE_STATUS.get(this.baseDn.toString(), Short.toString(this.serverId), this.status.toString(), event.toString());
            ErrorLogger.logError(msg);
            return ServerStatus.INVALID_STATUS;
        }
        this.status = newStatus;
        return this.status;
    }

    public ServerStatus changeStatusFromStatusAnalyzer(StatusMachineEvent event) throws IOException {
        ServerStatus newStatus = StatusMachine.computeNewStatus(this.status, event);
        if (newStatus == ServerStatus.INVALID_STATUS) {
            Message msg = ReplicationMessages.ERR_RS_CANNOT_CHANGE_STATUS.get(this.baseDn.toString(), Short.toString(this.serverId), this.status.toString(), event.toString());
            ErrorLogger.logError(msg);
            return newStatus;
        }
        ChangeStatusMsg csMsg = new ChangeStatusMsg(newStatus, ServerStatus.INVALID_STATUS);
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("In RS " + this.replicationServerDomain.getReplicationServer().getServerId() + " Sending change status from status analyzer to " + this.getServerId() + " for baseDn " + this.baseDn + ":\n" + csMsg);
        }
        this.session.publish(csMsg);
        this.status = newStatus;
        return newStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRemoteLDAPServer(short wantedServer) {
        Map<Short, LightweightServerHandler> map = this.directoryServers;
        synchronized (map) {
            for (LightweightServerHandler server : this.directoryServers.values()) {
                if (wantedServer != server.getServerId()) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasRemoteLDAPServers() {
        Map<Short, LightweightServerHandler> map = this.directoryServers;
        synchronized (map) {
            return !this.directoryServers.isEmpty();
        }
    }

    public void send(RoutableMsg msg) throws IOException {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("In " + this.replicationServerDomain.getReplicationServer().getMonitorInstanceName() + " SH for remote server " + this.getMonitorInstanceName() + ":" + "\nsends message:\n" + msg);
        }
        this.session.publish(msg);
    }

    public void sendError(ErrorMsg errorMsg) throws IOException {
        this.session.publish(errorMsg);
    }

    public void process(WindowProbeMsg windowProbeMsg) throws IOException {
        if (this.rcvWindow > 0) {
            WindowMsg msg = new WindowMsg(this.rcvWindow);
            this.session.publish(msg);
        } else {
            this.checkWindow();
        }
    }

    public long getGenerationId() {
        return this.generationId;
    }

    public void forwardGenerationIdToRS(ResetGenerationIdMsg msg) throws IOException {
        this.session.publish(msg);
    }

    public void setGenerationId(long generationId) {
        this.generationId = generationId;
    }

    public ReplicationServerDomain getDomain() {
        return this.replicationServerDomain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Short> getConnectedDirectoryServerIds() {
        Map<Short, LightweightServerHandler> map = this.directoryServers;
        synchronized (map) {
            return this.directoryServers.keySet();
        }
    }

    public void changeStatusForResetGenId(long newGenId) throws IOException {
        StatusMachineEvent event = null;
        if (newGenId == -1L) {
            event = StatusMachineEvent.TO_BAD_GEN_ID_STATUS_EVENT;
        } else {
            if (newGenId == this.generationId) {
                if (this.status == ServerStatus.BAD_GEN_ID_STATUS) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugInfo("In RS " + this.replicationServerDomain.getReplicationServer().getServerId() + ". Closing connection to DS " + this.getServerId() + " for baseDn " + this.baseDn + " to force reconnection as new local" + " generation id and remote one match and DS is in bad gen id: " + newGenId);
                    }
                    try {
                        if (this.session != null) {
                            this.session.close();
                        }
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    this.status = ServerStatus.NOT_CONNECTED_STATUS;
                    return;
                }
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugInfo("In RS " + this.replicationServerDomain.getReplicationServer().getServerId() + ". DS " + this.getServerId() + " for baseDn " + this.baseDn + " has already generation id " + newGenId + " so no ChangeStatusMsg sent to him.");
                }
                return;
            }
            event = StatusMachineEvent.TO_BAD_GEN_ID_STATUS_EVENT;
        }
        if (event == StatusMachineEvent.TO_BAD_GEN_ID_STATUS_EVENT && this.status == ServerStatus.FULL_UPDATE_STATUS) {
            Message message = ReplicationMessages.NOTE_BAD_GEN_ID_IN_FULL_UPDATE.get(Short.toString(this.replicationServerDomain.getReplicationServer().getServerId()), this.baseDn.toString(), Short.toString(this.serverId), Long.toString(this.generationId), Long.toString(newGenId));
            ErrorLogger.logError(message);
            return;
        }
        ServerStatus newStatus = StatusMachine.computeNewStatus(this.status, event);
        if (newStatus == ServerStatus.INVALID_STATUS) {
            Message msg = ReplicationMessages.ERR_RS_CANNOT_CHANGE_STATUS.get(this.baseDn.toString(), Short.toString(this.serverId), this.status.toString(), event.toString());
            ErrorLogger.logError(msg);
            return;
        }
        ChangeStatusMsg csMsg = new ChangeStatusMsg(newStatus, ServerStatus.INVALID_STATUS);
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("In RS " + this.replicationServerDomain.getReplicationServer().getServerId() + " Sending change status for reset gen id to " + this.getServerId() + " for baseDn " + this.baseDn + ":\n" + csMsg);
        }
        this.session.publish(csMsg);
        this.status = newStatus;
    }

    public boolean engageShutdown() {
        return this.shuttingDown.getAndSet(true);
    }

    public ServerStatus getStatus() {
        return this.status;
    }

    public short getProtocolVersion() {
        return this.protocolVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDSInfos(List<DSInfo> dsInfos) {
        Map<Short, LightweightServerHandler> map = this.directoryServers;
        synchronized (map) {
            for (LightweightServerHandler ls : this.directoryServers.values()) {
                dsInfos.add(ls.toDSInfo());
            }
        }
    }

    public byte getGroupId() {
        return this.groupId;
    }
}

