/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.server;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.replication.common.AssuredMode;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.protocol.AckMsg;
import org.opends.server.replication.server.ExpectedAcksInfo;
import org.opends.server.replication.server.ServerHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SafeReadExpectedAcksInfo
extends ExpectedAcksInfo {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private boolean hasTimeout = false;
    private boolean hasWrongStatus = false;
    private boolean hasReplayError = false;
    private List<Short> failedServers = new ArrayList<Short>();
    private int numKnownAckStatus = 0;

    public SafeReadExpectedAcksInfo(ChangeNumber changeNumber, ServerHandler requesterServerHandler, List<Short> expectedServers, List<Short> wrongStatusServers) {
        super(changeNumber, requesterServerHandler, AssuredMode.SAFE_READ_MODE, expectedServers);
        if (wrongStatusServers.size() > 0) {
            this.hasWrongStatus = true;
            this.failedServers = wrongStatusServers;
        }
    }

    public void setHasTimeout(boolean hasTimeout) {
        this.hasTimeout = hasTimeout;
    }

    public void setHasWrongStatus(boolean hasWrongStatus) {
        this.hasWrongStatus = hasWrongStatus;
    }

    public void setHasReplayError(boolean hasReplayError) {
        this.hasReplayError = hasReplayError;
    }

    public boolean hasTimeout() {
        return this.hasTimeout;
    }

    public boolean hasWrongStatus() {
        return this.hasWrongStatus;
    }

    public boolean hasReplayError() {
        return this.hasReplayError;
    }

    @Override
    public boolean processReceivedAck(ServerHandler ackingServer, AckMsg ackMsg) {
        short ackingServerId = ackingServer.getServerId();
        boolean ackReceived = (Boolean)this.expectedServersAckStatus.get(ackingServerId);
        if (ackReceived) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Received unexpected ack from server id: " + ackingServerId + " ack message: " + ackMsg);
            }
            return false;
        }
        boolean someErrors = false;
        if (ackMsg.hasTimeout()) {
            this.hasTimeout = true;
            someErrors = true;
        }
        if (ackMsg.hasWrongStatus()) {
            this.hasWrongStatus = true;
            someErrors = true;
        }
        if (ackMsg.hasReplayError()) {
            this.hasReplayError = true;
            someErrors = true;
        }
        if (someErrors) {
            this.failedServers.addAll(ackMsg.getFailedServers());
        }
        this.expectedServersAckStatus.put(ackingServerId, true);
        ++this.numKnownAckStatus;
        return this.numKnownAckStatus == this.expectedServersAckStatus.size();
    }

    @Override
    public AckMsg createAck(boolean timeout) {
        AckMsg ack = new AckMsg(this.changeNumber);
        ack.setHasTimeout(this.hasTimeout);
        ack.setHasWrongStatus(this.hasWrongStatus);
        ack.setHasReplayError(this.hasReplayError);
        if (timeout) {
            ack.setHasTimeout(true);
            Set serverIds = this.expectedServersAckStatus.keySet();
            this.serversInTimeout = new ArrayList();
            for (Short serverId : serverIds) {
                boolean ackReceived = (Boolean)this.expectedServersAckStatus.get(serverId);
                if (ackReceived || this.failedServers.contains(serverId)) continue;
                this.failedServers.add(serverId);
                this.serversInTimeout.add(serverId);
            }
        }
        ack.setFailedServers(this.failedServers);
        return ack;
    }
}

