/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.server;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.replication.common.AssuredMode;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.protocol.AckMsg;
import org.opends.server.replication.server.ExpectedAcksInfo;
import org.opends.server.replication.server.ServerHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SafeDataExpectedAcksInfo
extends ExpectedAcksInfo {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private byte safeDataLevel = (byte)-1;
    private byte numReceivedAcks = 1;

    public SafeDataExpectedAcksInfo(ChangeNumber changeNumber, ServerHandler requesterServerHandler, byte safeDataLevel, List<Short> expectedServers) {
        super(changeNumber, requesterServerHandler, AssuredMode.SAFE_DATA_MODE, expectedServers);
        this.safeDataLevel = safeDataLevel;
    }

    @Override
    public boolean processReceivedAck(ServerHandler ackingServer, AckMsg ackMsg) {
        if (ackingServer.isLDAPserver()) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Received unexpected SD ack from DS id: " + ackingServer.getServerId() + " ack message: " + ackMsg);
            }
            return false;
        }
        short ackingServerId = ackingServer.getServerId();
        boolean ackReceived = (Boolean)this.expectedServersAckStatus.get(ackingServerId);
        if (ackReceived) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Received unexpected ack from server id: " + ackingServerId + " ack message: " + ackMsg);
            }
            return false;
        }
        this.expectedServersAckStatus.put(ackingServerId, true);
        this.numReceivedAcks = (byte)(this.numReceivedAcks + 1);
        return this.numReceivedAcks == this.safeDataLevel;
    }

    @Override
    public AckMsg createAck(boolean timeout) {
        AckMsg ack = new AckMsg(this.changeNumber);
        if (timeout) {
            ack.setHasTimeout(true);
            ArrayList<Short> failedServers = new ArrayList<Short>();
            Set serverIds = this.expectedServersAckStatus.keySet();
            this.serversInTimeout = new ArrayList();
            for (Short serverId : serverIds) {
                boolean ackReceived = (Boolean)this.expectedServersAckStatus.get(serverId);
                if (ackReceived) continue;
                failedServers.add(serverId);
                this.serversInTimeout.add(serverId);
            }
            ack.setFailedServers(failedServers);
        }
        return ack;
    }
}

