/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.server;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opends.server.replication.common.AssuredMode;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.protocol.AckMsg;
import org.opends.server.replication.server.ServerHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExpectedAcksInfo {
    private ServerHandler requesterServerHandler = null;
    private AssuredMode assuredMode = null;
    protected ChangeNumber changeNumber = null;
    private boolean completed = false;
    protected Map<Short, Boolean> expectedServersAckStatus = new HashMap<Short, Boolean>();
    protected List<Short> serversInTimeout = null;

    protected ExpectedAcksInfo(ChangeNumber changeNumber, ServerHandler requesterServerHandler, AssuredMode assuredMode, List<Short> expectedServers) {
        this.requesterServerHandler = requesterServerHandler;
        this.assuredMode = assuredMode;
        this.changeNumber = changeNumber;
        for (Short serverId : expectedServers) {
            this.expectedServersAckStatus.put(serverId, false);
        }
    }

    public ServerHandler getRequesterServer() {
        return this.requesterServerHandler;
    }

    public List<Short> getTimeoutServers() {
        return this.serversInTimeout;
    }

    public AssuredMode getAssuredMode() {
        return this.assuredMode;
    }

    public abstract boolean processReceivedAck(ServerHandler var1, AckMsg var2);

    public abstract AckMsg createAck(boolean var1);

    public boolean isCompleted() {
        return this.completed;
    }

    public void completed() {
        this.completed = true;
    }
}

