/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.protocol;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.util.zip.DataFormatException;
import javax.net.ssl.SSLSocket;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.replication.protocol.NotSupportedOldVersionPDUException;
import org.opends.server.replication.protocol.ProtocolSession;
import org.opends.server.replication.protocol.ProtocolVersion;
import org.opends.server.replication.protocol.ReplicationMsg;

public class TLSSocketSession
implements ProtocolSession {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private Socket plainSocket;
    private SSLSocket secureSocket;
    private InputStream input;
    private OutputStream output;
    private InputStream plainInput;
    private OutputStream plainOutput;
    byte[] rcvLengthBuf = new byte[8];
    private long lastPublishTime = 0L;
    private long lastReceiveTime = 0L;

    public TLSSocketSession(Socket socket, SSLSocket secureSocket) throws IOException {
        this.plainSocket = socket;
        this.secureSocket = secureSocket;
        this.plainInput = this.plainSocket.getInputStream();
        this.plainOutput = this.plainSocket.getOutputStream();
        this.input = secureSocket.getInputStream();
        this.output = secureSocket.getOutputStream();
    }

    public void close() throws IOException {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Closing SocketSession." + Thread.currentThread().getStackTrace());
        }
        if (this.plainSocket != null && !this.plainSocket.isClosed()) {
            this.plainInput.close();
            this.plainOutput.close();
            this.plainSocket.close();
        }
        if (this.secureSocket != null && !this.secureSocket.isClosed()) {
            this.input.close();
            this.output.close();
            this.secureSocket.close();
        }
    }

    public synchronized void publish(ReplicationMsg msg) throws IOException {
        this.publish(msg, ProtocolVersion.getCurrentVersion());
    }

    public synchronized void publish(ReplicationMsg msg, short reqProtocolVersion) throws IOException {
        byte[] buffer = msg.getBytes(reqProtocolVersion);
        String str = String.format("%08x", buffer.length);
        byte[] sendLengthBuf = str.getBytes();
        this.output.write(sendLengthBuf);
        this.output.write(buffer);
        this.output.flush();
        this.lastPublishTime = System.currentTimeMillis();
    }

    public ReplicationMsg receive() throws IOException, ClassNotFoundException, DataFormatException, NotSupportedOldVersionPDUException {
        int length;
        int read;
        this.lastReceiveTime = System.currentTimeMillis();
        for (length = 0; length < 8; length += read) {
            read = this.input.read(this.rcvLengthBuf, length, 8 - length);
            if (read != -1) continue;
            this.lastReceiveTime = 0L;
            throw new IOException("no more data");
        }
        int totalLength = Integer.parseInt(new String(this.rcvLengthBuf), 16);
        try {
            byte[] buffer = new byte[totalLength];
            for (length = 0; length < totalLength; length += this.input.read(buffer, length, totalLength - length)) {
            }
            this.lastReceiveTime = 0L;
            return ReplicationMsg.generateMsg(buffer);
        }
        catch (OutOfMemoryError e) {
            throw new IOException("Packet too large, can't allocate " + totalLength + " bytes.");
        }
    }

    public void stopEncryption() {
        this.input = this.plainInput;
        this.output = this.plainOutput;
    }

    public boolean isEncrypted() {
        return this.input != this.plainInput;
    }

    public long getLastPublishTime() {
        return this.lastPublishTime;
    }

    public long getLastReceiveTime() {
        if (this.lastReceiveTime == 0L) {
            return System.currentTimeMillis();
        }
        return this.lastReceiveTime;
    }

    public String getRemoteAddress() {
        return this.plainSocket.getInetAddress().getHostAddress();
    }

    public void setSoTimeout(int timeout) throws SocketException {
        this.plainSocket.setSoTimeout(timeout);
    }
}

