/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.protocol;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.DataFormatException;
import org.opends.server.replication.common.AssuredMode;
import org.opends.server.replication.common.ServerStatus;
import org.opends.server.replication.protocol.ReplicationMsg;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StartSessionMsg
extends ReplicationMsg {
    private List<String> referralsURLs = new ArrayList<String>();
    private ServerStatus status = ServerStatus.INVALID_STATUS;
    private boolean assuredFlag = false;
    private AssuredMode assuredMode = AssuredMode.SAFE_DATA_MODE;
    private byte safeDataLevel = 1;

    public StartSessionMsg(byte[] in) throws DataFormatException {
        try {
            int length;
            if (in.length < 1 || in[0] != 27) {
                throw new DataFormatException("Input is not a valid " + this.getClass().getCanonicalName());
            }
            this.status = ServerStatus.valueOf(in[1]);
            this.assuredFlag = in[2] == 1;
            this.assuredMode = AssuredMode.valueOf(in[3]);
            this.safeDataLevel = in[4];
            this.referralsURLs = new ArrayList<String>();
            for (int pos = 5; pos < in.length; pos += length + 1) {
                length = this.getNextLength(in, pos);
                this.referralsURLs.add(new String(in, pos, length, "UTF-8"));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new DataFormatException("UTF-8 is not supported by this jvm.");
        }
        catch (IllegalArgumentException e) {
            throw new DataFormatException(e.getMessage());
        }
    }

    public StartSessionMsg(ServerStatus status, List<String> referralsURLs, boolean assuredFlag, AssuredMode assuredMode, byte safeDataLevel) {
        this.referralsURLs = referralsURLs;
        this.status = status;
        this.assuredFlag = assuredFlag;
        this.assuredMode = assuredMode;
        this.safeDataLevel = safeDataLevel;
    }

    public StartSessionMsg(ServerStatus status, List<String> referralsURLs) {
        this.referralsURLs = referralsURLs;
        this.status = status;
        this.assuredFlag = false;
    }

    @Override
    public byte[] getBytes() {
        try {
            ByteArrayOutputStream oStream = new ByteArrayOutputStream();
            oStream.write(27);
            oStream.write(this.status.getValue());
            oStream.write(this.assuredFlag ? 1 : 0);
            oStream.write(this.assuredMode.getValue());
            oStream.write(this.safeDataLevel);
            if (this.referralsURLs.size() >= 1) {
                for (String url : this.referralsURLs) {
                    byte[] byteArrayURL = url.getBytes("UTF-8");
                    oStream.write(byteArrayURL);
                    oStream.write(0);
                }
            }
            return oStream.toByteArray();
        }
        catch (IOException e) {
            return null;
        }
    }

    public List<String> getReferralsURLs() {
        return this.referralsURLs;
    }

    public ServerStatus getStatus() {
        return this.status;
    }

    public String toString() {
        String urls = "";
        for (String s : this.referralsURLs) {
            urls = urls + s + " | ";
        }
        return "StartSessionMsg content:\nstatus: " + (Object)((Object)this.status) + "\nassuredFlag: " + this.assuredFlag + "\nassuredMode: " + (Object)((Object)this.assuredMode) + "\nsafeDataLevel: " + this.safeDataLevel + "\nreferralsURLs: " + urls;
    }

    public boolean isAssured() {
        return this.assuredFlag;
    }

    public AssuredMode getAssuredMode() {
        return this.assuredMode;
    }

    public byte getSafeDataLevel() {
        return this.safeDataLevel;
    }
}

