/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.protocol;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.util.zip.DataFormatException;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.replication.protocol.NotSupportedOldVersionPDUException;
import org.opends.server.replication.protocol.ProtocolSession;
import org.opends.server.replication.protocol.ProtocolVersion;
import org.opends.server.replication.protocol.ReplicationMsg;
import org.opends.server.util.StaticUtils;

public class SocketSession
implements ProtocolSession {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private Socket socket;
    private InputStream input;
    private OutputStream output;
    byte[] rcvLengthBuf = new byte[8];
    private long lastPublishTime = 0L;
    private long lastReceiveTime = 0L;

    public SocketSession(Socket socket) throws IOException {
        this.socket = socket;
        this.input = socket.getInputStream();
        this.output = socket.getOutputStream();
    }

    public void close() throws IOException {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Closing SocketSession." + StaticUtils.stackTraceToSingleLineString(new Exception()));
        }
        this.socket.close();
    }

    public synchronized void publish(ReplicationMsg msg) throws IOException {
        this.publish(msg, ProtocolVersion.getCurrentVersion());
    }

    public synchronized void publish(ReplicationMsg msg, short reqProtocolVersion) throws IOException {
        byte[] buffer = msg.getBytes(reqProtocolVersion);
        String str = String.format("%08x", buffer.length);
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("SocketSession publish <" + str + ">");
        }
        byte[] sendLengthBuf = str.getBytes();
        this.output.write(sendLengthBuf);
        this.output.write(buffer);
        this.output.flush();
        this.lastPublishTime = System.currentTimeMillis();
    }

    public ReplicationMsg receive() throws IOException, ClassNotFoundException, DataFormatException, NotSupportedOldVersionPDUException {
        int length;
        int read;
        this.lastReceiveTime = System.currentTimeMillis();
        for (length = 0; length < 8; length += read) {
            read = this.input.read(this.rcvLengthBuf, length, 8 - length);
            if (read != -1) continue;
            this.lastReceiveTime = 0L;
            throw new IOException("no more data");
        }
        int totalLength = Integer.parseInt(new String(this.rcvLengthBuf), 16);
        try {
            byte[] buffer = new byte[totalLength];
            for (length = 0; length < totalLength; length += this.input.read(buffer, length, totalLength - length)) {
            }
            this.lastReceiveTime = 0L;
            return ReplicationMsg.generateMsg(buffer);
        }
        catch (OutOfMemoryError e) {
            throw new IOException("Packet too large, can't allocate " + totalLength + " bytes.");
        }
    }

    public void stopEncryption() {
    }

    public boolean isEncrypted() {
        return false;
    }

    public long getLastPublishTime() {
        return this.lastPublishTime;
    }

    public long getLastReceiveTime() {
        if (this.lastReceiveTime == 0L) {
            return System.currentTimeMillis();
        }
        return this.lastReceiveTime;
    }

    public String getRemoteAddress() {
        return this.socket.getInetAddress().getHostAddress();
    }

    public void setSoTimeout(int timeout) throws SocketException {
        this.socket.setSoTimeout(timeout);
    }
}

