/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.protocol;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.zip.DataFormatException;
import org.opends.server.protocols.asn1.ASN1;
import org.opends.server.protocols.asn1.ASN1Reader;
import org.opends.server.protocols.asn1.ASN1Writer;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.common.ServerState;
import org.opends.server.replication.protocol.RoutableMsg;
import org.opends.server.types.ByteSequenceReader;
import org.opends.server.types.ByteString;
import org.opends.server.types.ByteStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MonitorMsg
extends RoutableMsg {
    SubTopoMonitorData data = new SubTopoMonitorData();

    public MonitorMsg(short sender, short destination) {
        super(sender, destination);
    }

    public void setReplServerDbState(ServerState state) {
        this.data.replServerDbState = state;
    }

    public void setServerState(short serverId, ServerState state, Long approxFirstMissingDate, boolean isLDAP) {
        if (this.data.ldapStates == null) {
            this.data.ldapStates = new HashMap();
        }
        if (this.data.rsStates == null) {
            this.data.rsStates = new HashMap();
        }
        ServerData sd = new ServerData();
        sd.state = state;
        sd.approxFirstMissingDate = approxFirstMissingDate;
        if (isLDAP) {
            this.data.ldapStates.put(serverId, sd);
        } else {
            this.data.rsStates.put(serverId, sd);
        }
    }

    public ServerState getLDAPServerState(short serverId) {
        return this.data.ldapStates.get((Object)Short.valueOf((short)serverId)).state;
    }

    public ServerState getRSServerState(short serverId) {
        return this.data.rsStates.get((Object)Short.valueOf((short)serverId)).state;
    }

    public Long getLDAPApproxFirstMissingDate(short serverId) {
        return this.data.ldapStates.get((Object)Short.valueOf((short)serverId)).approxFirstMissingDate;
    }

    public Long getRSApproxFirstMissingDate(short serverId) {
        return this.data.rsStates.get((Object)Short.valueOf((short)serverId)).approxFirstMissingDate;
    }

    public MonitorMsg(byte[] in) throws DataFormatException {
        ByteSequenceReader reader = ByteString.wrap(in).asReader();
        if (reader.get() != 19) {
            throw new DataFormatException("input is not a valid " + this.getClass().getCanonicalName());
        }
        this.senderID = reader.getShort();
        this.destination = reader.getShort();
        ASN1Reader asn1Reader = ASN1.getReader(reader);
        try {
            asn1Reader.readStartSequence();
            while (asn1Reader.hasNextElement()) {
                ServerState newState = new ServerState();
                short serverId = 0;
                Long outime = 0L;
                boolean isLDAPServer = false;
                asn1Reader.readStartSequence();
                while (asn1Reader.hasNextElement()) {
                    String s = asn1Reader.readOctetStringAsString();
                    ChangeNumber cn = new ChangeNumber(s);
                    if (this.data.replServerDbState != null && serverId == 0) {
                        serverId = cn.getServerId();
                        outime = cn.getTime();
                        isLDAPServer = cn.getSeqnum() > 0;
                        continue;
                    }
                    newState.update(cn);
                }
                asn1Reader.readEndSequence();
                if (this.data.replServerDbState == null) {
                    this.data.replServerDbState = newState;
                    continue;
                }
                ServerData sd = new ServerData();
                sd.state = newState;
                sd.approxFirstMissingDate = outime;
                if (isLDAPServer) {
                    this.data.ldapStates.put(serverId, sd);
                    continue;
                }
                this.data.rsStates.put(serverId, sd);
            }
            asn1Reader.readEndSequence();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    @Override
    public byte[] getBytes() {
        try {
            ChangeNumber cn;
            Long outime;
            ServerState statei;
            ByteStringBuilder byteBuilder = new ByteStringBuilder();
            ASN1Writer writer = ASN1.getWriter(byteBuilder);
            byteBuilder.append((byte)19);
            byteBuilder.append(this.senderID);
            byteBuilder.append(this.destination);
            writer.writeStartSequence();
            writer.writeStartSequence();
            ArrayList<ByteString> cnOctetList = this.data.replServerDbState.toASN1ArrayList();
            for (ByteString soci : cnOctetList) {
                writer.writeOctetString(soci);
            }
            writer.writeEndSequence();
            Set<Short> servers = this.data.ldapStates.keySet();
            for (Short sid : servers) {
                statei = this.data.ldapStates.get((Object)sid).state;
                outime = this.data.ldapStates.get((Object)sid).approxFirstMissingDate;
                cnOctetList = statei.toASN1ArrayList();
                writer.writeStartSequence();
                cn = new ChangeNumber(outime, 1, sid);
                writer.writeOctetString(cn.toString());
                for (ByteString soci : cnOctetList) {
                    writer.writeOctetString(soci);
                }
                writer.writeEndSequence();
            }
            servers = this.data.rsStates.keySet();
            for (Short sid : servers) {
                statei = this.data.rsStates.get((Object)sid).state;
                outime = this.data.rsStates.get((Object)sid).approxFirstMissingDate;
                cnOctetList = statei.toASN1ArrayList();
                writer.writeStartSequence();
                cn = new ChangeNumber(outime, 0, sid);
                writer.writeOctetString(cn.toString());
                for (ByteString soci : cnOctetList) {
                    writer.writeOctetString(soci);
                }
                writer.writeEndSequence();
            }
            writer.writeEndSequence();
            return byteBuilder.toByteArray();
        }
        catch (Exception e) {
            return null;
        }
    }

    public ServerState getReplServerDbState() {
        return this.data.replServerDbState;
    }

    public Iterator<Short> ldapIterator() {
        return this.data.ldapStates.keySet().iterator();
    }

    public Iterator<Short> rsIterator() {
        return this.data.rsStates.keySet().iterator();
    }

    @Override
    public String toString() {
        ServerData sd;
        String stateS = "\nRState:[";
        stateS = stateS + this.data.replServerDbState.toString();
        stateS = stateS + "]";
        stateS = stateS + "\nLDAPStates:[";
        for (Short sid : this.data.ldapStates.keySet()) {
            sd = this.data.ldapStates.get(sid);
            stateS = stateS + "\n[LSstate(" + sid + ")=" + sd.state.toString() + "]" + " afmd=" + sd.approxFirstMissingDate + "]";
        }
        stateS = stateS + "\nRSStates:[";
        for (Short sid : this.data.rsStates.keySet()) {
            sd = this.data.rsStates.get(sid);
            stateS = stateS + "\n[RSState(" + sid + ")=" + sd.state.toString() + "]" + " afmd=" + sd.approxFirstMissingDate + "]";
        }
        String me = this.getClass().getCanonicalName() + "[ sender=" + this.senderID + " destination=" + this.destination + " data=[" + stateS + "]" + "]";
        return me;
    }

    class SubTopoMonitorData {
        ServerState replServerDbState;
        HashMap<Short, ServerData> ldapStates = new HashMap();
        HashMap<Short, ServerData> rsStates = new HashMap();

        SubTopoMonitorData() {
        }
    }

    class ServerData {
        ServerState state;
        Long approxFirstMissingDate;

        ServerData() {
        }
    }
}

