/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.protocol;

import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.zip.DataFormatException;
import org.opends.server.api.ClientConnection;
import org.opends.server.core.ModifyDNOperationBasis;
import org.opends.server.protocols.asn1.ASN1;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.protocols.asn1.ASN1Reader;
import org.opends.server.protocols.internal.InternalClientConnection;
import org.opends.server.protocols.ldap.LDAPModification;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.protocol.ModifyCommonMsg;
import org.opends.server.replication.protocol.ModifyDnContext;
import org.opends.server.replication.protocol.OperationContext;
import org.opends.server.types.AbstractOperation;
import org.opends.server.types.ByteString;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.LDAPException;
import org.opends.server.types.Modification;
import org.opends.server.types.RDN;
import org.opends.server.types.operation.PostOperationModifyDNOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyDNMsg
extends ModifyCommonMsg {
    private String newRDN;
    private String newSuperior;
    private boolean deleteOldRdn;
    private String newSuperiorId;

    public ModifyDNMsg(PostOperationModifyDNOperation operation) {
        super((OperationContext)operation.getAttachment("replicationContext"), operation.getRawEntryDN().toString());
        this.encodedMods = this.modsToByte(operation.getModifications());
        ModifyDnContext ctx = (ModifyDnContext)operation.getAttachment("replicationContext");
        this.newSuperiorId = ctx.getNewParentId();
        this.deleteOldRdn = operation.deleteOldRDN();
        this.newSuperior = operation.getRawNewSuperior() != null ? operation.getRawNewSuperior().toString() : null;
        this.newRDN = operation.getRawNewRDN().toString();
    }

    public ModifyDNMsg(String dn, ChangeNumber changeNumber, String uid, String newParentUid, boolean deleteOldRdn, String newSuperior, String newRDN) {
        super(new ModifyDnContext(changeNumber, uid, newParentUid), dn);
        this.newSuperiorId = newParentUid;
        this.deleteOldRdn = deleteOldRdn;
        this.newSuperior = newSuperior;
        this.newRDN = newRDN;
    }

    public ModifyDNMsg(String dn, ChangeNumber changeNumber, String uid, String newParentUid, boolean deleteOldRdn, String newSuperior, String newRDN, List<Modification> mods) {
        this(dn, changeNumber, uid, newParentUid, deleteOldRdn, newSuperior, newRDN);
        this.encodedMods = this.modsToByte(mods);
    }

    public ModifyDNMsg(byte[] in) throws DataFormatException, UnsupportedEncodingException {
        byte[] allowedPduTypes = new byte[]{25, 4};
        int pos = this.decodeHeader(allowedPduTypes, in);
        int length = this.getNextLength(in, pos);
        this.newRDN = new String(in, pos, length, "UTF-8");
        pos += length + 1;
        length = this.getNextLength(in, pos);
        this.newSuperior = length != 0 ? new String(in, pos, length, "UTF-8") : null;
        pos += length + 1;
        length = this.getNextLength(in, pos);
        this.newSuperiorId = length != 0 ? new String(in, pos, length, "UTF-8") : null;
        this.deleteOldRdn = in[pos += length + 1] != 0;
        if (in[0] == 25 && (length = in.length - ++pos - 1) > 0) {
            this.encodedMods = new byte[length];
            try {
                System.arraycopy(in, pos, this.encodedMods, 0, length);
            }
            catch (IndexOutOfBoundsException e) {
                throw new DataFormatException(e.getMessage());
            }
            catch (ArrayStoreException e) {
                throw new DataFormatException(e.getMessage());
            }
            catch (NullPointerException e) {
                throw new DataFormatException(e.getMessage());
            }
        }
    }

    @Override
    public AbstractOperation createOperation(InternalClientConnection connection, String newDn) throws LDAPException, ASN1Exception {
        ModifyDNOperationBasis moddn = new ModifyDNOperationBasis((ClientConnection)connection, InternalClientConnection.nextOperationID(), InternalClientConnection.nextMessageID(), null, ByteString.valueOf(newDn), ByteString.valueOf(this.newRDN), this.deleteOldRdn, this.newSuperior == null ? null : ByteString.valueOf(this.newSuperior));
        ASN1Reader asn1Reader = ASN1.getReader(this.encodedMods);
        while (asn1Reader.hasNextElement()) {
            moddn.addModification(LDAPModification.decode(asn1Reader).toModification());
        }
        ModifyDnContext ctx = new ModifyDnContext(this.getChangeNumber(), this.getUniqueId(), this.newSuperiorId);
        moddn.setAttachment("replicationContext", ctx);
        return moddn;
    }

    @Override
    public byte[] getBytes() throws UnsupportedEncodingException {
        byte[] byteNewRdn = this.newRDN.getBytes("UTF-8");
        byte[] byteNewSuperior = null;
        byte[] byteNewSuperiorId = null;
        int length = byteNewRdn.length + 1 + 1;
        if (this.newSuperior != null) {
            byteNewSuperior = this.newSuperior.getBytes("UTF-8");
            length += byteNewSuperior.length + 1;
        } else {
            ++length;
        }
        if (this.newSuperiorId != null) {
            byteNewSuperiorId = this.newSuperiorId.getBytes("UTF-8");
            length += byteNewSuperiorId.length + 1;
        } else {
            ++length;
        }
        byte[] resultByteArray = this.encodeHeader((byte)25, length += this.encodedMods.length + 1);
        int pos = resultByteArray.length - length;
        pos = ModifyDNMsg.addByteArray(byteNewRdn, resultByteArray, pos);
        if (this.newSuperior != null) {
            pos = ModifyDNMsg.addByteArray(byteNewSuperior, resultByteArray, pos);
        } else {
            resultByteArray[pos++] = 0;
        }
        if (this.newSuperiorId != null) {
            pos = ModifyDNMsg.addByteArray(byteNewSuperiorId, resultByteArray, pos);
        } else {
            resultByteArray[pos++] = 0;
        }
        resultByteArray[pos++] = this.deleteOldRdn ? (byte)1 : 0;
        if (this.encodedMods.length > 0) {
            pos = resultByteArray.length - (this.encodedMods.length + 1);
            ModifyDNMsg.addByteArray(this.encodedMods, resultByteArray, pos);
        } else {
            resultByteArray[pos++] = 0;
        }
        return resultByteArray;
    }

    public String toString() {
        if (this.protocolVersion == 1) {
            return "ModifyDNMsg content: \nprotocolVersion: " + this.protocolVersion + "\ndn: " + this.dn + "\nchangeNumber: " + this.changeNumber + "\nuniqueId: " + this.uniqueId + "\nassuredFlag: " + this.assuredFlag + "\nnewRDN: " + this.newRDN + "\nnewSuperior: " + this.newSuperior + "\ndeleteOldRdn: " + this.deleteOldRdn;
        }
        if (this.protocolVersion == 2) {
            return "ModifyDNMsg content: \nprotocolVersion: " + this.protocolVersion + "\ndn: " + this.dn + "\nchangeNumber: " + this.changeNumber + "\nuniqueId: " + this.uniqueId + "\nnewRDN: " + this.newRDN + "\nnewSuperior: " + this.newSuperior + "\ndeleteOldRdn: " + this.deleteOldRdn + "\nassuredFlag: " + this.assuredFlag + "\nassuredMode: " + (Object)((Object)this.assuredMode) + "\nsafeDataLevel: " + this.safeDataLevel;
        }
        return "!!! Unknown version: " + this.protocolVersion + "!!!";
    }

    public void setNewSuperior(String string) {
        this.newSuperior = string;
    }

    public String getNewSuperior() {
        return this.newSuperior;
    }

    public String getNewSuperiorId() {
        return this.newSuperiorId;
    }

    public boolean deleteOldRdn() {
        return this.deleteOldRdn;
    }

    public void setNewSuperiorId(String newSup) {
        this.newSuperiorId = newSup;
    }

    public void setDeleteOldRdn(boolean delete) {
        this.deleteOldRdn = delete;
    }

    public String getNewRDN() {
        return this.newRDN;
    }

    public void setNewRDN(String newRDN) {
        this.newRDN = newRDN;
    }

    public boolean newDNIsParent(DN targetDn) {
        try {
            DN newDN;
            if (this.newSuperior == null) {
                DN parentDn = DN.decode(this.getDn()).getParent();
                newDN = parentDn.concat(RDN.decode(this.newRDN));
            } else {
                String newStringDN = this.newRDN + "," + this.newSuperior;
                newDN = DN.decode(newStringDN);
            }
            return newDN.isAncestorOf(targetDn);
        }
        catch (DirectoryException e) {
            return false;
        }
    }

    public boolean newDNIsEqual(DN targetDN) {
        try {
            String newStringDN = this.newRDN + "," + this.newSuperior;
            DN newDN = DN.decode(newStringDN);
            return newDN.equals(targetDN);
        }
        catch (DirectoryException e) {
            return false;
        }
    }

    public boolean newParentIsEqual(DN targetDN) {
        try {
            DN newSuperiorDN = DN.decode(this.newSuperior);
            return newSuperiorDN.equals(targetDN);
        }
        catch (DirectoryException e) {
            return false;
        }
    }

    @Override
    public int size() {
        return this.encodedMods.length + 100;
    }

    @Override
    public byte[] getBytes_V1() throws UnsupportedEncodingException {
        if (this.bytes == null) {
            byte[] byteNewRdn = this.newRDN.getBytes("UTF-8");
            byte[] byteNewSuperior = null;
            byte[] byteNewSuperiorId = null;
            int length = byteNewRdn.length + 1 + 1;
            if (this.newSuperior != null) {
                byteNewSuperior = this.newSuperior.getBytes("UTF-8");
                length += byteNewSuperior.length + 1;
            } else {
                ++length;
            }
            if (this.newSuperiorId != null) {
                byteNewSuperiorId = this.newSuperiorId.getBytes("UTF-8");
                length += byteNewSuperiorId.length + 1;
            } else {
                ++length;
            }
            byte[] resultByteArray = this.encodeHeader_V1((byte)4, length);
            int pos = resultByteArray.length - length;
            pos = ModifyDNMsg.addByteArray(byteNewRdn, resultByteArray, pos);
            if (this.newSuperior != null) {
                pos = ModifyDNMsg.addByteArray(byteNewSuperior, resultByteArray, pos);
            } else {
                resultByteArray[pos++] = 0;
            }
            if (this.newSuperiorId != null) {
                pos = ModifyDNMsg.addByteArray(byteNewSuperiorId, resultByteArray, pos);
            } else {
                resultByteArray[pos++] = 0;
            }
            resultByteArray[pos++] = this.deleteOldRdn ? (byte)1 : 0;
            return resultByteArray;
        }
        return this.bytes;
    }
}

