/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.common;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ServerStatus {
    INVALID_STATUS(-1),
    NOT_CONNECTED_STATUS(0),
    NORMAL_STATUS(1),
    DEGRADED_STATUS(2),
    FULL_UPDATE_STATUS(3),
    BAD_GEN_ID_STATUS(4);

    private byte value = (byte)-1;

    private ServerStatus(byte value) {
        this.value = value;
    }

    public static ServerStatus valueOf(byte value) throws IllegalArgumentException {
        switch (value) {
            case -1: {
                return INVALID_STATUS;
            }
            case 0: {
                return NOT_CONNECTED_STATUS;
            }
            case 1: {
                return NORMAL_STATUS;
            }
            case 2: {
                return DEGRADED_STATUS;
            }
            case 3: {
                return FULL_UPDATE_STATUS;
            }
            case 4: {
                return BAD_GEN_ID_STATUS;
            }
        }
        throw new IllegalArgumentException("Wrong status numeric value: " + value);
    }

    public byte getValue() {
        return this.value;
    }

    public String toString() {
        switch (this.value) {
            case -1: {
                return "Invalid";
            }
            case 0: {
                return "Not connected";
            }
            case 1: {
                return "Normal";
            }
            case 2: {
                return "Degraded";
            }
            case 3: {
                return "Full update";
            }
            case 4: {
                return "Bad generation id";
            }
        }
        throw new IllegalArgumentException("Wrong status numeric value: " + this.value);
    }
}

