/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.ldap;

import java.io.IOException;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1Writer;
import org.opends.server.protocols.ldap.ProtocolOp;
import org.opends.server.types.AuthenticationType;
import org.opends.server.types.ByteString;
import org.opends.server.util.ServerConstants;

public class BindRequestProtocolOp
extends ProtocolOp {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private ByteString dn;
    private ByteString saslCredentials;
    private ByteString simplePassword;
    private AuthenticationType authenticationType;
    private int protocolVersion;
    private String saslMechanism;

    public BindRequestProtocolOp(ByteString dn, int protocolVersion, ByteString simplePassword) {
        this.dn = dn;
        this.protocolVersion = protocolVersion;
        this.simplePassword = simplePassword;
        this.authenticationType = AuthenticationType.SIMPLE;
        this.saslMechanism = null;
        this.saslCredentials = null;
    }

    public BindRequestProtocolOp(ByteString dn, String saslMechanism, ByteString saslCredentials) {
        this.dn = dn;
        this.saslMechanism = saslMechanism;
        this.saslCredentials = saslCredentials;
        this.authenticationType = AuthenticationType.SASL;
        this.protocolVersion = 3;
        this.simplePassword = null;
    }

    public ByteString getDN() {
        return this.dn;
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    public AuthenticationType getAuthenticationType() {
        return this.authenticationType;
    }

    public ByteString getSimplePassword() {
        return this.simplePassword;
    }

    public String getSASLMechanism() {
        return this.saslMechanism;
    }

    public ByteString getSASLCredentials() {
        return this.saslCredentials;
    }

    public byte getType() {
        return 96;
    }

    public String getProtocolOpName() {
        return "Bind Request";
    }

    public void write(ASN1Writer stream) throws IOException {
        stream.writeStartSequence((byte)96);
        stream.writeInteger(this.protocolVersion);
        stream.writeOctetString(this.dn);
        if (this.authenticationType == AuthenticationType.SIMPLE) {
            stream.writeOctetString((byte)-128, this.simplePassword);
        } else {
            stream.writeStartSequence((byte)-93);
            stream.writeOctetString(this.saslMechanism);
            if (this.saslCredentials != null) {
                stream.writeOctetString(this.saslCredentials);
            }
            stream.writeEndSequence();
        }
        stream.writeEndSequence();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("BindRequest(version=");
        buffer.append(this.protocolVersion);
        buffer.append(", dn=");
        if (this.dn != null) {
            buffer.append(this.dn.toString());
        }
        if (this.authenticationType == AuthenticationType.SIMPLE) {
            buffer.append(", password=");
            buffer.append(this.simplePassword.toString());
        } else {
            buffer.append(", saslMechanism=");
            buffer.append(this.saslMechanism);
            if (this.saslCredentials != null) {
                buffer.append(", saslCredentials=");
                buffer.append(this.saslCredentials.toString());
            }
        }
        buffer.append(")");
    }

    public void toString(StringBuilder buffer, int indent) {
        StringBuilder indentBuf = new StringBuilder(indent);
        for (int i = 0; i < indent; ++i) {
            indentBuf.append(' ');
        }
        buffer.append((CharSequence)indentBuf);
        buffer.append("Bind Request");
        buffer.append(ServerConstants.EOL);
        buffer.append((CharSequence)indentBuf);
        buffer.append("  Protocol Version:  ");
        buffer.append(this.protocolVersion);
        buffer.append(ServerConstants.EOL);
        buffer.append((CharSequence)indentBuf);
        buffer.append("  DN:  ");
        if (this.dn != null) {
            buffer.append(this.dn.toString());
        }
        buffer.append(ServerConstants.EOL);
        if (this.authenticationType == AuthenticationType.SIMPLE) {
            buffer.append((CharSequence)indentBuf);
            buffer.append("  Simple Password:  ");
            buffer.append(String.valueOf(this.simplePassword));
            buffer.append(ServerConstants.EOL);
        } else {
            buffer.append((CharSequence)indentBuf);
            buffer.append("  SASL Mechanism:  ");
            buffer.append(this.saslMechanism);
            buffer.append(ServerConstants.EOL);
            if (this.saslCredentials != null) {
                buffer.append((CharSequence)indentBuf);
                buffer.append("  SASL Credentials:");
                buffer.append(ServerConstants.EOL);
                this.saslCredentials.toHexPlusAscii(buffer, indent + 4);
            }
        }
    }
}

