/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.asn1;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1Constants;
import org.opends.server.protocols.asn1.ASN1Writer;
import org.opends.server.protocols.asn1.ByteSequenceOutputStream;
import org.opends.server.types.ByteSequence;
import org.opends.server.types.ByteStringBuilder;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.util.StaticUtils;

final class ASN1OutputStreamWriter
implements ASN1Writer {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private final OutputStream rootStream;
    private OutputStream out;
    private final ArrayList<ByteSequenceOutputStream> streamStack;
    private int stackDepth;

    ASN1OutputStreamWriter(OutputStream stream) {
        this.out = stream;
        this.rootStream = stream;
        this.streamStack = new ArrayList();
        this.stackDepth = -1;
    }

    public ASN1Writer writeInteger(int intValue) throws IOException {
        return this.writeInteger((byte)2, intValue);
    }

    public ASN1Writer writeInteger(byte type, int intValue) throws IOException {
        this.out.write(type);
        if (intValue < 0 && (intValue & 0xFFFFFF80) == -128 || (intValue & 0x7F) == intValue) {
            this.writeLength(1);
            this.out.write((byte)(intValue & 0xFF));
            if (DebugLogger.debugEnabled()) {
                TRACER.debugProtocolElement(DebugLogLevel.VERBOSE, String.format("WRITE ASN.1 INTEGER(type=0x%x, length=%d, value=%d)", type, 1, intValue));
            }
        } else if (intValue < 0 && (intValue & Short.MIN_VALUE) == Short.MIN_VALUE || (intValue & Short.MAX_VALUE) == intValue) {
            this.writeLength(2);
            this.out.write((byte)(intValue >> 8 & 0xFF));
            this.out.write((byte)(intValue & 0xFF));
            if (DebugLogger.debugEnabled()) {
                TRACER.debugProtocolElement(DebugLogLevel.VERBOSE, String.format("WRITE ASN.1 INTEGER(type=0x%x, length=%d, value=%d)", type, 2, intValue));
            }
        } else if (intValue < 0 && (intValue & 0xFF800000) == -8388608 || (intValue & 0x7FFFFF) == intValue) {
            this.writeLength(3);
            this.out.write((byte)(intValue >> 16 & 0xFF));
            this.out.write((byte)(intValue >> 8 & 0xFF));
            this.out.write((byte)(intValue & 0xFF));
            if (DebugLogger.debugEnabled()) {
                TRACER.debugProtocolElement(DebugLogLevel.VERBOSE, String.format("WRITE ASN.1 INTEGER(type=0x%x, length=%d, value=%d)", type, 3, intValue));
            }
        } else {
            this.writeLength(4);
            this.out.write((byte)(intValue >> 24 & 0xFF));
            this.out.write((byte)(intValue >> 16 & 0xFF));
            this.out.write((byte)(intValue >> 8 & 0xFF));
            this.out.write((byte)(intValue & 0xFF));
            if (DebugLogger.debugEnabled()) {
                TRACER.debugProtocolElement(DebugLogLevel.VERBOSE, String.format("WRITE ASN.1 INTEGER(type=0x%x, length=%d, value=%d)", type, 4, intValue));
            }
        }
        return this;
    }

    public ASN1Writer writeInteger(long longValue) throws IOException {
        return this.writeInteger((byte)2, longValue);
    }

    public ASN1Writer writeInteger(byte type, long longValue) throws IOException {
        this.out.write(type);
        if (longValue < 0L && (longValue & 0xFFFFFFFFFFFFFF80L) == -128L || (longValue & 0x7FL) == longValue) {
            this.writeLength(1);
            this.out.write((byte)(longValue & 0xFFL));
            if (DebugLogger.debugEnabled()) {
                TRACER.debugProtocolElement(DebugLogLevel.VERBOSE, String.format("WRITE ASN.1 INTEGER(type=0x%x, length=%d, value=%d)", type, 1, longValue));
            }
        } else if (longValue < 0L && (longValue & 0xFFFFFFFFFFFF8000L) == -32768L || (longValue & 0x7FFFL) == longValue) {
            this.writeLength(2);
            this.out.write((byte)(longValue >> 8 & 0xFFL));
            this.out.write((byte)(longValue & 0xFFL));
            if (DebugLogger.debugEnabled()) {
                TRACER.debugProtocolElement(DebugLogLevel.VERBOSE, String.format("WRITE ASN.1 INTEGER(type=0x%x, length=%d, value=%d)", type, 2, longValue));
            }
        } else if (longValue < 0L && (longValue & 0xFFFFFFFFFF800000L) == -8388608L || (longValue & 0x7FFFFFL) == longValue) {
            this.writeLength(3);
            this.out.write((byte)(longValue >> 16 & 0xFFL));
            this.out.write((byte)(longValue >> 8 & 0xFFL));
            this.out.write((byte)(longValue & 0xFFL));
            if (DebugLogger.debugEnabled()) {
                TRACER.debugProtocolElement(DebugLogLevel.VERBOSE, String.format("WRITE ASN.1 INTEGER(type=0x%x, length=%d, value=%d)", type, 3, longValue));
            }
        } else if (longValue < 0L && (longValue & Integer.MIN_VALUE) == Integer.MIN_VALUE || (longValue & Integer.MAX_VALUE) == longValue) {
            this.writeLength(4);
            this.out.write((byte)(longValue >> 24 & 0xFFL));
            this.out.write((byte)(longValue >> 16 & 0xFFL));
            this.out.write((byte)(longValue >> 8 & 0xFFL));
            this.out.write((byte)(longValue & 0xFFL));
            if (DebugLogger.debugEnabled()) {
                TRACER.debugProtocolElement(DebugLogLevel.VERBOSE, String.format("WRITE ASN.1 INTEGER(type=0x%x, length=%d, value=%d)", type, 4, longValue));
            }
        } else if (longValue < 0L && (longValue & 0xFFFFFF8000000000L) == -549755813888L || (longValue & 0x7FFFFFFFFFL) == longValue) {
            this.writeLength(5);
            this.out.write((byte)(longValue >> 32 & 0xFFL));
            this.out.write((byte)(longValue >> 24 & 0xFFL));
            this.out.write((byte)(longValue >> 16 & 0xFFL));
            this.out.write((byte)(longValue >> 8 & 0xFFL));
            this.out.write((byte)(longValue & 0xFFL));
            if (DebugLogger.debugEnabled()) {
                TRACER.debugProtocolElement(DebugLogLevel.VERBOSE, String.format("WRITE ASN.1 INTEGER(type=0x%x, length=%d, value=%d)", type, 5, longValue));
            }
        } else if (longValue < 0L && (longValue & 0xFFFF800000000000L) == -140737488355328L || (longValue & 0x7FFFFFFFFFFFL) == longValue) {
            this.writeLength(6);
            this.out.write((byte)(longValue >> 40 & 0xFFL));
            this.out.write((byte)(longValue >> 32 & 0xFFL));
            this.out.write((byte)(longValue >> 24 & 0xFFL));
            this.out.write((byte)(longValue >> 16 & 0xFFL));
            this.out.write((byte)(longValue >> 8 & 0xFFL));
            this.out.write((byte)(longValue & 0xFFL));
            if (DebugLogger.debugEnabled()) {
                TRACER.debugProtocolElement(DebugLogLevel.VERBOSE, String.format("WRITE ASN.1 INTEGER(type=0x%x, length=%d, value=%d)", type, 6, longValue));
            }
        } else if (longValue < 0L && (longValue & 0xFF80000000000000L) == -36028797018963968L || (longValue & 0x7FFFFFFFFFFFFFL) == longValue) {
            this.writeLength(7);
            this.out.write((byte)(longValue >> 48 & 0xFFL));
            this.out.write((byte)(longValue >> 40 & 0xFFL));
            this.out.write((byte)(longValue >> 32 & 0xFFL));
            this.out.write((byte)(longValue >> 24 & 0xFFL));
            this.out.write((byte)(longValue >> 16 & 0xFFL));
            this.out.write((byte)(longValue >> 8 & 0xFFL));
            this.out.write((byte)(longValue & 0xFFL));
            if (DebugLogger.debugEnabled()) {
                TRACER.debugProtocolElement(DebugLogLevel.VERBOSE, String.format("WRITE ASN.1 INTEGER(type=0x%x, length=%d, value=%d)", type, 7, longValue));
            }
        } else {
            this.writeLength(8);
            this.out.write((byte)(longValue >> 56 & 0xFFL));
            this.out.write((byte)(longValue >> 48 & 0xFFL));
            this.out.write((byte)(longValue >> 40 & 0xFFL));
            this.out.write((byte)(longValue >> 32 & 0xFFL));
            this.out.write((byte)(longValue >> 24 & 0xFFL));
            this.out.write((byte)(longValue >> 16 & 0xFFL));
            this.out.write((byte)(longValue >> 8 & 0xFFL));
            this.out.write((byte)(longValue & 0xFFL));
            if (DebugLogger.debugEnabled()) {
                TRACER.debugProtocolElement(DebugLogLevel.VERBOSE, String.format("WRITE ASN.1 INTEGER(type=0x%x, length=%d, value=%d)", type, 8, longValue));
            }
        }
        return this;
    }

    public ASN1Writer writeEnumerated(int intValue) throws IOException {
        return this.writeInteger((byte)10, intValue);
    }

    public ASN1Writer writeBoolean(boolean booleanValue) throws IOException {
        return this.writeBoolean((byte)1, booleanValue);
    }

    public ASN1Writer writeBoolean(byte type, boolean booleanValue) throws IOException {
        this.out.write(type);
        this.writeLength(1);
        this.out.write(booleanValue ? ASN1Constants.BOOLEAN_VALUE_TRUE : ASN1Constants.BOOLEAN_VALUE_FALSE);
        if (DebugLogger.debugEnabled()) {
            TRACER.debugProtocolElement(DebugLogLevel.VERBOSE, String.format("WRITE ASN.1 BOOLEAN(type=0x%x, length=%d, value=%s)", type, 1, String.valueOf(booleanValue)));
        }
        return this;
    }

    public ASN1Writer writeNull(byte type) throws IOException {
        this.out.write(type);
        this.writeLength(0);
        if (DebugLogger.debugEnabled()) {
            TRACER.debugProtocolElement(DebugLogLevel.VERBOSE, String.format("WRITE ASN.1 NULL(type=0x%x, length=%d)", type, 0));
        }
        return this;
    }

    public ASN1Writer writeNull() throws IOException {
        return this.writeNull((byte)5);
    }

    public ASN1Writer writeOctetString(byte type, byte[] value, int offset, int length) throws IOException {
        this.out.write(type);
        this.writeLength(length);
        this.out.write(value, offset, length);
        if (DebugLogger.debugEnabled()) {
            TRACER.debugProtocolElement(DebugLogLevel.VERBOSE, String.format("WRITE ASN.1 OCTETSTRING(type=0x%x, length=%d)", type, length));
        }
        return this;
    }

    public ASN1Writer writeOctetString(byte[] value, int offset, int length) throws IOException {
        return this.writeOctetString((byte)4, value, offset, length);
    }

    public ASN1Writer writeOctetString(byte type, String value) throws IOException {
        this.out.write(type);
        if (value == null) {
            this.writeLength(0);
            return this;
        }
        byte[] bytes = StaticUtils.getBytes(value);
        this.writeLength(bytes.length);
        this.out.write(bytes);
        if (DebugLogger.debugEnabled()) {
            TRACER.debugProtocolElement(DebugLogLevel.VERBOSE, String.format("WRITE ASN.1 OCTETSTRING(type=0x%x, length=%d, value=%s)", type, bytes.length, value));
        }
        return this;
    }

    public ASN1Writer writeOctetString(String value) throws IOException {
        return this.writeOctetString((byte)4, value);
    }

    public ASN1Writer writeOctetString(byte type, ByteSequence value) throws IOException {
        this.out.write(type);
        this.writeLength(value.length());
        value.copyTo(this.out);
        if (DebugLogger.debugEnabled()) {
            TRACER.debugProtocolElement(DebugLogLevel.VERBOSE, String.format("WRITE ASN.1 OCTETSTRING(type=0x%x, length=%d)", type, value.length()));
        }
        return this;
    }

    public ASN1Writer writeOctetString(ByteSequence value) throws IOException {
        return this.writeOctetString((byte)4, value);
    }

    public ASN1Writer writeStartSet() throws IOException {
        return this.writeStartSet((byte)49);
    }

    public ASN1Writer writeStartSet(byte type) throws IOException {
        return this.writeStartSequence(type);
    }

    public ASN1Writer writeStartSequence() throws IOException {
        return this.writeStartSequence((byte)48);
    }

    public ASN1Writer writeStartSequence(byte type) throws IOException {
        this.out.write(type);
        ++this.stackDepth;
        if (this.stackDepth >= this.streamStack.size()) {
            ByteSequenceOutputStream subStream = new ByteSequenceOutputStream(new ByteStringBuilder());
            this.streamStack.add(subStream);
            this.out = subStream;
        } else {
            this.out = this.streamStack.get(this.stackDepth);
        }
        if (DebugLogger.debugEnabled()) {
            TRACER.debugProtocolElement(DebugLogLevel.VERBOSE, String.format("WRITE ASN.1 START SEQUENCE(type=0x%x)", type));
        }
        return this;
    }

    public ASN1Writer writeEndSet() throws IOException {
        return this.writeEndSequence();
    }

    public ASN1Writer writeEndSequence() throws IOException {
        OutputStream parentStream;
        if (this.stackDepth < 0) {
            throw new IOException();
        }
        ByteSequenceOutputStream childStream = this.streamStack.get(this.stackDepth);
        --this.stackDepth;
        this.out = parentStream = this.stackDepth < 0 ? this.rootStream : (OutputStream)this.streamStack.get(this.stackDepth);
        this.writeLength(childStream.length());
        childStream.writeTo(parentStream);
        if (DebugLogger.debugEnabled()) {
            TRACER.debugProtocolElement(DebugLogLevel.VERBOSE, String.format("WRITE ASN.1 END SEQUENCE(length=%d)", childStream.length()));
        }
        childStream.reset();
        return this;
    }

    public void close() throws IOException {
        while (this.stackDepth >= 0) {
            this.writeEndSequence();
        }
        this.rootStream.flush();
        this.streamStack.clear();
        this.rootStream.close();
    }

    public void flush() throws IOException {
        this.rootStream.flush();
    }

    private void writeLength(int length) throws IOException {
        if (length < 128) {
            this.out.write((byte)length);
        } else if ((length & 0xFF) == length) {
            this.out.write(-127);
            this.out.write((byte)(length & 0xFF));
        } else if ((length & 0xFFFF) == length) {
            this.out.write(-126);
            this.out.write((byte)(length >> 8 & 0xFF));
            this.out.write((byte)(length & 0xFF));
        } else if ((length & 0xFFFFFF) == length) {
            this.out.write(-125);
            this.out.write((byte)(length >> 16 & 0xFF));
            this.out.write((byte)(length >> 8 & 0xFF));
            this.out.write((byte)(length & 0xFF));
        } else {
            this.out.write(-124);
            this.out.write((byte)(length >> 24 & 0xFF));
            this.out.write((byte)(length >> 16 & 0xFF));
            this.out.write((byte)(length >> 8 & 0xFF));
            this.out.write((byte)(length & 0xFF));
        }
    }
}

