/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.asn1;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.opends.server.protocols.asn1.ASN1ByteChannelReader;
import org.opends.server.protocols.asn1.ASN1ByteChannelWriter;
import org.opends.server.protocols.asn1.ASN1ByteSequenceReader;
import org.opends.server.protocols.asn1.ASN1InputStreamReader;
import org.opends.server.protocols.asn1.ASN1OutputStreamWriter;
import org.opends.server.protocols.asn1.ASN1Reader;
import org.opends.server.protocols.asn1.ASN1Writer;
import org.opends.server.protocols.asn1.ByteSequenceOutputStream;
import org.opends.server.types.ByteSequence;
import org.opends.server.types.ByteSequenceReader;
import org.opends.server.types.ByteString;
import org.opends.server.types.ByteStringBuilder;

public final class ASN1 {
    public static ASN1Reader getReader(byte[] array) {
        return ASN1.getReader(array, 0);
    }

    public static ASN1Reader getReader(byte[] array, int maxElementSize) {
        return ASN1.getReader(ByteString.wrap(array), maxElementSize);
    }

    public static ASN1Reader getReader(ByteSequence sequence) {
        return ASN1.getReader(sequence, 0);
    }

    public static ASN1Reader getReader(ByteSequence sequence, int maxElementSize) {
        return new ASN1ByteSequenceReader(sequence.asReader(), maxElementSize);
    }

    public static ASN1Reader getReader(ByteSequenceReader reader) {
        return ASN1.getReader(reader, 0);
    }

    public static ASN1Reader getReader(ByteSequenceReader reader, int maxElementSize) {
        return new ASN1ByteSequenceReader(reader, maxElementSize);
    }

    public static ASN1Reader getReader(InputStream stream) {
        return ASN1.getReader(stream, 0);
    }

    public static ASN1Reader getReader(InputStream stream, int maxElementSize) {
        return new ASN1InputStreamReader(stream, maxElementSize);
    }

    public static ASN1ByteChannelReader getReader(ReadableByteChannel channel) {
        return ASN1.getReader(channel, 4096, 0);
    }

    public static ASN1ByteChannelReader getReader(ReadableByteChannel channel, int bufferSize, int maxElementSize) {
        return new ASN1ByteChannelReader(channel, bufferSize, maxElementSize);
    }

    public static ASN1Writer getWriter(ByteStringBuilder builder) {
        ByteSequenceOutputStream outputStream = new ByteSequenceOutputStream(builder);
        return ASN1.getWriter(outputStream);
    }

    public static ASN1Writer getWriter(OutputStream stream) {
        return new ASN1OutputStreamWriter(stream);
    }

    public static ASN1Writer getWriter(WritableByteChannel channel) {
        return new ASN1ByteChannelWriter(channel, 4096);
    }

    public static ASN1Writer getWriter(WritableByteChannel channel, int bufferSize) {
        return new ASN1ByteChannelWriter(channel, bufferSize);
    }

    private ASN1() {
    }
}

