/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.monitors;

import org.opends.server.api.MonitorProvider;
import org.opends.server.monitors.CounterMonitor;
import org.opends.server.protocols.ldap.LDAPStatistics;
import org.opends.server.types.OperationType;

public class OperationMonitor {
    public static long UNDEFINED_VALUE = 0L;
    private Object lock = new Object();
    private OperationType opType;
    private long creationTime;
    private long eTime = UNDEFINED_VALUE;
    private long startTime = UNDEFINED_VALUE;
    private long stopTime = UNDEFINED_VALUE;
    private long totalTime = UNDEFINED_VALUE;
    private long minTime = UNDEFINED_VALUE;
    private long maxTime = UNDEFINED_VALUE;
    private CounterMonitor counter;

    private OperationMonitor(OperationMonitor opMonitor) {
        this.opType = opMonitor.getType();
        this.eTime = opMonitor.getTime();
        this.startTime = opMonitor.getStartTime();
        this.stopTime = opMonitor.getStopTime();
        this.totalTime = opMonitor.getTotalTime();
        this.maxTime = opMonitor.getMaxTime();
        this.minTime = opMonitor.getMinTime();
        this.counter = opMonitor.getCounter().duplicate();
    }

    private OperationMonitor(OperationType opType) {
        this.opType = opType;
        this.counter = CounterMonitor.getCounter();
        this.creationTime = System.nanoTime();
    }

    public static OperationMonitor getOperationMonitor(OperationType opType) {
        return new OperationMonitor(opType);
    }

    public OperationMonitor duplicate() {
        return new OperationMonitor(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(OperationMonitor opMonitor) {
        Object object = this.lock;
        synchronized (object) {
            this.counter.add(opMonitor.getCounter());
            this.totalTime += opMonitor.getTotalTime();
            if (this.minTime == UNDEFINED_VALUE || this.minTime > opMonitor.getMinTime()) {
                this.minTime = opMonitor.getMinTime();
            }
            if (this.maxTime < opMonitor.getMaxTime()) {
                this.maxTime = opMonitor.getMaxTime();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.lock;
        synchronized (object) {
            this.counter.increment();
            this.startTime = System.nanoTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            this.stopTime = System.nanoTime();
            this.eTime = this.stopTime - this.startTime;
            this.totalTime += this.eTime;
            if (this.minTime == UNDEFINED_VALUE || this.eTime < this.minTime) {
                this.minTime = this.eTime;
            }
            if (this.eTime > this.maxTime) {
                this.maxTime = this.eTime;
            }
        }
    }

    public long getTime() {
        return this.eTime;
    }

    public long getMinTime() {
        return this.minTime;
    }

    public long getMaxTime() {
        return this.maxTime;
    }

    public long getTotalTime() {
        return this.totalTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getStopTime() {
        return this.stopTime;
    }

    public CounterMonitor getCounter() {
        return this.counter;
    }

    public OperationType getType() {
        return this.opType;
    }

    public void reset() {
        this.counter.reset();
        this.totalTime = UNDEFINED_VALUE;
        this.minTime = UNDEFINED_VALUE;
        this.maxTime = UNDEFINED_VALUE;
    }

    public void updateMonitorProvider(MonitorProvider provider) {
        provider.updateMonitorData();
    }

    public void updateMonitorProvider(LDAPStatistics stats) {
        stats.updateMonitor(this);
    }
}

