/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.loggers.debug;

import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import java.nio.ByteBuffer;
import java.util.Map;
import org.opends.server.api.DebugLogPublisher;
import org.opends.server.loggers.LogCategory;
import org.opends.server.loggers.LogLevel;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugStackTraceFormatter;
import org.opends.server.loggers.debug.TraceSettings;
import org.opends.server.types.DebugLogCategory;
import org.opends.server.types.DebugLogLevel;

public class DebugTracer {
    private String className;
    PublisherSettings[] publisherSettings;

    DebugTracer(DebugLogPublisher[] publishers) {
        StackTraceElement callerFrame = this.getCallerFrame(Thread.currentThread().getStackTrace());
        if (callerFrame != null) {
            this.className = callerFrame.getClassName();
        }
        this.publisherSettings = new PublisherSettings[publishers.length];
        for (int i = 0; i < publishers.length; ++i) {
            DebugLogPublisher publisher = publishers[i];
            PublisherSettings settings = new PublisherSettings();
            settings.debugPublisher = publisher;
            settings.classSettings = publisher.getClassSettings(this.className);
            settings.methodSettings = publisher.getMethodSettings(this.className);
            this.publisherSettings[i] = settings;
        }
    }

    public void debugConstructor(LogLevel level, Object ... args) {
        if (DebugLogger.debugEnabled()) {
            StackTraceElement[] stackTrace = null;
            StackTraceElement[] filteredStackTrace = null;
            StackTraceElement callerFrame = null;
            for (PublisherSettings settings : this.publisherSettings) {
                TraceSettings activeSettings = settings.classSettings;
                Map<String, TraceSettings> methodSettings = settings.methodSettings;
                if (!this.shouldLog(level, DebugLogCategory.CONSTRUCTOR, activeSettings) && methodSettings == null) continue;
                if (stackTrace == null) {
                    stackTrace = Thread.currentThread().getStackTrace();
                }
                if (callerFrame == null) {
                    callerFrame = this.getCallerFrame(stackTrace);
                }
                String signature = callerFrame.getMethodName();
                if (methodSettings != null) {
                    int idx;
                    TraceSettings mSettings = methodSettings.get(signature);
                    if (mSettings == null && (idx = signature.indexOf(40)) != -1) {
                        mSettings = methodSettings.get(signature.substring(0, idx));
                    }
                    if (mSettings != null) {
                        if (!this.shouldLog(level, DebugLogCategory.CONSTRUCTOR, mSettings)) continue;
                        activeSettings = mSettings;
                    }
                }
                String sl = callerFrame.getFileName() + ":" + callerFrame.getLineNumber();
                if (activeSettings.noArgs) {
                    args = null;
                }
                if (filteredStackTrace == null && activeSettings.stackDepth > 0) {
                    filteredStackTrace = DebugStackTraceFormatter.SMART_FRAME_FILTER.getFilteredStackTrace(stackTrace);
                }
                settings.debugPublisher.traceConstructor(level, activeSettings, signature, sl, args, filteredStackTrace);
            }
        }
    }

    public void debugMethodEntry(LogLevel level, Object obj, Object ... args) {
        if (DebugLogger.debugEnabled()) {
            StackTraceElement[] stackTrace = null;
            StackTraceElement[] filteredStackTrace = null;
            StackTraceElement callerFrame = null;
            for (PublisherSettings settings : this.publisherSettings) {
                TraceSettings activeSettings = settings.classSettings;
                Map<String, TraceSettings> methodSettings = settings.methodSettings;
                if (!this.shouldLog(level, DebugLogCategory.ENTER, activeSettings) && methodSettings == null) continue;
                if (stackTrace == null) {
                    stackTrace = Thread.currentThread().getStackTrace();
                }
                if (callerFrame == null) {
                    callerFrame = this.getCallerFrame(stackTrace);
                }
                String signature = callerFrame.getMethodName();
                if (methodSettings != null) {
                    int idx;
                    TraceSettings mSettings = methodSettings.get(signature);
                    if (mSettings == null && (idx = signature.indexOf(40)) != -1) {
                        mSettings = methodSettings.get(signature.substring(0, idx));
                    }
                    if (mSettings != null) {
                        if (!this.shouldLog(level, DebugLogCategory.ENTER, mSettings)) continue;
                        activeSettings = mSettings;
                    }
                }
                String sl = callerFrame.getFileName() + ":" + callerFrame.getLineNumber();
                if (activeSettings.noArgs) {
                    args = null;
                }
                if (filteredStackTrace == null && activeSettings.stackDepth > 0) {
                    filteredStackTrace = DebugStackTraceFormatter.SMART_FRAME_FILTER.getFilteredStackTrace(stackTrace);
                }
                settings.debugPublisher.traceMethodEntry(level, activeSettings, signature, sl, obj, args, filteredStackTrace);
            }
        }
    }

    public void debugStaticMethodEntry(LogLevel level, Object ... args) {
        if (DebugLogger.debugEnabled()) {
            StackTraceElement[] stackTrace = null;
            StackTraceElement[] filteredStackTrace = null;
            StackTraceElement callerFrame = null;
            for (PublisherSettings settings : this.publisherSettings) {
                TraceSettings activeSettings = settings.classSettings;
                Map<String, TraceSettings> methodSettings = settings.methodSettings;
                if (!this.shouldLog(level, DebugLogCategory.ENTER, activeSettings) && methodSettings == null) continue;
                if (stackTrace == null) {
                    stackTrace = Thread.currentThread().getStackTrace();
                }
                if (callerFrame == null) {
                    callerFrame = this.getCallerFrame(stackTrace);
                }
                String signature = callerFrame.getMethodName();
                if (methodSettings != null) {
                    int idx;
                    TraceSettings mSettings = methodSettings.get(signature);
                    if (mSettings == null && (idx = signature.indexOf(40)) != -1) {
                        mSettings = methodSettings.get(signature.substring(0, idx));
                    }
                    if (mSettings != null) {
                        if (!this.shouldLog(level, DebugLogCategory.ENTER, mSettings)) continue;
                        activeSettings = mSettings;
                    }
                }
                String sl = callerFrame.getFileName() + ":" + callerFrame.getLineNumber();
                if (activeSettings.noArgs) {
                    args = null;
                }
                if (filteredStackTrace == null && activeSettings.stackDepth > 0) {
                    filteredStackTrace = DebugStackTraceFormatter.SMART_FRAME_FILTER.getFilteredStackTrace(stackTrace);
                }
                settings.debugPublisher.traceStaticMethodEntry(level, activeSettings, signature, sl, args, filteredStackTrace);
            }
        }
    }

    public void debugReturn(LogLevel level, Object ret) {
        if (DebugLogger.debugEnabled()) {
            StackTraceElement[] stackTrace = null;
            StackTraceElement[] filteredStackTrace = null;
            StackTraceElement callerFrame = null;
            for (PublisherSettings settings : this.publisherSettings) {
                TraceSettings activeSettings = settings.classSettings;
                Map<String, TraceSettings> methodSettings = settings.methodSettings;
                if (!this.shouldLog(level, DebugLogCategory.ENTER, activeSettings) && methodSettings == null) continue;
                if (stackTrace == null) {
                    stackTrace = Thread.currentThread().getStackTrace();
                }
                if (callerFrame == null) {
                    callerFrame = this.getCallerFrame(stackTrace);
                }
                String signature = callerFrame.getMethodName();
                if (methodSettings != null) {
                    int idx;
                    TraceSettings mSettings = methodSettings.get(signature);
                    if (mSettings == null && (idx = signature.indexOf(40)) != -1) {
                        mSettings = methodSettings.get(signature.substring(0, idx));
                    }
                    if (mSettings != null) {
                        if (!this.shouldLog(level, DebugLogCategory.ENTER, mSettings)) continue;
                        activeSettings = mSettings;
                    }
                }
                String sl = callerFrame.getFileName() + ":" + callerFrame.getLineNumber();
                if (activeSettings.noRetVal) {
                    ret = null;
                }
                if (filteredStackTrace == null && activeSettings.stackDepth > 0) {
                    filteredStackTrace = DebugStackTraceFormatter.SMART_FRAME_FILTER.getFilteredStackTrace(stackTrace);
                }
                settings.debugPublisher.traceReturn(level, activeSettings, signature, sl, ret, filteredStackTrace);
            }
        }
    }

    public void debugThrown(LogLevel level, Throwable ex) {
        if (DebugLogger.debugEnabled()) {
            StackTraceElement[] stackTrace = null;
            StackTraceElement[] filteredStackTrace = null;
            StackTraceElement callerFrame = null;
            for (PublisherSettings settings : this.publisherSettings) {
                TraceSettings activeSettings = settings.classSettings;
                Map<String, TraceSettings> methodSettings = settings.methodSettings;
                if (!this.shouldLog(level, DebugLogCategory.THROWN, activeSettings) && methodSettings == null) continue;
                if (stackTrace == null) {
                    stackTrace = Thread.currentThread().getStackTrace();
                }
                if (callerFrame == null) {
                    callerFrame = this.getCallerFrame(stackTrace);
                }
                String signature = callerFrame.getMethodName();
                if (methodSettings != null) {
                    int idx;
                    TraceSettings mSettings = methodSettings.get(signature);
                    if (mSettings == null && (idx = signature.indexOf(40)) != -1) {
                        mSettings = methodSettings.get(signature.substring(0, idx));
                    }
                    if (mSettings != null) {
                        if (!this.shouldLog(level, DebugLogCategory.THROWN, mSettings)) continue;
                        activeSettings = mSettings;
                    }
                }
                String sl = callerFrame.getFileName() + ":" + callerFrame.getLineNumber();
                if (filteredStackTrace == null && activeSettings.stackDepth > 0) {
                    filteredStackTrace = DebugStackTraceFormatter.SMART_FRAME_FILTER.getFilteredStackTrace(ex.getStackTrace());
                }
                settings.debugPublisher.traceThrown(level, activeSettings, signature, sl, ex, filteredStackTrace);
            }
        }
    }

    public void debugVerbose(String msg) {
        this.debugMessage(DebugLogLevel.VERBOSE, msg, new Object[0]);
    }

    public void debugVerbose(String msg, Object ... msgArgs) {
        this.debugMessage(DebugLogLevel.VERBOSE, msg, msgArgs);
    }

    public void debugInfo(String msg) {
        this.debugMessage(DebugLogLevel.INFO, msg, new Object[0]);
    }

    public void debugInfo(String msg, Object ... msgArgs) {
        this.debugMessage(DebugLogLevel.INFO, msg, msgArgs);
    }

    public void debugWarning(String msg) {
        this.debugMessage(DebugLogLevel.WARNING, msg, new Object[0]);
    }

    public void debugWarning(String msg, Object ... msgArgs) {
        this.debugMessage(DebugLogLevel.WARNING, msg, msgArgs);
    }

    public void debugError(String msg) {
        this.debugMessage(DebugLogLevel.ERROR, msg, new Object[0]);
    }

    public void debugError(String msg, Object ... msgArgs) {
        this.debugMessage(DebugLogLevel.ERROR, msg, msgArgs);
    }

    public void debugMessage(LogLevel level, String msg) {
        this.debugMessage(level, msg, new Object[0]);
    }

    public void debugMessage(LogLevel level, String msg, Object ... msgArgs) {
        if (DebugLogger.debugEnabled()) {
            StackTraceElement[] stackTrace = null;
            StackTraceElement[] filteredStackTrace = null;
            StackTraceElement callerFrame = null;
            for (PublisherSettings settings : this.publisherSettings) {
                TraceSettings activeSettings = settings.classSettings;
                Map<String, TraceSettings> methodSettings = settings.methodSettings;
                if (!this.shouldLog(level, DebugLogCategory.MESSAGE, activeSettings) && methodSettings == null) continue;
                if (stackTrace == null) {
                    stackTrace = Thread.currentThread().getStackTrace();
                }
                if (callerFrame == null) {
                    callerFrame = this.getCallerFrame(stackTrace);
                }
                String signature = callerFrame.getMethodName();
                if (methodSettings != null) {
                    int idx;
                    TraceSettings mSettings = methodSettings.get(signature);
                    if (mSettings == null && (idx = signature.indexOf(40)) != -1) {
                        mSettings = methodSettings.get(signature.substring(0, idx));
                    }
                    if (mSettings != null) {
                        if (!this.shouldLog(level, DebugLogCategory.MESSAGE, mSettings)) continue;
                        activeSettings = mSettings;
                    }
                }
                String sl = callerFrame.getFileName() + ":" + callerFrame.getLineNumber();
                if (msgArgs != null && msgArgs.length > 0) {
                    msg = String.format(msg, msgArgs);
                }
                if (filteredStackTrace == null && activeSettings.stackDepth > 0) {
                    filteredStackTrace = DebugStackTraceFormatter.SMART_FRAME_FILTER.getFilteredStackTrace(stackTrace);
                }
                settings.debugPublisher.traceMessage(level, activeSettings, signature, sl, msg, filteredStackTrace);
            }
        }
    }

    public void debugCaught(LogLevel level, Throwable ex) {
        if (DebugLogger.debugEnabled()) {
            StackTraceElement[] stackTrace = null;
            StackTraceElement[] filteredStackTrace = null;
            StackTraceElement callerFrame = null;
            for (PublisherSettings settings : this.publisherSettings) {
                TraceSettings activeSettings = settings.classSettings;
                Map<String, TraceSettings> methodSettings = settings.methodSettings;
                if (!this.shouldLog(level, DebugLogCategory.CAUGHT, activeSettings) && methodSettings == null) continue;
                if (stackTrace == null) {
                    stackTrace = Thread.currentThread().getStackTrace();
                }
                if (callerFrame == null) {
                    callerFrame = this.getCallerFrame(stackTrace);
                }
                String signature = callerFrame.getMethodName();
                if (methodSettings != null) {
                    int idx;
                    TraceSettings mSettings = methodSettings.get(signature);
                    if (mSettings == null && (idx = signature.indexOf(40)) != -1) {
                        mSettings = methodSettings.get(signature.substring(0, idx));
                    }
                    if (mSettings != null) {
                        if (!this.shouldLog(level, DebugLogCategory.CAUGHT, mSettings)) continue;
                        activeSettings = mSettings;
                    }
                }
                String sl = callerFrame.getFileName() + ":" + callerFrame.getLineNumber();
                if (filteredStackTrace == null && activeSettings.stackDepth > 0) {
                    filteredStackTrace = DebugStackTraceFormatter.SMART_FRAME_FILTER.getFilteredStackTrace(ex.getStackTrace());
                }
                settings.debugPublisher.traceCaught(level, activeSettings, signature, sl, ex, filteredStackTrace);
            }
        }
    }

    public void debugJEAccess(LogLevel level, OperationStatus status, Database database, Transaction txn, DatabaseEntry key, DatabaseEntry data) {
        if (DebugLogger.debugEnabled()) {
            StackTraceElement[] stackTrace = null;
            StackTraceElement[] filteredStackTrace = null;
            StackTraceElement callerFrame = null;
            for (PublisherSettings settings : this.publisherSettings) {
                TraceSettings activeSettings = settings.classSettings;
                Map<String, TraceSettings> methodSettings = settings.methodSettings;
                if (!this.shouldLog(level, DebugLogCategory.DATABASE_ACCESS, activeSettings) && methodSettings == null) continue;
                if (stackTrace == null) {
                    stackTrace = Thread.currentThread().getStackTrace();
                }
                if (callerFrame == null) {
                    callerFrame = this.getCallerFrame(stackTrace);
                }
                String signature = callerFrame.getMethodName();
                if (methodSettings != null) {
                    int idx;
                    TraceSettings mSettings = methodSettings.get(signature);
                    if (mSettings == null && (idx = signature.indexOf(40)) != -1) {
                        mSettings = methodSettings.get(signature.substring(0, idx));
                    }
                    if (mSettings != null) {
                        if (!this.shouldLog(level, DebugLogCategory.DATABASE_ACCESS, mSettings)) continue;
                        activeSettings = mSettings;
                    }
                }
                String sl = callerFrame.getFileName() + ":" + callerFrame.getLineNumber();
                if (filteredStackTrace == null && activeSettings.stackDepth > 0) {
                    filteredStackTrace = DebugStackTraceFormatter.SMART_FRAME_FILTER.getFilteredStackTrace(stackTrace);
                }
                settings.debugPublisher.traceJEAccess(level, activeSettings, signature, sl, status, database, txn, key, data, filteredStackTrace);
            }
        }
    }

    public void debugData(LogLevel level, byte[] data) {
        if (DebugLogger.debugEnabled() && data != null) {
            StackTraceElement[] stackTrace = null;
            StackTraceElement[] filteredStackTrace = null;
            StackTraceElement callerFrame = null;
            for (PublisherSettings settings : this.publisherSettings) {
                TraceSettings activeSettings = settings.classSettings;
                Map<String, TraceSettings> methodSettings = settings.methodSettings;
                if (!this.shouldLog(level, DebugLogCategory.DATA, activeSettings) && methodSettings == null) continue;
                if (stackTrace == null) {
                    stackTrace = Thread.currentThread().getStackTrace();
                }
                if (callerFrame == null) {
                    callerFrame = this.getCallerFrame(stackTrace);
                }
                String signature = callerFrame.getMethodName();
                if (methodSettings != null) {
                    int idx;
                    TraceSettings mSettings = methodSettings.get(signature);
                    if (mSettings == null && (idx = signature.indexOf(40)) != -1) {
                        mSettings = methodSettings.get(signature.substring(0, idx));
                    }
                    if (mSettings != null) {
                        if (!this.shouldLog(level, DebugLogCategory.DATA, mSettings)) continue;
                        activeSettings = mSettings;
                    }
                }
                String sl = callerFrame.getFileName() + ":" + callerFrame.getLineNumber();
                if (filteredStackTrace == null && activeSettings.stackDepth > 0) {
                    filteredStackTrace = DebugStackTraceFormatter.SMART_FRAME_FILTER.getFilteredStackTrace(stackTrace);
                }
                settings.debugPublisher.traceData(level, activeSettings, signature, sl, data, filteredStackTrace);
            }
        }
    }

    public void debugProtocolElement(LogLevel level, String elementStr) {
        if (DebugLogger.debugEnabled() && elementStr != null) {
            StackTraceElement[] stackTrace = null;
            StackTraceElement[] filteredStackTrace = null;
            StackTraceElement callerFrame = null;
            for (PublisherSettings settings : this.publisherSettings) {
                TraceSettings activeSettings = settings.classSettings;
                Map<String, TraceSettings> methodSettings = settings.methodSettings;
                if (!this.shouldLog(level, DebugLogCategory.PROTOCOL, activeSettings) && methodSettings == null) continue;
                if (stackTrace == null) {
                    stackTrace = Thread.currentThread().getStackTrace();
                }
                if (callerFrame == null) {
                    callerFrame = this.getCallerFrame(stackTrace);
                }
                String signature = callerFrame.getMethodName();
                if (methodSettings != null) {
                    int idx;
                    TraceSettings mSettings = methodSettings.get(signature);
                    if (mSettings == null && (idx = signature.indexOf(40)) != -1) {
                        mSettings = methodSettings.get(signature.substring(0, idx));
                    }
                    if (mSettings != null) {
                        if (!this.shouldLog(level, DebugLogCategory.PROTOCOL, mSettings)) continue;
                        activeSettings = mSettings;
                    }
                }
                String sl = callerFrame.getFileName() + ":" + callerFrame.getLineNumber();
                if (filteredStackTrace == null && activeSettings.stackDepth > 0) {
                    filteredStackTrace = DebugStackTraceFormatter.SMART_FRAME_FILTER.getFilteredStackTrace(stackTrace);
                }
                settings.debugPublisher.traceProtocolElement(level, activeSettings, signature, sl, elementStr, filteredStackTrace);
            }
        }
    }

    public void debugData(LogLevel level, ByteBuffer buffer) {
        this.debugData(level, buffer.array());
    }

    public String getTracedClassName() {
        return this.className;
    }

    void updateSettings(DebugLogPublisher[] publishers) {
        PublisherSettings[] newSettings = new PublisherSettings[publishers.length];
        for (int i = 0; i < publishers.length; ++i) {
            DebugLogPublisher publisher = publishers[i];
            PublisherSettings settings = new PublisherSettings();
            settings.debugPublisher = publisher;
            settings.classSettings = publisher.getClassSettings(this.className);
            settings.methodSettings = publisher.getMethodSettings(this.className);
            newSettings[i] = settings;
        }
        this.publisherSettings = newSettings;
    }

    private StackTraceElement getCallerFrame(StackTraceElement[] stackTrace) {
        if (stackTrace != null && stackTrace.length > 0) {
            for (int i = 0; i < stackTrace.length; ++i) {
                StackTraceElement aStackTrace = stackTrace[i];
                if (aStackTrace.getClassName().startsWith("java.lang.Thread") || aStackTrace.getClassName().startsWith("org.opends.server.loggers.debug")) continue;
                return aStackTrace;
            }
        }
        return null;
    }

    private boolean shouldLog(LogLevel messageLevel, LogCategory messageCategory, TraceSettings activeSettings) {
        return (activeSettings.includeCategories == null || activeSettings.includeCategories.contains(messageCategory)) && messageLevel.intValue() >= activeSettings.level.intValue();
    }

    private class PublisherSettings {
        DebugLogPublisher debugPublisher;
        TraceSettings classSettings;
        Map<String, TraceSettings> methodSettings;

        private PublisherSettings() {
        }
    }
}

