/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.loggers;

import java.io.File;
import java.io.FilenameFilter;
import org.opends.server.loggers.FileNamingPolicy;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.util.TimeThread;

public class TimeStampNaming
implements FileNamingPolicy {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private File file;
    private TimeStampNamingFilter filter;

    public TimeStampNaming(File file) {
        this.file = file;
        this.filter = new TimeStampNamingFilter();
    }

    public File getInitialName() {
        return this.file;
    }

    public File getNextName() {
        return new File(this.file + "." + TimeThread.getGMTTime());
    }

    public FilenameFilter getFilenameFilter() {
        return this.filter;
    }

    public File[] listFiles() {
        File directory = this.file.getParentFile();
        File[] files = directory.listFiles(this.filter);
        if (files == null) {
            TRACER.debugError("Unable to list files named by policy with initial file %s in directory %s", this.file, directory);
        }
        return files;
    }

    private class TimeStampNamingFilter
    implements FilenameFilter {
        private TimeStampNamingFilter() {
        }

        public boolean accept(File dir, String name) {
            int pos;
            if (new File(dir, name).isDirectory()) {
                return false;
            }
            String initialFileName = TimeStampNaming.this.file.getName();
            if (name.length() != initialFileName.length() + 16) {
                return false;
            }
            for (pos = 0; pos < initialFileName.length(); ++pos) {
                if (name.charAt(pos) == initialFileName.charAt(pos)) continue;
                return false;
            }
            if (name.charAt(pos) != '.') {
                return false;
            }
            ++pos;
            while (pos < name.length() - 1) {
                char c = name.charAt(pos);
                if (c < '0' || c > '9') {
                    return false;
                }
                ++pos;
            }
            return name.charAt(pos) == 'Z';
        }
    }
}

