/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.util.Random;
import org.opends.messages.ExtensionMessages;
import org.opends.messages.Message;
import org.opends.server.admin.std.server.CryptPasswordStorageSchemeCfg;
import org.opends.server.api.PasswordStorageScheme;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.types.ByteSequence;
import org.opends.server.types.ByteString;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.Crypt;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CryptPasswordStorageScheme
extends PasswordStorageScheme<CryptPasswordStorageSchemeCfg> {
    private static final String CLASS_NAME = "org.opends.server.extensions.CryptPasswordStorageScheme";
    private static final byte[] SALT_CHARS = "./0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".getBytes();
    private final Random randomSaltIndex = new Random();
    private final Object saltLock = new Object();
    private final Crypt crypt = new Crypt();

    @Override
    public void initializePasswordStorageScheme(CryptPasswordStorageSchemeCfg configuration) throws ConfigException, InitializationException {
    }

    @Override
    public String getStorageSchemeName() {
        return "CRYPT";
    }

    @Override
    public ByteString encodePassword(ByteSequence plaintext) throws DirectoryException {
        byte[] digestBytes;
        try {
            byte[] plaintextBytes = plaintext.toByteArray();
            digestBytes = this.crypt.crypt(plaintextBytes, this.randomSalt());
        }
        catch (Exception e) {
            Message message = ExtensionMessages.ERR_PWSCHEME_CANNOT_ENCODE_PASSWORD.get(CLASS_NAME, StaticUtils.stackTraceToSingleLineString(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
        }
        return ByteString.wrap(digestBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] randomSalt() {
        Object object = this.saltLock;
        synchronized (object) {
            byte[] salt = new byte[2];
            int sb1 = this.randomSaltIndex.nextInt(SALT_CHARS.length);
            int sb2 = this.randomSaltIndex.nextInt(SALT_CHARS.length);
            salt[0] = SALT_CHARS[sb1];
            salt[1] = SALT_CHARS[sb2];
            return salt;
        }
    }

    @Override
    public ByteString encodePasswordWithScheme(ByteSequence plaintext) throws DirectoryException {
        StringBuilder buffer = new StringBuilder("CRYPT".length() + 12);
        buffer.append('{');
        buffer.append("CRYPT");
        buffer.append('}');
        buffer.append(this.encodePassword(plaintext));
        return ByteString.valueOf(buffer.toString());
    }

    @Override
    public boolean passwordMatches(ByteSequence plaintextPassword, ByteSequence storedPassword) {
        ByteString userPWDigestBytes;
        byte[] plaintextPasswordBytes = plaintextPassword.toByteArray();
        try {
            byte[] salt = storedPassword.copyTo(new byte[2]);
            userPWDigestBytes = ByteString.wrap(this.crypt.crypt(plaintextPasswordBytes, salt));
        }
        catch (Exception e) {
            return false;
        }
        return userPWDigestBytes.equals(storedPassword);
    }

    @Override
    public boolean supportsAuthPasswordSyntax() {
        return false;
    }

    @Override
    public ByteString encodeAuthPassword(ByteSequence plaintext) throws DirectoryException {
        Message message = ExtensionMessages.ERR_PWSCHEME_DOES_NOT_SUPPORT_AUTH_PASSWORD.get(this.getStorageSchemeName());
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
    }

    @Override
    public boolean authPasswordMatches(ByteSequence plaintextPassword, String authInfo, String authValue) {
        return false;
    }

    @Override
    public boolean isReversible() {
        return false;
    }

    @Override
    public ByteString getPlaintextValue(ByteSequence storedPassword) throws DirectoryException {
        Message message = ExtensionMessages.ERR_PWSCHEME_NOT_REVERSIBLE.get("CRYPT");
        throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
    }

    @Override
    public ByteString getAuthPasswordPlaintextValue(String authInfo, String authValue) throws DirectoryException {
        Message message = ExtensionMessages.ERR_PWSCHEME_DOES_NOT_SUPPORT_AUTH_PASSWORD.get(this.getStorageSchemeName());
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
    }

    @Override
    public boolean isStorageSchemeSecure() {
        return false;
    }
}

