/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.util.InputMismatchException;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.opends.server.api.SubtreeSpecification;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SimpleSubtreeSpecification
extends SubtreeSpecification {
    private DN baseDN;
    private int minimumDepth;
    private int maximumDepth;
    private TreeMap<DN, DN> chopBefore;
    private TreeMap<DN, DN> chopAfter;

    protected SimpleSubtreeSpecification(DN baseDN, int minimumDepth, int maximumDepth, Iterable<DN> chopBefore, Iterable<DN> chopAfter) {
        this.baseDN = baseDN;
        this.minimumDepth = minimumDepth;
        this.maximumDepth = maximumDepth;
        if (chopBefore != null && chopBefore.iterator().hasNext()) {
            this.chopBefore = new TreeMap();
            for (DN localName : chopBefore) {
                this.chopBefore.put(baseDN.concat(localName), localName);
            }
        } else {
            this.chopBefore = null;
        }
        if (chopAfter != null && chopAfter.iterator().hasNext()) {
            this.chopAfter = new TreeMap();
            for (DN localName : chopAfter) {
                this.chopAfter.put(baseDN.concat(localName), localName);
            }
        } else {
            this.chopAfter = null;
        }
    }

    protected final boolean isDNWithinScope(DN dn) {
        int entryRDNCount;
        if (!dn.isDescendantOf(this.baseDN)) {
            return false;
        }
        int baseRDNCount = this.baseDN.getNumComponents();
        if (this.minimumDepth > 0 && (entryRDNCount = dn.getNumComponents()) - baseRDNCount < this.minimumDepth) {
            return false;
        }
        if (this.maximumDepth >= 0 && (entryRDNCount = dn.getNumComponents()) - baseRDNCount > this.maximumDepth) {
            return false;
        }
        if (this.chopBefore != null) {
            for (DN chopBeforeDN : this.chopBefore.keySet()) {
                if (!dn.isDescendantOf(chopBeforeDN)) continue;
                return false;
            }
        }
        if (this.chopAfter != null) {
            for (DN chopAfterDN : this.chopAfter.keySet()) {
                if (dn.equals(chopAfterDN) || !dn.isDescendantOf(chopAfterDN)) continue;
                return false;
            }
        }
        return true;
    }

    protected final DN getBaseDN() {
        return this.baseDN;
    }

    protected final boolean commonComponentsEquals(SimpleSubtreeSpecification other) {
        if (this == other) {
            return true;
        }
        if (this.minimumDepth != other.minimumDepth) {
            return false;
        }
        if (this.maximumDepth != other.maximumDepth) {
            return false;
        }
        if (this.chopBefore != null && other.chopBefore != null ? !((Object)this.chopBefore.values()).equals(other.chopBefore.values()) : this.chopBefore != other.chopBefore) {
            return false;
        }
        return !(this.chopAfter != null && other.chopAfter != null ? !((Object)this.chopAfter.values()).equals(other.chopAfter.values()) : this.chopAfter != other.chopAfter);
    }

    protected final int commonComponentsHashCode() {
        int hash = this.minimumDepth * 31 + this.maximumDepth;
        if (this.chopBefore != null) {
            hash = hash * 31 + ((Object)this.chopBefore.values()).hashCode();
        }
        if (this.chopAfter != null) {
            hash = hash * 31 + ((Object)this.chopAfter.values()).hashCode();
        }
        return hash;
    }

    public final Iterable<DN> getChopAfter() {
        if (this.chopAfter != null) {
            return this.chopAfter.values();
        }
        return null;
    }

    public final Iterable<DN> getChopBefore() {
        if (this.chopBefore != null) {
            return this.chopBefore.values();
        }
        return null;
    }

    public final int getMaximumDepth() {
        return this.maximumDepth;
    }

    public final int getMinimumDepth() {
        return this.minimumDepth;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class Parser {
        private Scanner scanner;
        private static Pattern LBRACE = Pattern.compile("\\{.*");
        private static Pattern LBRACE_TOKEN = Pattern.compile("\\{");
        private static Pattern RBRACE = Pattern.compile("\\}.*");
        private static Pattern RBRACE_TOKEN = Pattern.compile("\\}");
        private static Pattern SEP = Pattern.compile(",.*");
        private static Pattern SEP_TOKEN = Pattern.compile(",");
        private static Pattern COLON = Pattern.compile(":.*");
        private static Pattern COLON_TOKEN = Pattern.compile(":");
        private static Pattern INT = Pattern.compile("\\d.*");
        private static Pattern INT_TOKEN = Pattern.compile("\\d+");
        private static Pattern NAME = Pattern.compile("[\\w_;-].*");
        private static Pattern NAME_TOKEN = Pattern.compile("[\\w_;-]+");
        private static Pattern STRING_VALUE = Pattern.compile("\".*");
        private static Pattern STRING_VALUE_TOKEN = Pattern.compile("\"([^\"]|(\"\"))*\"");

        public Parser(String value) {
            this.scanner = new Scanner(value);
        }

        public void skipLeftBrace() throws InputMismatchException, NoSuchElementException {
            this.nextValue(LBRACE, LBRACE_TOKEN);
        }

        public void skipRightBrace() throws InputMismatchException, NoSuchElementException {
            this.nextValue(RBRACE, RBRACE_TOKEN);
        }

        public void skipSeparator() throws InputMismatchException, NoSuchElementException {
            this.nextValue(SEP, SEP_TOKEN);
        }

        public void skipColon() throws InputMismatchException, NoSuchElementException {
            this.nextValue(COLON, COLON_TOKEN);
        }

        public boolean hasNextRightBrace() {
            return this.scanner.hasNext(RBRACE);
        }

        public boolean hasNext() {
            return this.scanner.hasNext();
        }

        public String nextKey() throws InputMismatchException, NoSuchElementException {
            return StaticUtils.toLowerCase(this.scanner.next());
        }

        public String nextName() throws InputMismatchException, NoSuchElementException {
            return this.nextValue(NAME, NAME_TOKEN);
        }

        public int nextInt() throws InputMismatchException, NoSuchElementException {
            String s = this.nextValue(INT, INT_TOKEN);
            return Integer.parseInt(s);
        }

        public String nextStringValue() throws InputMismatchException, NoSuchElementException {
            String s = this.nextValue(STRING_VALUE, STRING_VALUE_TOKEN);
            return s.substring(1, s.length() - 1).replace("\"\"", "\"");
        }

        public void nextSpecificExclusions(Set<DN> chopBefore, Set<DN> chopAfter) throws InputMismatchException, NoSuchElementException, DirectoryException {
            block4: {
                this.skipLeftBrace();
                boolean isFirstValue = true;
                while (true) {
                    if (this.hasNextRightBrace()) break block4;
                    if (!isFirstValue) {
                        this.skipSeparator();
                    } else {
                        isFirstValue = false;
                    }
                    String type = StaticUtils.toLowerCase(this.nextName());
                    this.skipColon();
                    if (type.equals("chopbefore")) {
                        chopBefore.add(DN.decode(this.nextStringValue()));
                        continue;
                    }
                    if (!type.equals("chopafter")) break;
                    chopAfter.add(DN.decode(this.nextStringValue()));
                }
                throw new InputMismatchException();
            }
            this.skipRightBrace();
        }

        private String nextValue(Pattern head, Pattern content) throws InputMismatchException, NoSuchElementException {
            if (!this.scanner.hasNext()) {
                throw new NoSuchElementException();
            }
            if (!this.scanner.hasNext(head)) {
                throw new InputMismatchException();
            }
            String s = this.scanner.findInLine(content);
            if (s == null) {
                throw new InputMismatchException();
            }
            return s;
        }
    }
}

