/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.util.ArrayList;
import java.util.List;
import org.opends.messages.CoreMessages;
import org.opends.messages.Message;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.PasswordPolicyCfg;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.PasswordPolicy;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PasswordPolicyConfig
implements ConfigurationChangeListener<PasswordPolicyCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private PasswordPolicy currentPolicy;

    public PasswordPolicyConfig(PasswordPolicy policy) {
        this.currentPolicy = policy;
    }

    @Override
    public boolean isConfigurationChangeAcceptable(PasswordPolicyCfg configuration, List<Message> unacceptableReasons) {
        assert (configuration.dn().equals(this.currentPolicy.getConfigEntryDN())) : "Internal Error: mismatch between DN of configuration entry andDN of current password policy.";
        try {
            new PasswordPolicy(configuration);
        }
        catch (ConfigException ce) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ce);
            }
            unacceptableReasons.add(ce.getMessageObject());
            return false;
        }
        catch (InitializationException ie) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ie);
            }
            unacceptableReasons.add(ie.getMessageObject());
            return false;
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(PasswordPolicyCfg configuration) {
        PasswordPolicy p;
        assert (configuration.dn().equals(this.currentPolicy.getConfigEntryDN())) : "Internal Error: mismatch between DN of configuration entry andDN of current password policy.";
        try {
            p = new PasswordPolicy(configuration);
        }
        catch (ConfigException ce) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ce);
            }
            ArrayList<Message> messages = new ArrayList<Message>();
            messages.add(ce.getMessageObject());
            return new ConfigChangeResult(DirectoryServer.getServerErrorResultCode(), true, messages);
        }
        catch (InitializationException ie) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ie);
            }
            ArrayList<Message> messages = new ArrayList<Message>();
            messages.add(ie.getMessageObject());
            return new ConfigChangeResult(DirectoryServer.getServerErrorResultCode(), true, messages);
        }
        ArrayList<Message> messages = new ArrayList<Message>();
        messages.add(CoreMessages.INFO_PWPOLICY_UPDATED_POLICY.get(String.valueOf(p.getConfigEntryDN())));
        this.currentPolicy = p;
        return new ConfigChangeResult(ResultCode.SUCCESS, false, messages);
    }

    public PasswordPolicy getPolicy() {
        return this.currentPolicy;
    }
}

