/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.opends.messages.ConfigMessages;
import org.opends.messages.CoreMessages;
import org.opends.messages.Message;
import org.opends.server.admin.ClassPropertyDefinition;
import org.opends.server.admin.server.ConfigurationAddListener;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ConfigurationDeleteListener;
import org.opends.server.admin.server.ServerManagementContext;
import org.opends.server.admin.std.meta.GroupImplementationCfgDefn;
import org.opends.server.admin.std.server.GroupImplementationCfg;
import org.opends.server.admin.std.server.RootCfg;
import org.opends.server.api.Backend;
import org.opends.server.api.BackendInitializationListener;
import org.opends.server.api.ChangeNotificationListener;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.Group;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.internal.InternalClientConnection;
import org.opends.server.protocols.internal.InternalSearchOperation;
import org.opends.server.protocols.ldap.LDAPControl;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DereferencePolicy;
import org.opends.server.types.Entry;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SearchResultEntry;
import org.opends.server.types.SearchScope;
import org.opends.server.types.operation.PostResponseAddOperation;
import org.opends.server.types.operation.PostResponseDeleteOperation;
import org.opends.server.types.operation.PostResponseModifyDNOperation;
import org.opends.server.types.operation.PostResponseModifyOperation;
import org.opends.server.util.StaticUtils;
import org.opends.server.workflowelement.localbackend.LocalBackendSearchOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupManager
implements ConfigurationChangeListener<GroupImplementationCfg>,
ConfigurationAddListener<GroupImplementationCfg>,
ConfigurationDeleteListener<GroupImplementationCfg>,
BackendInitializationListener,
ChangeNotificationListener {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private long refreshToken = 0L;
    private ConcurrentHashMap<DN, Group> groupImplementations = new ConcurrentHashMap();
    private ConcurrentHashMap<DN, Group> groupInstances = new ConcurrentHashMap();

    public GroupManager() {
        DirectoryServer.registerBackendInitializationListener(this);
        DirectoryServer.registerChangeNotificationListener(this);
    }

    public void initializeGroupImplementations() throws ConfigException, InitializationException {
        ServerManagementContext managementContext = ServerManagementContext.getInstance();
        RootCfg rootConfiguration = managementContext.getRootConfiguration();
        rootConfiguration.addGroupImplementationAddListener(this);
        rootConfiguration.addGroupImplementationDeleteListener(this);
        for (String name : rootConfiguration.listGroupImplementations()) {
            GroupImplementationCfg groupConfiguration = rootConfiguration.getGroupImplementation(name);
            groupConfiguration.addChangeListener(this);
            if (!groupConfiguration.isEnabled()) continue;
            String className = groupConfiguration.getJavaClass();
            try {
                Group group = this.loadGroup(className, groupConfiguration, true);
                this.groupImplementations.put(groupConfiguration.dn(), group);
            }
            catch (InitializationException ie) {
                ErrorLogger.logError(ie.getMessageObject());
            }
        }
    }

    @Override
    public boolean isConfigurationAddAcceptable(GroupImplementationCfg configuration, List<Message> unacceptableReasons) {
        if (configuration.isEnabled()) {
            String className = configuration.getJavaClass();
            try {
                this.loadGroup(className, configuration, false);
            }
            catch (InitializationException ie) {
                unacceptableReasons.add(ie.getMessageObject());
                return false;
            }
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationAdd(GroupImplementationCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        configuration.addChangeListener(this);
        if (!configuration.isEnabled()) {
            return new ConfigChangeResult(resultCode, adminActionRequired, messages);
        }
        Group group = null;
        String className = configuration.getJavaClass();
        try {
            group = this.loadGroup(className, configuration, true);
        }
        catch (InitializationException ie) {
            if (resultCode == ResultCode.SUCCESS) {
                resultCode = DirectoryServer.getServerErrorResultCode();
            }
            messages.add(ie.getMessageObject());
        }
        if (resultCode == ResultCode.SUCCESS) {
            this.groupImplementations.put(configuration.dn(), group);
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public boolean isConfigurationDeleteAcceptable(GroupImplementationCfg configuration, List<Message> unacceptableReasons) {
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationDelete(GroupImplementationCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        Group group = this.groupImplementations.remove(configuration.dn());
        if (group != null) {
            Iterator<Group> iterator = this.groupInstances.values().iterator();
            while (iterator.hasNext()) {
                Group g = iterator.next();
                if (!g.getClass().getName().equals(group.getClass().getName())) continue;
                iterator.remove();
            }
            group.finalizeGroupImplementation();
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(GroupImplementationCfg configuration, List<Message> unacceptableReasons) {
        if (configuration.isEnabled()) {
            String className = configuration.getJavaClass();
            try {
                this.loadGroup(className, configuration, false);
            }
            catch (InitializationException ie) {
                unacceptableReasons.add(ie.getMessageObject());
                return false;
            }
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(GroupImplementationCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        Group existingGroup = this.groupImplementations.get(configuration.dn());
        if (!configuration.isEnabled()) {
            Group group;
            if (existingGroup != null && (group = this.groupImplementations.remove(configuration.dn())) != null) {
                Iterator<Group> iterator = this.groupInstances.values().iterator();
                while (iterator.hasNext()) {
                    Group g = iterator.next();
                    if (!g.getClass().getName().equals(group.getClass().getName())) continue;
                    iterator.remove();
                }
                group.finalizeGroupImplementation();
            }
            return new ConfigChangeResult(resultCode, adminActionRequired, messages);
        }
        String className = configuration.getJavaClass();
        if (existingGroup != null) {
            if (!className.equals(existingGroup.getClass().getName())) {
                adminActionRequired = true;
            }
            return new ConfigChangeResult(resultCode, adminActionRequired, messages);
        }
        Group group = null;
        try {
            group = this.loadGroup(className, configuration, true);
        }
        catch (InitializationException ie) {
            if (resultCode == ResultCode.SUCCESS) {
                resultCode = DirectoryServer.getServerErrorResultCode();
            }
            messages.add(ie.getMessageObject());
        }
        if (resultCode == ResultCode.SUCCESS) {
            this.groupImplementations.put(configuration.dn(), group);
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    private Group loadGroup(String className, GroupImplementationCfg configuration, boolean initialize) throws InitializationException {
        try {
            GroupImplementationCfgDefn definition = GroupImplementationCfgDefn.getInstance();
            ClassPropertyDefinition propertyDefinition = definition.getJavaClassPropertyDefinition();
            Class<Group> groupClass = propertyDefinition.loadClass(className, Group.class);
            Group group = groupClass.newInstance();
            if (initialize) {
                Method method = group.getClass().getMethod("initializeGroupImplementation", configuration.configurationClass());
                method.invoke((Object)group, configuration);
            } else {
                Method method = group.getClass().getMethod("isConfigurationAcceptable", GroupImplementationCfg.class, List.class);
                ArrayList unacceptableReasons = new ArrayList();
                Boolean acceptable = (Boolean)method.invoke((Object)group, configuration, unacceptableReasons);
                if (!acceptable.booleanValue()) {
                    StringBuilder buffer = new StringBuilder();
                    if (!unacceptableReasons.isEmpty()) {
                        Iterator iterator = unacceptableReasons.iterator();
                        buffer.append((CharSequence)iterator.next());
                        while (iterator.hasNext()) {
                            buffer.append(".  ");
                            buffer.append((CharSequence)iterator.next());
                        }
                    }
                    Message message = ConfigMessages.ERR_CONFIG_GROUP_CONFIG_NOT_ACCEPTABLE.get(String.valueOf(configuration.dn()), buffer.toString());
                    throw new InitializationException(message);
                }
            }
            return group;
        }
        catch (Exception e) {
            Message message = ConfigMessages.ERR_CONFIG_GROUP_INITIALIZATION_FAILED.get(className, String.valueOf(configuration.dn()), StaticUtils.stackTraceToSingleLineString(e));
            throw new InitializationException(message, (Throwable)e);
        }
    }

    public void finalizeGroupManager() {
        this.deregisterAllGroups();
        for (Group groupImplementation : this.groupImplementations.values()) {
            groupImplementation.finalizeGroupImplementation();
        }
        this.groupImplementations.clear();
    }

    public Iterable<Group> getGroupImplementations() {
        return this.groupImplementations.values();
    }

    public Iterable<Group> getGroupInstances() {
        return this.groupInstances.values();
    }

    public Group getGroupInstance(DN entryDN) {
        Group group = this.groupInstances.get(entryDN);
        if (group == null) {
            // empty if block
        }
        return group;
    }

    @Override
    public void performBackendInitializationProcessing(Backend backend) {
        InternalClientConnection conn = InternalClientConnection.getRootConnection();
        LinkedList<Control> requestControls = new LinkedList<Control>();
        requestControls.add(new LDAPControl("1.3.6.1.4.1.26027.1.5.1", false));
        for (DN configEntryDN : this.groupImplementations.keySet()) {
            SearchFilter filter;
            Group groupImplementation;
            block12: {
                groupImplementation = this.groupImplementations.get(configEntryDN);
                try {
                    filter = groupImplementation.getGroupDefinitionFilter();
                    if (backend.getEntryCount() <= 0L || backend.isIndexed(filter)) break block12;
                    ErrorLogger.logError(CoreMessages.WARN_GROUP_FILTER_NOT_INDEXED.get(String.valueOf(filter), String.valueOf(configEntryDN), backend.getBackendID()));
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) continue;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    continue;
                }
            }
            for (DN baseDN : backend.getBaseDNs()) {
                block13: {
                    try {
                        if (!backend.entryExists(baseDN)) {
                        }
                        break block13;
                    }
                    catch (Exception e) {
                        if (!DebugLogger.debugEnabled()) continue;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    continue;
                }
                InternalSearchOperation internalSearch = new InternalSearchOperation((ClientConnection)conn, conn.nextOperationID(), conn.nextMessageID(), requestControls, baseDN, SearchScope.WHOLE_SUBTREE, DereferencePolicy.NEVER_DEREF_ALIASES, 0, 0, false, filter, null, null);
                LocalBackendSearchOperation localSearch = new LocalBackendSearchOperation(internalSearch);
                try {
                    backend.search(localSearch);
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) continue;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    continue;
                }
                for (SearchResultEntry entry : internalSearch.getSearchEntries()) {
                    try {
                        Group groupInstance = groupImplementation.newInstance(entry);
                        this.groupInstances.put(entry.getDN(), groupInstance);
                        ++this.refreshToken;
                    }
                    catch (Exception e) {
                        if (!DebugLogger.debugEnabled()) continue;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                }
            }
        }
    }

    @Override
    public void performBackendFinalizationProcessing(Backend backend) {
        Iterator<Map.Entry<DN, Group>> iterator = this.groupInstances.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<DN, Group> mapEntry = iterator.next();
            DN groupEntryDN = mapEntry.getKey();
            if (!backend.handlesEntry(groupEntryDN)) continue;
            iterator.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleAddOperation(PostResponseAddOperation addOperation, Entry entry) {
        List<Control> requestControls = addOperation.getRequestControls();
        if (requestControls != null) {
            for (Control c : requestControls) {
                if (!c.getOID().equals("1.3.6.1.4.1.26027.1.5.1")) continue;
                return;
            }
        }
        ConcurrentHashMap<DN, Group> concurrentHashMap = this.groupInstances;
        synchronized (concurrentHashMap) {
            this.createAndRegisterGroup(entry);
            ++this.refreshToken;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleDeleteOperation(PostResponseDeleteOperation deleteOperation, Entry entry) {
        List<Control> requestControls = deleteOperation.getRequestControls();
        if (requestControls != null) {
            for (Control c : requestControls) {
                if (!c.getOID().equals("1.3.6.1.4.1.26027.1.5.1")) continue;
                return;
            }
        }
        ConcurrentHashMap<DN, Group> concurrentHashMap = this.groupInstances;
        synchronized (concurrentHashMap) {
            this.groupInstances.remove(entry.getDN());
            ++this.refreshToken;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleModifyOperation(PostResponseModifyOperation modifyOperation, Entry oldEntry, Entry newEntry) {
        List<Control> requestControls = modifyOperation.getRequestControls();
        if (requestControls != null) {
            for (Control c : requestControls) {
                if (!c.getOID().equals("1.3.6.1.4.1.26027.1.5.1")) continue;
                return;
            }
        }
        if (this.groupInstances.containsKey(oldEntry.getDN())) {
            ConcurrentHashMap<DN, Group> concurrentHashMap = this.groupInstances;
            synchronized (concurrentHashMap) {
                if (!oldEntry.getDN().equals(newEntry.getDN())) {
                    this.groupInstances.remove(oldEntry.getDN());
                }
                this.createAndRegisterGroup(newEntry);
                ++this.refreshToken;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleModifyDNOperation(PostResponseModifyDNOperation modifyDNOperation, Entry oldEntry, Entry newEntry) {
        List<Control> requestControls = modifyDNOperation.getRequestControls();
        if (requestControls != null) {
            for (Control c : requestControls) {
                if (!c.getOID().equals("1.3.6.1.4.1.26027.1.5.1")) continue;
                return;
            }
        }
        if (this.groupInstances.containsKey(oldEntry.getDN())) {
            ConcurrentHashMap<DN, Group> concurrentHashMap = this.groupInstances;
            synchronized (concurrentHashMap) {
                this.createAndRegisterGroup(newEntry);
                this.groupInstances.remove(oldEntry.getDN());
                ++this.refreshToken;
            }
        }
    }

    private void createAndRegisterGroup(Entry entry) {
        for (Group groupImplementation : this.groupImplementations.values()) {
            try {
                if (!groupImplementation.isGroupDefinition(entry)) continue;
                Group groupInstance = groupImplementation.newInstance(entry);
                this.groupInstances.put(entry.getDN(), groupInstance);
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) continue;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
    }

    void deregisterAllGroups() {
        this.groupInstances.clear();
    }

    public boolean hasInstancesChanged(long token) {
        return token != this.refreshToken;
    }

    public long refreshToken() {
        return this.refreshToken;
    }
}

