/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.opends.messages.CoreMessages;
import org.opends.messages.Message;
import org.opends.server.api.CompressedSchema;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1;
import org.opends.server.protocols.asn1.ASN1Reader;
import org.opends.server.protocols.asn1.ASN1Writer;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeBuilder;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.AttributeValues;
import org.opends.server.types.Attributes;
import org.opends.server.types.ByteSequence;
import org.opends.server.types.ByteSequenceReader;
import org.opends.server.types.ByteString;
import org.opends.server.types.ByteStringBuilder;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ObjectClass;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultCompressedSchema
extends CompressedSchema {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private AtomicInteger adCounter;
    private AtomicInteger ocCounter;
    private ConcurrentHashMap<ByteSequence, AttributeType> atDecodeMap = new ConcurrentHashMap();
    private ConcurrentHashMap<ByteSequence, Set<String>> aoDecodeMap = new ConcurrentHashMap();
    private ConcurrentHashMap<ByteSequence, Map<ObjectClass, String>> ocDecodeMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<AttributeType, ConcurrentHashMap<Set<String>, ByteSequence>> adEncodeMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<Map<ObjectClass, String>, ByteSequence> ocEncodeMap = new ConcurrentHashMap();

    public DefaultCompressedSchema() {
        this.adCounter = new AtomicInteger(1);
        this.ocCounter = new AtomicInteger(1);
        this.load();
    }

    private void load() {
        FileInputStream inputStream = null;
        try {
            ByteString token;
            String path = DirectoryServer.getInstanceRoot() + File.separator + "config" + File.separator + "schematokens.dat";
            if (!new File(path).exists()) {
                return;
            }
            inputStream = new FileInputStream(path);
            ASN1Reader reader = ASN1.getReader(inputStream);
            reader.readStartSequence();
            while (reader.hasNextElement()) {
                reader.readStartSequence();
                token = reader.readOctetString();
                LinkedHashMap<ObjectClass, String> ocMap = new LinkedHashMap<ObjectClass, String>();
                while (reader.hasNextElement()) {
                    String ocName = reader.readOctetStringAsString();
                    String lowerName = StaticUtils.toLowerCase(ocName);
                    ObjectClass oc = DirectoryServer.getObjectClass(lowerName, true);
                    ocMap.put(oc, ocName);
                }
                reader.readEndSequence();
                this.ocEncodeMap.put(ocMap, token);
                this.ocDecodeMap.put(token, ocMap);
            }
            reader.readEndSequence();
            this.ocCounter.set((int)reader.readInteger());
            reader.readStartSequence();
            while (reader.hasNextElement()) {
                reader.readStartSequence();
                token = reader.readOctetString();
                String attrName = reader.readOctetStringAsString();
                String lowerName = StaticUtils.toLowerCase(attrName);
                AttributeType attrType = DirectoryServer.getAttributeType(lowerName, true);
                LinkedHashSet<String> options = new LinkedHashSet<String>();
                while (reader.hasNextElement()) {
                    options.add(reader.readOctetStringAsString());
                }
                reader.readEndSequence();
                this.atDecodeMap.put(token, attrType);
                this.aoDecodeMap.put(token, options);
                ConcurrentHashMap<Set<String>, ByteSequence> map = this.adEncodeMap.get(attrType);
                if (map == null) {
                    map = new ConcurrentHashMap(1);
                    map.put(options, token);
                    this.adEncodeMap.put(attrType, map);
                    continue;
                }
                map.put(options, token);
            }
            reader.readEndSequence();
            this.adCounter.set((int)reader.readInteger());
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            throw new RuntimeException(e);
        }
        finally {
            block21: {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) break block21;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
        }
    }

    private void save() throws DirectoryException {
        FileOutputStream outputStream = null;
        try {
            String path = DirectoryServer.getInstanceRoot() + File.separator + "config" + File.separator + "schematokens.dat";
            String tempPath = path + ".tmp";
            outputStream = new FileOutputStream(tempPath);
            ASN1Writer writer = ASN1.getWriter(outputStream);
            writer.writeStartSequence();
            for (Map.Entry<ByteSequence, Map<ObjectClass, String>> mapEntry : this.ocDecodeMap.entrySet()) {
                writer.writeStartSequence();
                writer.writeOctetString(mapEntry.getKey());
                Map<ObjectClass, String> ocMap = mapEntry.getValue();
                for (String ocName : ocMap.values()) {
                    writer.writeOctetString(ocName);
                }
                writer.writeEndSequence();
            }
            writer.writeEndSequence();
            writer.writeInteger(this.ocCounter.get());
            writer.writeStartSequence();
            for (ByteSequence token : this.atDecodeMap.keySet()) {
                writer.writeStartSequence();
                AttributeType attrType = this.atDecodeMap.get(token);
                Set<String> options = this.aoDecodeMap.get(token);
                writer.writeOctetString(token);
                writer.writeOctetString(attrType.getNameOrOID());
                for (String option : options) {
                    writer.writeOctetString(option);
                }
                writer.writeEndSequence();
            }
            writer.writeEndSequence();
            writer.writeInteger(this.adCounter.get());
            outputStream.close();
            File liveFile = new File(path);
            File tempFile = new File(tempPath);
            if (liveFile.exists()) {
                File saveFile = new File(liveFile.getAbsolutePath() + ".save");
                if (saveFile.exists()) {
                    saveFile.delete();
                }
                liveFile.renameTo(saveFile);
            }
            tempFile.renameTo(liveFile);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = CoreMessages.ERR_COMPRESSEDSCHEMA_CANNOT_WRITE_UPDATED_DATA.get(StaticUtils.stackTraceToSingleLineString(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
        }
        finally {
            block18: {
                try {
                    if (outputStream != null) {
                        outputStream.close();
                    }
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) break block18;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encodeObjectClasses(ByteStringBuilder entryBuffer, Map<ObjectClass, String> objectClasses) throws DirectoryException {
        ByteSequence encodedClasses = this.ocEncodeMap.get(objectClasses);
        if (encodedClasses == null) {
            ConcurrentHashMap<Map<ObjectClass, String>, ByteSequence> concurrentHashMap = this.ocEncodeMap;
            synchronized (concurrentHashMap) {
                int setValue = this.ocCounter.getAndIncrement();
                encodedClasses = ByteString.wrap(this.encodeInt(setValue));
                this.ocEncodeMap.put(objectClasses, encodedClasses);
                this.ocDecodeMap.put(encodedClasses, objectClasses);
                this.save();
            }
        }
        entryBuffer.appendBERLength(encodedClasses.length());
        encodedClasses.copyTo(entryBuffer);
    }

    @Override
    public Map<ObjectClass, String> decodeObjectClasses(ByteSequenceReader entryBufferReader) throws DirectoryException {
        int tokenLength = entryBufferReader.getBERLength();
        ByteSequence byteArray = entryBufferReader.getByteSequence(tokenLength);
        Map<ObjectClass, String> ocMap = this.ocDecodeMap.get(byteArray);
        if (ocMap == null) {
            Message message = CoreMessages.ERR_COMPRESSEDSCHEMA_UNKNOWN_OC_TOKEN.get(byteArray.toByteString().toHex());
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
        }
        return ocMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encodeAttribute(ByteStringBuilder entryBuffer, Attribute attribute) throws DirectoryException {
        AttributeType type = attribute.getAttributeType();
        Set<String> options = attribute.getOptions();
        ConcurrentHashMap<Set<String>, ByteSequence> map = this.adEncodeMap.get(type);
        if (map == null) {
            ByteString byteArray;
            ConcurrentHashMap<AttributeType, ConcurrentHashMap<Set<String>, ByteSequence>> concurrentHashMap = this.adEncodeMap;
            synchronized (concurrentHashMap) {
                map = new ConcurrentHashMap(1);
                int intValue = this.adCounter.getAndIncrement();
                byteArray = ByteString.wrap(this.encodeInt(intValue));
                map.put(options, byteArray);
                this.adEncodeMap.put(type, map);
                this.atDecodeMap.put(byteArray, type);
                this.aoDecodeMap.put(byteArray, options);
                this.save();
            }
            this.encodeAttribute(entryBuffer, byteArray, attribute);
        } else {
            ByteSequence byteArray = map.get(options);
            if (byteArray == null) {
                ConcurrentHashMap<Set<String>, ByteSequence> concurrentHashMap = map;
                synchronized (concurrentHashMap) {
                    int intValue = this.adCounter.getAndIncrement();
                    byteArray = ByteString.wrap(this.encodeInt(intValue));
                    map.put(options, byteArray);
                    this.atDecodeMap.put(byteArray, type);
                    this.aoDecodeMap.put(byteArray, options);
                    this.save();
                }
            }
            this.encodeAttribute(entryBuffer, byteArray, attribute);
        }
    }

    private void encodeAttribute(ByteStringBuilder buffer, ByteSequence adArray, Attribute attribute) {
        buffer.appendBERLength(adArray.length());
        adArray.copyTo(buffer);
        buffer.appendBERLength(attribute.size());
        for (AttributeValue v : attribute) {
            buffer.appendBERLength(v.getValue().length());
            buffer.append(v.getValue());
        }
    }

    @Override
    public Attribute decodeAttribute(ByteSequenceReader entryBufferReader) throws DirectoryException {
        int adArrayLength = entryBufferReader.getBERLength();
        ByteSequence adArray = entryBufferReader.getByteSequence(adArrayLength);
        AttributeType attrType = this.atDecodeMap.get(adArray);
        Set<String> options = this.aoDecodeMap.get(adArray);
        if (attrType == null || options == null) {
            Message message = CoreMessages.ERR_COMPRESSEDSCHEMA_UNRECOGNIZED_AD_TOKEN.get(adArray.toByteString().toHex());
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
        }
        int numValues = entryBufferReader.getBERLength();
        if (numValues == 1 && options.isEmpty()) {
            int valueLength = entryBufferReader.getBERLength();
            ByteString valueBytes = entryBufferReader.getByteSequence(valueLength).toByteString();
            return Attributes.create(attrType, AttributeValues.create(attrType, valueBytes));
        }
        AttributeBuilder builder = new AttributeBuilder(attrType);
        builder.setOptions(options);
        builder.setInitialCapacity(numValues);
        for (int i = 0; i < numValues; ++i) {
            int valueLength = entryBufferReader.getBERLength();
            ByteString valueBytes = entryBufferReader.getByteSequence(valueLength).toByteString();
            builder.add(AttributeValues.create(attrType, valueBytes));
        }
        return builder.toAttribute();
    }

    private byte[] encodeInt(int intValue) {
        byte[] array = intValue <= 255 ? new byte[]{(byte)(intValue & 0xFF)} : (intValue <= 65535 ? new byte[]{(byte)(intValue >> 8 & 0xFF), (byte)(intValue & 0xFF)} : (intValue <= 0xFFFFFF ? new byte[]{(byte)(intValue >> 16 & 0xFF), (byte)(intValue >> 8 & 0xFF), (byte)(intValue & 0xFF)} : new byte[]{(byte)(intValue >> 24 & 0xFF), (byte)(intValue >> 16 & 0xFF), (byte)(intValue >> 8 & 0xFF), (byte)(intValue & 0xFF)}));
        return array;
    }
}

