/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.util.HashSet;
import java.util.InputMismatchException;
import java.util.NoSuchElementException;
import org.opends.messages.Message;
import org.opends.messages.SchemaMessages;
import org.opends.server.core.SimpleSubtreeSpecification;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AbsoluteSubtreeSpecification
extends SimpleSubtreeSpecification {
    private SearchFilter filter;

    public static AbsoluteSubtreeSpecification valueOf(String s) throws DirectoryException {
        DN absoluteBaseDN = null;
        int minimum = -1;
        int maximum = -1;
        HashSet<DN> chopBefore = new HashSet<DN>();
        HashSet<DN> chopAfter = new HashSet<DN>();
        SearchFilter filter = null;
        SimpleSubtreeSpecification.Parser parser = new SimpleSubtreeSpecification.Parser(s);
        boolean isValid = true;
        try {
            block21: {
                parser.skipLeftBrace();
                boolean isFirst = true;
                while (true) {
                    if (parser.hasNextRightBrace()) {
                        parser.skipRightBrace();
                        if (parser.hasNext()) {
                            throw new InputMismatchException();
                        }
                        break block21;
                    }
                    if (!isFirst) {
                        parser.skipSeparator();
                    } else {
                        isFirst = false;
                    }
                    String key = parser.nextKey();
                    if (key.equals("absolutebase")) {
                        if (absoluteBaseDN != null) {
                            throw new InputMismatchException();
                        }
                        absoluteBaseDN = DN.decode(parser.nextStringValue());
                        continue;
                    }
                    if (key.equals("minimum")) {
                        if (minimum != -1) {
                            throw new InputMismatchException();
                        }
                        minimum = parser.nextInt();
                        continue;
                    }
                    if (key.equals("maximum")) {
                        if (maximum != -1) {
                            throw new InputMismatchException();
                        }
                        maximum = parser.nextInt();
                        continue;
                    }
                    if (key.equals("specificationfilter")) {
                        if (filter != null) {
                            throw new InputMismatchException();
                        }
                        filter = SearchFilter.createFilterFromString(parser.nextStringValue());
                        continue;
                    }
                    if (!key.equals("specificexclusions")) break;
                    if (!chopBefore.isEmpty() || !chopAfter.isEmpty()) {
                        throw new InputMismatchException();
                    }
                    parser.nextSpecificExclusions(chopBefore, chopAfter);
                }
                throw new InputMismatchException();
            }
            if (absoluteBaseDN == null) {
                isValid = false;
            }
            if (minimum < 0) {
                minimum = 0;
            }
            if (maximum >= 0 && maximum < minimum) {
                isValid = false;
            }
        }
        catch (InputMismatchException e) {
            isValid = false;
        }
        catch (NoSuchElementException e) {
            isValid = false;
        }
        if (isValid) {
            return new AbsoluteSubtreeSpecification(absoluteBaseDN, minimum, maximum, chopBefore, chopAfter, filter);
        }
        Message message = SchemaMessages.ERR_ATTR_SYNTAX_ABSOLUTE_SUBTREE_SPECIFICATION_INVALID.get(s);
        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
    }

    public AbsoluteSubtreeSpecification(DN absoluteBaseDN, int minimumDepth, int maximumDepth, Iterable<DN> chopBefore, Iterable<DN> chopAfter, SearchFilter filter) {
        super(absoluteBaseDN, minimumDepth, maximumDepth, chopBefore, chopAfter);
        this.filter = filter;
    }

    public DN getAbsoluteBaseDN() {
        return this.getBaseDN();
    }

    public SearchFilter getFilter() {
        return this.filter;
    }

    @Override
    public boolean isWithinScope(Entry entry) {
        if (this.isDNWithinScope(entry.getDN())) {
            try {
                return this.filter.matchesEntry(entry);
            }
            catch (DirectoryException e) {
                return false;
            }
        }
        return false;
    }

    @Override
    public StringBuilder toString(StringBuilder builder) {
        builder.append("{ absoluteBase ");
        StaticUtils.toRFC3641StringValue(builder, this.getBaseDN().toString());
        Iterable<DN> chopBefore = this.getChopBefore();
        Iterable<DN> chopAfter = this.getChopAfter();
        if (chopBefore != null && chopBefore.iterator().hasNext() || chopAfter != null && chopAfter.iterator().hasNext()) {
            builder.append(", specificExclusions { ");
            boolean isFirst = true;
            if (chopBefore != null) {
                for (DN dn : chopBefore) {
                    if (!isFirst) {
                        builder.append(", chopBefore:");
                    } else {
                        builder.append("chopBefore:");
                        isFirst = false;
                    }
                    StaticUtils.toRFC3641StringValue(builder, dn.toString());
                }
            }
            if (chopAfter != null) {
                for (DN dn : chopAfter) {
                    if (!isFirst) {
                        builder.append(", chopAfter:");
                    } else {
                        builder.append("chopAfter:");
                        isFirst = false;
                    }
                    StaticUtils.toRFC3641StringValue(builder, dn.toString());
                }
            }
            builder.append(" }");
        }
        if (this.getMinimumDepth() > 0) {
            builder.append(", minimum ");
            builder.append(this.getMinimumDepth());
        }
        if (this.getMaximumDepth() >= 0) {
            builder.append(", maximum ");
            builder.append(this.getMaximumDepth());
        }
        if (this.filter != null) {
            builder.append(", specificationFilter ");
            StaticUtils.toRFC3641StringValue(builder, this.filter.toString());
        }
        builder.append(" }");
        return builder;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AbsoluteSubtreeSpecification) {
            AbsoluteSubtreeSpecification other = (AbsoluteSubtreeSpecification)obj;
            if (!this.commonComponentsEquals(other)) {
                return false;
            }
            if (!this.getBaseDN().equals(other.getBaseDN())) {
                return false;
            }
            if (this.filter != null) {
                return this.filter.equals(other.filter);
            }
            return this.filter == other.filter;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = this.commonComponentsHashCode();
        hash = hash * 31 + this.getBaseDN().hashCode();
        if (this.filter != null) {
            hash = hash * 31 + this.filter.hashCode();
        }
        return hash;
    }
}

