/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.controls;

import java.io.IOException;
import org.opends.messages.Message;
import org.opends.messages.ProtocolMessages;
import org.opends.server.controls.ControlDecoder;
import org.opends.server.protocols.asn1.ASN1Writer;
import org.opends.server.types.ByteString;
import org.opends.server.types.Control;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ResultCode;

public class SubtreeDeleteControl
extends Control {
    public static final ControlDecoder<SubtreeDeleteControl> DECODER = new Decoder();

    public SubtreeDeleteControl(boolean isCritical) {
        super("1.2.840.113556.1.4.805", isCritical);
    }

    protected void writeValue(ASN1Writer writer) throws IOException {
    }

    public void toString(StringBuilder buffer) {
        buffer.append("SubtreeDeleteControl()");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Decoder
    implements ControlDecoder<SubtreeDeleteControl> {
        private Decoder() {
        }

        @Override
        public SubtreeDeleteControl decode(boolean isCritical, ByteString value) throws DirectoryException {
            if (value != null) {
                Message message = ProtocolMessages.ERR_SUBTREE_DELETE_INVALID_CONTROL_VALUE.get();
                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
            }
            return new SubtreeDeleteControl(isCritical);
        }

        @Override
        public String getOID() {
            return "1.2.840.113556.1.4.805";
        }
    }
}

