/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.task;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.opends.messages.BackendMessages;
import org.opends.messages.Message;
import org.opends.server.backends.task.Task;
import org.opends.server.backends.task.TaskScheduler;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.Attributes;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.InitializationException;
import org.opends.server.types.RDN;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

public class RecurringTask {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private final DN recurringTaskEntryDN;
    private final Entry recurringTaskEntry;
    private final String recurringTaskID;
    private final String taskClassName;
    private Task task;
    private final TaskScheduler taskScheduler;
    private static final int TASKTAB_NUM_TOKENS = 5;
    private static final Pattern exactPattern = Pattern.compile("\\d+");
    private static final Pattern rangePattern = Pattern.compile("\\d+[-]\\d+");
    private static final Pattern listPattern = Pattern.compile("^(\\d+,)(.*)(\\d+)$");
    private boolean[] minutesArray;
    private boolean[] hoursArray;
    private boolean[] daysArray;
    private boolean[] monthArray;
    private boolean[] weekdayArray;

    public RecurringTask(TaskScheduler taskScheduler, Entry recurringTaskEntry) throws DirectoryException {
        Class<?> taskClass;
        List<Attribute> attrList;
        this.taskScheduler = taskScheduler;
        this.recurringTaskEntry = recurringTaskEntry;
        this.recurringTaskEntryDN = recurringTaskEntry.getDN();
        AttributeType attrType = DirectoryServer.getAttributeType("ds-recurring-task-id".toLowerCase());
        if (attrType == null) {
            attrType = DirectoryServer.getDefaultAttributeType("ds-recurring-task-id");
        }
        if ((attrList = recurringTaskEntry.getAttribute(attrType)) == null || attrList.isEmpty()) {
            Message message = BackendMessages.ERR_RECURRINGTASK_NO_ID_ATTRIBUTE.get("ds-recurring-task-id");
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
        }
        if (attrList.size() > 1) {
            Message message = BackendMessages.ERR_RECURRINGTASK_MULTIPLE_ID_TYPES.get("ds-recurring-task-id");
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
        }
        Attribute attr = attrList.get(0);
        if (attr.isEmpty()) {
            Message message = BackendMessages.ERR_RECURRINGTASK_NO_ID.get("ds-recurring-task-id");
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
        }
        Iterator<AttributeValue> iterator = attr.iterator();
        AttributeValue value = iterator.next();
        if (iterator.hasNext()) {
            Message message = BackendMessages.ERR_RECURRINGTASK_MULTIPLE_ID_VALUES.get("ds-recurring-task-id");
            throw new DirectoryException(ResultCode.OBJECTCLASS_VIOLATION, message);
        }
        this.recurringTaskID = value.getValue().toString();
        attrType = DirectoryServer.getAttributeType("ds-recurring-task-schedule".toLowerCase());
        if (attrType == null) {
            attrType = DirectoryServer.getDefaultAttributeType("ds-recurring-task-schedule");
        }
        if ((attrList = recurringTaskEntry.getAttribute(attrType)) == null || attrList.isEmpty()) {
            Message message = BackendMessages.ERR_RECURRINGTASK_NO_SCHEDULE_ATTRIBUTE.get("ds-recurring-task-schedule");
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
        }
        if (attrList.size() > 1) {
            Message message = BackendMessages.ERR_RECURRINGTASK_MULTIPLE_SCHEDULE_TYPES.get("ds-recurring-task-schedule");
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
        }
        attr = attrList.get(0);
        if (attr.isEmpty()) {
            Message message = BackendMessages.ERR_RECURRINGTASK_NO_SCHEDULE_VALUES.get("ds-recurring-task-schedule");
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
        }
        iterator = attr.iterator();
        value = iterator.next();
        if (iterator.hasNext()) {
            Message message = BackendMessages.ERR_RECURRINGTASK_MULTIPLE_SCHEDULE_VALUES.get("ds-recurring-task-schedule");
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
        }
        String taskScheduleTab = ((Object)value).toString();
        this.parseTaskTab(taskScheduleTab);
        attrType = DirectoryServer.getAttributeType("ds-task-class-name".toLowerCase());
        if (attrType == null) {
            attrType = DirectoryServer.getDefaultAttributeType("ds-task-class-name");
        }
        if ((attrList = recurringTaskEntry.getAttribute(attrType)) == null || attrList.isEmpty()) {
            Message message = BackendMessages.ERR_TASKSCHED_NO_CLASS_ATTRIBUTE.get("ds-task-class-name");
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
        }
        if (attrList.size() > 1) {
            Message message = BackendMessages.ERR_TASKSCHED_MULTIPLE_CLASS_TYPES.get("ds-task-class-name");
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
        }
        attr = attrList.get(0);
        if (attr.isEmpty()) {
            Message message = BackendMessages.ERR_TASKSCHED_NO_CLASS_VALUES.get("ds-task-class-name");
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
        }
        iterator = attr.iterator();
        value = iterator.next();
        if (iterator.hasNext()) {
            Message message = BackendMessages.ERR_TASKSCHED_MULTIPLE_CLASS_VALUES.get("ds-task-class-name");
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
        }
        this.taskClassName = value.getValue().toString();
        try {
            taskClass = DirectoryServer.loadClass(this.taskClassName);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = BackendMessages.ERR_RECURRINGTASK_CANNOT_LOAD_CLASS.get(String.valueOf(this.taskClassName), "ds-task-class-name", StaticUtils.getExceptionMessage(e));
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message, e);
        }
        try {
            this.task = (Task)taskClass.newInstance();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = BackendMessages.ERR_RECURRINGTASK_CANNOT_INSTANTIATE_CLASS_AS_TASK.get(String.valueOf(this.taskClassName), Task.class.getName());
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message, e);
        }
        try {
            this.task.initializeTaskInternal(taskScheduler, recurringTaskEntry);
        }
        catch (InitializationException ie) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ie);
            }
            Message message = BackendMessages.ERR_RECURRINGTASK_CANNOT_INITIALIZE_INTERNAL.get(String.valueOf(this.taskClassName), ie.getMessage());
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, ie);
        }
        this.task.initializeTask();
    }

    public String getRecurringTaskID() {
        return this.recurringTaskID;
    }

    public DN getRecurringTaskEntryDN() {
        return this.recurringTaskEntryDN;
    }

    public Entry getRecurringTaskEntry() {
        return this.recurringTaskEntry;
    }

    public String getTaskClassName() {
        return this.taskClassName;
    }

    public Task scheduleNextIteration() throws DirectoryException {
        Task nextTask;
        block4: {
            nextTask = null;
            Date nextTaskDate = null;
            try {
                nextTaskDate = this.getNextIteration();
            }
            catch (IllegalArgumentException e) {
                throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, BackendMessages.ERR_RECURRINGTASK_INVALID_TOKENS_COMBO.get("ds-recurring-task-schedule"));
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
            String nextTaskStartTime = dateFormat.format(nextTaskDate);
            try {
                nextTask = (Task)this.task.getClass().newInstance();
                Entry nextTaskEntry = this.recurringTaskEntry.duplicate(false);
                String nextTaskID = this.task.getTaskID() + " - " + nextTaskDate.toString();
                String nextTaskIDName = "ds-task-id";
                AttributeType taskIDAttrType = DirectoryServer.getAttributeType(nextTaskIDName);
                Attribute nextTaskIDAttr = Attributes.create(taskIDAttrType, nextTaskID);
                nextTaskEntry.replaceAttribute(nextTaskIDAttr);
                RDN nextTaskRDN = RDN.decode(nextTaskIDName + "=" + nextTaskID);
                DN nextTaskDN = new DN(nextTaskRDN, this.taskScheduler.getTaskBackend().getScheduledTasksParentDN());
                nextTaskEntry.setDN(nextTaskDN);
                String nextTaskStartTimeName = "ds-task-scheduled-start-time";
                AttributeType taskStartTimeAttrType = DirectoryServer.getAttributeType(nextTaskStartTimeName);
                Attribute nextTaskStartTimeAttr = Attributes.create(taskStartTimeAttrType, nextTaskStartTime);
                nextTaskEntry.replaceAttribute(nextTaskStartTimeAttr);
                nextTask.initializeTaskInternal(this.taskScheduler, nextTaskEntry);
                nextTask.initializeTask();
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) break block4;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
        return nextTask;
    }

    private void parseTaskTab(String taskSchedule) throws DirectoryException {
        StringTokenizer st = new StringTokenizer(taskSchedule);
        if (st.countTokens() != 5) {
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, BackendMessages.ERR_RECURRINGTASK_INVALID_N_TOKENS.get("ds-recurring-task-schedule"));
        }
        block17: for (TaskTab taskTabToken : TaskTab.values()) {
            String token = st.nextToken();
            switch (taskTabToken) {
                case MINUTE: {
                    try {
                        this.minutesArray = this.parseTaskTabField(token, 0, 59);
                        continue block17;
                    }
                    catch (IllegalArgumentException e) {
                        throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, BackendMessages.ERR_RECURRINGTASK_INVALID_MINUTE_TOKEN.get("ds-recurring-task-schedule"));
                    }
                }
                case HOUR: {
                    try {
                        this.hoursArray = this.parseTaskTabField(token, 0, 23);
                        continue block17;
                    }
                    catch (IllegalArgumentException e) {
                        throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, BackendMessages.ERR_RECURRINGTASK_INVALID_HOUR_TOKEN.get("ds-recurring-task-schedule"));
                    }
                }
                case DAY: {
                    try {
                        this.daysArray = this.parseTaskTabField(token, 1, 31);
                        continue block17;
                    }
                    catch (IllegalArgumentException e) {
                        throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, BackendMessages.ERR_RECURRINGTASK_INVALID_DAY_TOKEN.get("ds-recurring-task-schedule"));
                    }
                }
                case MONTH: {
                    try {
                        this.monthArray = this.parseTaskTabField(token, 1, 12);
                        continue block17;
                    }
                    catch (IllegalArgumentException e) {
                        throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, BackendMessages.ERR_RECURRINGTASK_INVALID_MONTH_TOKEN.get("ds-recurring-task-schedule"));
                    }
                }
                case WEEKDAY: {
                    try {
                        this.weekdayArray = this.parseTaskTabField(token, 0, 6);
                        continue block17;
                    }
                    catch (IllegalArgumentException e) {
                        throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, BackendMessages.ERR_RECURRINGTASK_INVALID_WEEKDAY_TOKEN.get("ds-recurring-task-schedule"));
                    }
                }
            }
        }
    }

    private boolean[] parseTaskTabField(String tabField, int minValue, int maxValue) throws IllegalArgumentException {
        boolean[] valueList = new boolean[maxValue + 1];
        Arrays.fill(valueList, false);
        if (tabField.equals("*")) {
            for (int i = minValue; i <= maxValue; ++i) {
                valueList[i] = true;
            }
            return valueList;
        }
        if (exactPattern.matcher(tabField).matches()) {
            int value = Integer.parseInt(tabField);
            if (value >= minValue && value <= maxValue) {
                valueList[value] = true;
                return valueList;
            }
            throw new IllegalArgumentException();
        }
        if (rangePattern.matcher(tabField).matches()) {
            int endValue;
            StringTokenizer st = new StringTokenizer(tabField, "-");
            int startValue = Integer.parseInt(st.nextToken());
            if (startValue < (endValue = Integer.parseInt(st.nextToken())) && startValue >= minValue && endValue <= maxValue) {
                for (int i = startValue; i <= endValue; ++i) {
                    valueList[i] = true;
                }
                return valueList;
            }
            throw new IllegalArgumentException();
        }
        if (listPattern.matcher(tabField).matches()) {
            StringTokenizer st = new StringTokenizer(tabField, ",");
            while (st.hasMoreTokens()) {
                int value = Integer.parseInt(st.nextToken());
                if (value >= minValue && value <= maxValue) {
                    valueList[value] = true;
                    continue;
                }
                throw new IllegalArgumentException();
            }
            return valueList;
        }
        throw new IllegalArgumentException();
    }

    private int getNextTimeSlice(boolean[] timesList, int fromNow) {
        for (int i = fromNow; i < timesList.length; ++i) {
            if (!timesList[i]) continue;
            return i;
        }
        return -1;
    }

    private Date getNextIteration() throws IllegalArgumentException {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setFirstDayOfWeek(1);
        calendar.add(12, 1);
        calendar.set(13, 0);
        calendar.setLenient(false);
        while (true) {
            int minute;
            if ((minute = this.getNextTimeSlice(this.minutesArray, calendar.get(12))) == -1) {
                calendar.set(12, 0);
                calendar.add(11, 1);
                continue;
            }
            calendar.set(12, minute);
            int hour = this.getNextTimeSlice(this.hoursArray, calendar.get(11));
            if (hour == -1) {
                calendar.set(11, 0);
                calendar.add(5, 1);
                continue;
            }
            calendar.set(11, hour);
            int day = this.getNextTimeSlice(this.daysArray, calendar.get(5));
            if (day == -1 || day > calendar.getActualMaximum(5)) {
                calendar.set(5, 1);
                calendar.add(2, 1);
                continue;
            }
            calendar.set(5, day);
            int month = this.getNextTimeSlice(this.monthArray, calendar.get(2) + 1);
            if (month == -1) {
                calendar.set(2, 0);
                calendar.add(1, 1);
                continue;
            }
            calendar.set(2, month - 1);
            int weekday = this.getNextTimeSlice(this.weekdayArray, calendar.get(7) - 1);
            if (weekday != -1 && weekday == calendar.get(7) - 1) break;
            calendar.add(5, 1);
        }
        return calendar.getTime();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TaskTab {
        MINUTE,
        HOUR,
        DAY,
        MONTH,
        WEEKDAY;

    }
}

