/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import java.io.IOException;
import java.util.zip.DataFormatException;
import org.opends.messages.JebMessages;
import org.opends.messages.Message;
import org.opends.server.api.CompressedSchema;
import org.opends.server.backends.jeb.DataConfig;
import org.opends.server.backends.jeb.DatabaseContainer;
import org.opends.server.backends.jeb.EntryContainer;
import org.opends.server.backends.jeb.EntryID;
import org.opends.server.core.DirectoryServer;
import org.opends.server.crypto.CryptoManagerImpl;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.protocols.asn1.ASN1Reader;
import org.opends.server.protocols.asn1.ASN1Writer;
import org.opends.server.types.ByteString;
import org.opends.server.types.ByteStringBuilder;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.LDAPException;

public class ID2Entry
extends DatabaseContainer {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private DataConfig dataConfig;
    private static ThreadLocal<EntryCoder> entryCodingBuffers = new ThreadLocal();

    ID2Entry(String name, DataConfig dataConfig, Environment env, EntryContainer entryContainer) throws DatabaseException {
        super(name, env, entryContainer);
        this.dataConfig = dataConfig;
        DatabaseConfig dbNodupsConfig = new DatabaseConfig();
        if (env.getConfig().getReadOnly()) {
            dbNodupsConfig.setReadOnly(true);
            dbNodupsConfig.setAllowCreate(false);
            dbNodupsConfig.setTransactional(false);
        } else if (!env.getConfig().getTransactional()) {
            dbNodupsConfig.setAllowCreate(true);
            dbNodupsConfig.setTransactional(false);
            dbNodupsConfig.setDeferredWrite(true);
        } else {
            dbNodupsConfig.setAllowCreate(true);
            dbNodupsConfig.setTransactional(true);
        }
        this.dbConfig = dbNodupsConfig;
    }

    public static Entry entryFromDatabase(ByteString bytes, CompressedSchema compressedSchema) throws DirectoryException, ASN1Exception, LDAPException, DataFormatException, IOException {
        EntryCoder coder = entryCodingBuffers.get();
        if (coder == null) {
            coder = new EntryCoder();
            entryCodingBuffers.set(coder);
        }
        return coder.decode(bytes, compressedSchema);
    }

    public static ByteString entryToDatabase(Entry entry, DataConfig dataConfig) throws DirectoryException {
        EntryCoder coder = entryCodingBuffers.get();
        if (coder == null) {
            coder = new EntryCoder();
            entryCodingBuffers.set(coder);
        }
        return coder.encodeCopy(entry, dataConfig);
    }

    public boolean insert(Transaction txn, EntryID id, Entry entry) throws DatabaseException, DirectoryException {
        DatabaseEntry data;
        OperationStatus status;
        DatabaseEntry key = id.getDatabaseEntry();
        EntryCoder coder = entryCodingBuffers.get();
        if (coder == null) {
            coder = new EntryCoder();
            entryCodingBuffers.set(coder);
        }
        return (status = this.insert(txn, key, data = coder.encodeInternal(entry, this.dataConfig))) == OperationStatus.SUCCESS;
    }

    public boolean put(Transaction txn, EntryID id, Entry entry) throws DatabaseException, DirectoryException {
        DatabaseEntry data;
        OperationStatus status;
        DatabaseEntry key = id.getDatabaseEntry();
        EntryCoder coder = entryCodingBuffers.get();
        if (coder == null) {
            coder = new EntryCoder();
            entryCodingBuffers.set(coder);
        }
        return (status = this.put(txn, key, data = coder.encodeInternal(entry, this.dataConfig))) == OperationStatus.SUCCESS;
    }

    public boolean putRaw(Transaction txn, DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
        OperationStatus status = this.put(txn, key, data);
        return status == OperationStatus.SUCCESS;
    }

    public boolean remove(Transaction txn, EntryID id) throws DatabaseException {
        DatabaseEntry key = id.getDatabaseEntry();
        OperationStatus status = this.delete(txn, key);
        return status == OperationStatus.SUCCESS;
    }

    public Entry get(Transaction txn, EntryID id, LockMode lockMode) throws DirectoryException, DatabaseException {
        DatabaseEntry data;
        DatabaseEntry key = id.getDatabaseEntry();
        OperationStatus status = this.read(txn, key, data = new DatabaseEntry(), lockMode);
        if (status != OperationStatus.SUCCESS) {
            return null;
        }
        try {
            Entry entry = ID2Entry.entryFromDatabase(ByteString.wrap(data.getData()), this.entryContainer.getRootContainer().getCompressedSchema());
            entry.processVirtualAttributes();
            return entry;
        }
        catch (Exception e) {
            Message message = JebMessages.ERR_JEB_ENTRY_DATABASE_CORRUPT.get(id.toString());
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
        }
    }

    public void setDataConfig(DataConfig dataConfig) {
        this.dataConfig = dataConfig;
    }

    private static class EntryCoder {
        ByteStringBuilder encodedBuffer = new ByteStringBuilder();
        private ByteStringBuilder entryBuffer = new ByteStringBuilder();
        private ByteStringBuilder compressedEntryBuffer = new ByteStringBuilder();
        private ASN1Writer writer = ASN1.getWriter(this.encodedBuffer);

        private EntryCoder() {
        }

        private Entry decode(ByteString bytes, CompressedSchema compressedSchema) throws DirectoryException, ASN1Exception, LDAPException, DataFormatException, IOException {
            byte formatVersion = bytes.byteAt(0);
            if (formatVersion != 1) {
                Message message = JebMessages.ERR_JEB_INCOMPATIBLE_ENTRY_VERSION.get(formatVersion);
                throw new ASN1Exception(message);
            }
            ASN1Reader reader = ASN1.getReader(bytes.subSequence(1, bytes.length()));
            reader.readStartSequence();
            int uncompressedSize = (int)reader.readInteger();
            if (uncompressedSize > 0) {
                this.entryBuffer.clear();
                this.compressedEntryBuffer.clear();
                reader.readOctetString(this.compressedEntryBuffer);
                CryptoManagerImpl cryptoManager = DirectoryServer.getCryptoManager();
                this.compressedEntryBuffer.uncompress(this.entryBuffer, cryptoManager, uncompressedSize);
                return Entry.decode(this.entryBuffer.asReader(), compressedSchema);
            }
            ByteString encodedEntry = reader.readOctetString();
            return Entry.decode(encodedEntry.asReader(), compressedSchema);
        }

        private ByteString encodeCopy(Entry entry, DataConfig dataConfig) throws DirectoryException {
            this.encodeVolatile(entry, dataConfig);
            return this.encodedBuffer.toByteString();
        }

        private DatabaseEntry encodeInternal(Entry entry, DataConfig dataConfig) throws DirectoryException {
            this.encodeVolatile(entry, dataConfig);
            return new DatabaseEntry(this.encodedBuffer.getBackingArray(), 0, this.encodedBuffer.length());
        }

        private void encodeVolatile(Entry entry, DataConfig dataConfig) throws DirectoryException {
            block4: {
                this.encodedBuffer.clear();
                this.entryBuffer.clear();
                this.compressedEntryBuffer.clear();
                entry.encode(this.entryBuffer, dataConfig.getEntryEncodeConfig());
                this.encodedBuffer.append((byte)1);
                try {
                    this.writer.writeStartSequence((byte)96);
                    CryptoManagerImpl cryptoManager = DirectoryServer.getCryptoManager();
                    if (dataConfig.isCompressed() && cryptoManager != null && this.entryBuffer.compress(this.compressedEntryBuffer, cryptoManager)) {
                        this.writer.writeInteger(this.entryBuffer.length());
                        this.writer.writeOctetString(this.compressedEntryBuffer);
                    } else {
                        this.writer.writeInteger(0);
                        this.writer.writeOctetString(this.entryBuffer);
                    }
                    this.writer.writeEndSequence();
                }
                catch (IOException ioe) {
                    if (!DebugLogger.debugEnabled()) break block4;
                    TRACER.debugCaught(DebugLogLevel.ERROR, ioe);
                }
            }
        }
    }
}

