/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.DatabaseEntry;
import org.opends.server.backends.jeb.JebFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntryID
implements Comparable<EntryID> {
    private final Long id;
    private DatabaseEntry data = null;

    public EntryID(long id) {
        this.id = id;
    }

    public EntryID(Long id) {
        this.id = id;
    }

    public EntryID(DatabaseEntry databaseEntry) {
        this.data = databaseEntry;
        this.id = JebFormat.entryIDFromDatabase(this.data.getData());
    }

    public long longValue() {
        return this.id;
    }

    public DatabaseEntry getDatabaseEntry() {
        if (this.data == null) {
            this.data = new DatabaseEntry();
            this.data.setData(JebFormat.entryIDToDatabase(this.id));
        }
        return this.data;
    }

    @Override
    public int compareTo(EntryID that) throws ClassCastException {
        return this.id.compareTo(that.id);
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        if (!(that instanceof EntryID)) {
            return false;
        }
        return this.id.equals(((EntryID)that).id);
    }

    public int hashCode() {
        return (int)this.id.longValue();
    }

    public String toString() {
        return this.id.toString();
    }
}

