/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.PreloadConfig;
import com.sleepycat.je.PreloadStats;
import com.sleepycat.je.Transaction;
import org.opends.server.backends.jeb.EntryContainer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.DebugLogLevel;

public abstract class DatabaseContainer {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    protected EntryContainer entryContainer;
    protected DatabaseConfig dbConfig;
    protected String name;
    private Environment env;
    private Database database;

    protected DatabaseContainer(String name, Environment env, EntryContainer entryContainer) throws DatabaseException {
        this.env = env;
        this.entryContainer = entryContainer;
        this.name = name;
    }

    public void open() throws DatabaseException {
        if (this.dbConfig.getTransactional()) {
            Transaction txn = this.entryContainer.beginTransaction();
            try {
                this.database = this.env.openDatabase(txn, this.name, this.dbConfig);
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugVerbose("JE database %s opened. txnid=%d", this.database.getDatabaseName(), txn.getId());
                }
                EntryContainer.transactionCommit(txn);
            }
            catch (DatabaseException e) {
                EntryContainer.transactionAbort(txn);
                throw e;
            }
        } else {
            this.database = this.env.openDatabase(null, this.name, this.dbConfig);
            if (DebugLogger.debugEnabled()) {
                TRACER.debugVerbose("JE database %s opened. txnid=none", this.database.getDatabaseName());
            }
        }
    }

    synchronized void close() throws DatabaseException {
        if (this.dbConfig.getDeferredWrite()) {
            this.database.sync();
        }
        this.database.close();
        this.database = null;
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Closed database %s", this.name);
        }
    }

    protected OperationStatus put(Transaction txn, DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
        OperationStatus status = this.database.put(txn, key, data);
        if (DebugLogger.debugEnabled()) {
            TRACER.debugJEAccess(DebugLogLevel.VERBOSE, status, this.database, txn, key, data);
        }
        return status;
    }

    protected OperationStatus read(Transaction txn, DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        OperationStatus status = this.database.get(txn, key, data, lockMode);
        if (DebugLogger.debugEnabled()) {
            TRACER.debugJEAccess(DebugLogLevel.VERBOSE, status, this.database, txn, key, data);
        }
        return status;
    }

    protected OperationStatus insert(Transaction txn, DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
        OperationStatus status = this.database.putNoOverwrite(txn, key, data);
        if (DebugLogger.debugEnabled()) {
            TRACER.debugJEAccess(DebugLogLevel.VERBOSE, status, this.database, txn, key, data);
        }
        return status;
    }

    protected OperationStatus delete(Transaction txn, DatabaseEntry key) throws DatabaseException {
        OperationStatus status = this.database.delete(txn, key);
        if (DebugLogger.debugEnabled()) {
            TRACER.debugJEAccess(DebugLogLevel.VERBOSE, status, this.database, txn, key, null);
        }
        return status;
    }

    public Cursor openCursor(Transaction txn, CursorConfig cursorConfig) throws DatabaseException {
        return this.database.openCursor(txn, cursorConfig);
    }

    public long getRecordCount() throws DatabaseException {
        long count = this.database.count();
        if (DebugLogger.debugEnabled()) {
            TRACER.debugJEAccess(DebugLogLevel.VERBOSE, OperationStatus.SUCCESS, this.database, null, null, null);
        }
        return count;
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public PreloadStats preload(PreloadConfig config) throws DatabaseException {
        return this.database.preload(config);
    }

    void setName(String name) {
        this.name = name;
    }
}

